/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.GeneralName;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralNames {
    private List<GeneralName> names = new LinkedList<GeneralName>();

    public GeneralNames(byte[] encoded) throws IOException {
        DERReader der = new DERReader(encoded);
        DERValue nameList = der.read();
        if (!nameList.isConstructed()) {
            throw new IOException("malformed GeneralNames");
        }
        int len = 0;
        while (len < nameList.getLength()) {
            DERValue name = der.read();
            GeneralName generalName = new GeneralName(name.getEncoded());
            this.names.add(generalName);
            len += name.getEncodedLength();
        }
    }

    public List<GeneralName> getNames() {
        return Collections.unmodifiableList(this.names);
    }

    public String toString() {
        return String.valueOf(GeneralNames.class.getName()) + " [ " + this.names + " ]";
    }
}

