/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.rsa;

import gnu.java.security.key.IKeyPairGenerator;
import gnu.java.security.key.rsa.GnuRSAPrivateKey;
import gnu.java.security.key.rsa.GnuRSAPublicKey;
import gnu.java.security.util.PRNG;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Map;
import java.util.logging.Logger;

public class RSAKeyPairGenerator
implements IKeyPairGenerator {
    private static final Logger log = Logger.getLogger(RSAKeyPairGenerator.class.getName());
    private static final BigInteger ONE = BigInteger.ONE;
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    public static final String MODULUS_LENGTH = "gnu.crypto.rsa.L";
    public static final String SOURCE_OF_RANDOMNESS = "gnu.crypto.rsa.prng";
    public static final String RSA_PARAMETERS = "gnu.crypto.rsa.params";
    public static final String PREFERRED_ENCODING_FORMAT = "gnu.crypto.rsa.encoding";
    private static final int DEFAULT_MODULUS_LENGTH = 1024;
    private static final int DEFAULT_ENCODING_FORMAT = 1;
    private int L;
    private BigInteger e = BigInteger.valueOf(65537L);
    private SecureRandom rnd = null;
    private PRNG prng = null;
    private int preferredFormat;

    public String name() {
        return "rsa";
    }

    public void setup(Map attributes) {
        this.rnd = (SecureRandom)attributes.get(SOURCE_OF_RANDOMNESS);
        RSAKeyGenParameterSpec params = (RSAKeyGenParameterSpec)attributes.get(RSA_PARAMETERS);
        if (params != null) {
            this.L = params.getKeysize();
            this.e = params.getPublicExponent();
        } else {
            Integer l = (Integer)attributes.get(MODULUS_LENGTH);
            int n = this.L = l == null ? 1024 : l;
        }
        if (this.L < 1024) {
            throw new IllegalArgumentException(MODULUS_LENGTH);
        }
        Integer formatID = (Integer)attributes.get(PREFERRED_ENCODING_FORMAT);
        this.preferredFormat = formatID == null ? 1 : formatID;
    }

    public KeyPair generate() {
        BigInteger q;
        BigInteger n;
        BigInteger p;
        int M = (this.L + 1) / 2;
        BigInteger lower = TWO.pow(M - 1);
        BigInteger upper = TWO.pow(M).subtract(ONE);
        byte[] kb = new byte[(M + 7) / 8];
        do {
            this.nextRandomBytes(kb);
        } while ((p = new BigInteger(1, kb).setBit(0)).compareTo(lower) < 0 || p.compareTo(upper) > 0 || !p.isProbablePrime(80) || !p.gcd(this.e).equals(ONE));
        do {
            this.nextRandomBytes(kb);
        } while ((n = p.multiply(q = new BigInteger(1, kb).setBit(0))).bitLength() != this.L || !q.isProbablePrime(80) || !q.gcd(this.e).equals(ONE));
        BigInteger phi = p.subtract(ONE).multiply(q.subtract(ONE));
        BigInteger d = this.e.modInverse(phi);
        GnuRSAPublicKey pubK = new GnuRSAPublicKey(this.preferredFormat, n, this.e);
        GnuRSAPrivateKey secK = new GnuRSAPrivateKey(this.preferredFormat, p, q, this.e, d);
        KeyPair result = new KeyPair(pubK, secK);
        return result;
    }

    private void nextRandomBytes(byte[] buffer) {
        if (this.rnd != null) {
            this.rnd.nextBytes(buffer);
        } else {
            this.getDefaultPRNG().nextBytes(buffer);
        }
    }

    private PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }
}

