/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.getopt;

import gnu.classpath.tools.getopt.FileArgumentCallback;
import gnu.classpath.tools.getopt.Messages;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import java.io.PrintStream;
import java.text.BreakIterator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;

public class Parser {
    public static final int MAX_LINE_LENGTH = 80;
    private String programName;
    private String headerText;
    private String footerText;
    private boolean longOnly;
    private ArrayList options;
    private ArrayList optionGroups = new ArrayList();
    private OptionGroup defaultGroup = new OptionGroup();
    private OptionGroup finalGroup;
    private int currentIndex;
    private String[] args;

    public Parser(String programName, String versionString) {
        this(programName, versionString, false);
    }

    protected static void formatText(PrintStream out, String text) {
        Parser.formatText(out, text, Locale.getDefault());
    }

    protected static void formatText(PrintStream out, String text, Locale aLocale) {
        BreakIterator bit = BreakIterator.getLineInstance(aLocale);
        String[] lines = text.split("\n");
        int i = 0;
        while (i < lines.length) {
            int finish;
            text = lines[i];
            bit.setText(text);
            int length = 0;
            int start = bit.first();
            while ((finish = bit.next()) != -1) {
                String word = text.substring(start, finish);
                if ((length += word.length()) >= 80) {
                    out.println();
                    length = word.length();
                }
                out.print(word);
                start = finish;
            }
            out.println();
            ++i;
        }
    }

    public Parser(String programName, final String versionString, boolean longOnly) {
        this.programName = programName;
        this.longOnly = longOnly;
        this.finalGroup = new OptionGroup(Messages.getString("Parser.StdOptions"));
        this.finalGroup.add(new Option("help", Messages.getString("Parser.PrintHelp")){

            public void parsed(String argument) throws OptionException {
                Parser.this.printHelp(System.out);
                System.exit(0);
            }
        });
        this.finalGroup.add(new Option("version", Messages.getString("Parser.PrintVersion")){

            public void parsed(String argument) throws OptionException {
                System.out.println(versionString);
                System.exit(0);
            }
        });
        this.add(this.finalGroup);
        this.add(this.defaultGroup);
    }

    public synchronized void setHeader(String headerText) {
        this.headerText = headerText;
    }

    public synchronized void setFooter(String footerText) {
        this.footerText = footerText;
    }

    public synchronized void add(Option opt) {
        this.defaultGroup.add(opt);
    }

    protected synchronized void addFinal(Option opt) {
        this.finalGroup.add(opt);
    }

    public synchronized void add(OptionGroup group) {
        if (this.optionGroups.isEmpty()) {
            this.optionGroups.add(group);
        } else {
            this.optionGroups.add(this.optionGroups.size() - 1, group);
        }
    }

    private void requireOptions() {
        if (this.options != null) {
            return;
        }
        this.options = new ArrayList();
        for (OptionGroup group : this.optionGroups) {
            this.options.addAll(group.options);
        }
    }

    public void printHelp() {
        this.printHelp(System.out);
    }

    synchronized void printHelp(PrintStream out) {
        this.requireOptions();
        if (this.headerText != null) {
            Parser.formatText(out, this.headerText);
            out.println();
        }
        for (OptionGroup group : this.optionGroups) {
            if (group.options.isEmpty()) continue;
            group.printHelp(out, this.longOnly);
            out.println();
        }
        if (this.footerText != null) {
            Parser.formatText(out, this.footerText);
        }
    }

    protected void validate() throws OptionException {
    }

    private String getArgument(String request) throws OptionException {
        ++this.currentIndex;
        if (this.currentIndex >= this.args.length) {
            MessageFormat.format(Messages.getString("Parser.ArgReqd"), request);
            throw new OptionException(request);
        }
        return this.args[this.currentIndex];
    }

    private void handleLongOption(String real, int index) throws OptionException {
        String option;
        String justName = option = real.substring(index);
        int eq = option.indexOf(61);
        if (eq != -1) {
            justName = option.substring(0, eq);
        }
        boolean isPlainShort = justName.length() == 1;
        char shortName = justName.charAt(0);
        Option found = null;
        int i = this.options.size() - 1;
        while (i >= 0) {
            Option opt = (Option)this.options.get(i);
            if (justName.equals(opt.getLongName())) {
                found = opt;
                break;
            }
            if ((isPlainShort || opt.isJoined()) && opt.getShortName() == shortName) {
                if (!isPlainShort) {
                    eq = 0;
                }
                found = opt;
                break;
            }
            --i;
        }
        if (found == null) {
            String msg = MessageFormat.format(Messages.getString("Parser.Unrecognized"), real);
            throw new OptionException(msg);
        }
        String argument = null;
        if (found.getTakesArgument()) {
            argument = eq == -1 ? this.getArgument(real) : option.substring(eq + 1);
        } else if (eq != -1) {
            String msg = MessageFormat.format(Messages.getString("Parser.NoArg"), real.substring(0, eq + index));
            throw new OptionException(msg);
        }
        found.parsed(argument);
    }

    private void handleShortOptions(String option) throws OptionException {
        int charIndex = 1;
        while (charIndex < option.length()) {
            char optChar = option.charAt(charIndex);
            Option found = null;
            int i = this.options.size() - 1;
            while (i >= 0) {
                Option opt = (Option)this.options.get(i);
                if (optChar == opt.getShortName()) {
                    found = opt;
                    break;
                }
                --i;
            }
            if (found == null) {
                String msg = MessageFormat.format(Messages.getString("Parser.UnrecDash"), "" + optChar);
                throw new OptionException(msg);
            }
            String argument = null;
            if (found.getTakesArgument()) {
                if (found.isJoined() && charIndex + 1 < option.length()) {
                    argument = option.substring(charIndex + 1);
                    charIndex = option.length();
                } else {
                    argument = this.getArgument("-" + optChar);
                }
            }
            found.parsed(argument);
            ++charIndex;
        }
    }

    public synchronized void parse(String[] inArgs, FileArgumentCallback files) {
        this.requireOptions();
        try {
            this.args = inArgs;
            this.currentIndex = 0;
            while (this.currentIndex < this.args.length) {
                if (this.args[this.currentIndex].length() == 0 || this.args[this.currentIndex].charAt(0) != '-' || "-".equals(this.args[this.currentIndex])) {
                    files.notifyFile(this.args[this.currentIndex]);
                } else {
                    if ("--".equals(this.args[this.currentIndex])) break;
                    if (this.args[this.currentIndex].charAt(1) == '-') {
                        this.handleLongOption(this.args[this.currentIndex], 2);
                    } else if (this.longOnly) {
                        this.handleLongOption(this.args[this.currentIndex], 1);
                    } else {
                        this.handleShortOptions(this.args[this.currentIndex]);
                    }
                }
                ++this.currentIndex;
            }
            ++this.currentIndex;
            while (this.currentIndex < this.args.length) {
                files.notifyFile(this.args[this.currentIndex]);
                ++this.currentIndex;
            }
            this.validate();
        }
        catch (OptionException err) {
            System.err.println(String.valueOf(this.programName) + ": " + err.getMessage());
            String fmt = this.longOnly ? Messages.getString("Parser.TryHelpShort") : Messages.getString("Parser.TryHelpLong");
            String msg = MessageFormat.format(fmt, this.programName);
            System.err.println(String.valueOf(this.programName) + ": " + msg);
            System.exit(1);
        }
    }

    public String[] parse(String[] inArgs) {
        final ArrayList fileResult = new ArrayList();
        this.parse(inArgs, new FileArgumentCallback(){

            public void notifyFile(String fileArgument) {
                fileResult.add(fileArgument);
            }
        });
        return fileResult.toArray(new String[0]);
    }
}

