/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ********************************************************************************/
package org.eclipse.wst.rdb.sqleditor.internal.actions;

import org.eclipse.swt.widgets.Composite;

/**
 * This class defines a composite component that contains a combo box in which
 * the user can select or enter a statement terminator string.
 */
public class SQLSetStatementTerminatorComposite extends Composite {

    /** The statement terminator string. */
    private String fStmtTerminator;
    
    /**
     * Constructs an instance of this class with the given parent composite
     * and style flags.
     * 
     * @param parent the parent composite
     * @param style the style flags for this composite
     */
    public SQLSetStatementTerminatorComposite( Composite parent, int style ) {
        super( parent, style );
    }

    /**
     * Gets the current statement terminator string.
     * 
     * @return the current statement terminator
     */
    public String getStatementTerminator() {
        return fStmtTerminator;
    }

    /**
     * Sets the current statement terminator to the given string.
     * 
     * @param stmtTerminator the statement terminator to use
     */
    public void setStatementTerminator( String stmtTerminator ) {
        fStmtTerminator = stmtTerminator;
    }

}
