/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.util;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PlatformStatusLineUtil {
    static /* synthetic */ Class class$0;

    public static void addOneTimeClearListener() {
        IEditorPart editor = PlatformStatusLineUtil.getActiveEditor();
        boolean added = false;
        if (editor != null) {
            Control control;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Control");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((control = (Control)editor.getAdapter((Class)clazz)) instanceof StyledText) {
                PlatformStatusLineUtil.addOneTimeClearListener((StyledText)control);
                added = true;
            }
        }
        if (!added) {
            PlatformStatusLineUtil.displayMessage(null);
        }
    }

    private static void addOneTimeClearListener(StyledText widget) {
        new OneTimeListener(widget, new ClearErrorMessage());
    }

    public static void clearStatusLine() {
        PlatformStatusLineUtil.displayMessage(null);
    }

    public static void displayErrorMessage(String msg) {
        PlatformStatusLineUtil.displayMessage(msg);
        PlatformUI.getWorkbench().getDisplay().beep();
    }

    public static void displayMessage(String msg) {
        IEditorPart editor = PlatformStatusLineUtil.getActiveEditor();
        if (editor != null) {
            editor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(msg);
        }
    }

    private static IEditorPart getActiveEditor() {
        IWorkbenchPage page;
        IEditorPart editor = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        if (window != null && (page = window.getActivePage()) != null) {
            editor = page.getActiveEditor();
        }
        return editor;
    }

    private PlatformStatusLineUtil() {
    }

    private static class ClearErrorMessage
    implements Runnable {
        private ClearErrorMessage() {
        }

        public void run() {
            PlatformStatusLineUtil.displayMessage(null);
        }
    }

    private static class OneTimeListener
    extends FocusAdapter
    implements VerifyKeyListener,
    SelectionListener,
    MouseListener {
        private Runnable fRunner = null;
        private StyledText fStyledText;

        public OneTimeListener(StyledText target, Runnable r) {
            this.fStyledText = target;
            this.fRunner = r;
            this.fStyledText.addVerifyKeyListener((VerifyKeyListener)this);
            this.fStyledText.addFocusListener((FocusListener)this);
            this.fStyledText.addSelectionListener((SelectionListener)this);
            this.fStyledText.addMouseListener((MouseListener)this);
        }

        public void focusLost(FocusEvent e) {
            this.unhookAndRun();
        }

        public void mouseDoubleClick(MouseEvent e) {
            this.unhookAndRun();
        }

        public void mouseDown(MouseEvent e) {
            this.unhookAndRun();
        }

        public void mouseUp(MouseEvent e) {
        }

        private void unhookAndRun() {
            this.fStyledText.removeVerifyKeyListener((VerifyKeyListener)this);
            this.fStyledText.removeFocusListener((FocusListener)this);
            this.fStyledText.removeSelectionListener((SelectionListener)this);
            this.fStyledText.removeMouseListener((MouseListener)this);
            this.fStyledText.getDisplay().asyncExec(this.fRunner);
        }

        public void verifyKey(VerifyEvent event) {
            this.unhookAndRun();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.unhookAndRun();
        }

        public void widgetSelected(SelectionEvent e) {
            this.unhookAndRun();
        }
    }
}

