/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentService;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentServiceImpl;

public class ResourceUtil {
    public static void resolveDanglingReferences(Resource resource) {
        HashSet visited = new HashSet();
        LinkedList roots = new LinkedList();
        roots.addAll(resource.getContents());
        Iterator it = roots.iterator();
        while (it.hasNext()) {
            ResourceUtil.resolveDanglingReferencesInternal(resource, (EObject)it.next(), visited);
        }
    }

    private static void resolveDanglingReferencesInternal(Resource resource, EObject obj, Set visited) {
        visited.add(obj);
        ArrayList references = new ArrayList(obj.eCrossReferences());
        Iterator it = references.iterator();
        while (it.hasNext()) {
            EObject reference = (EObject)it.next();
            if (reference == null) continue;
            if (reference.eResource() == null && !reference.eIsProxy()) {
                EObject needResource = reference;
                while (needResource.eContainer() != null) {
                    needResource = needResource.eContainer();
                }
                resource.getContents().add((Object)needResource);
            }
            if (visited.contains(reference)) continue;
            ResourceUtil.resolveDanglingReferencesInternal(resource, reference, visited);
        }
        ArrayList contents = new ArrayList(obj.eContents());
        it = contents.iterator();
        while (it.hasNext()) {
            EObject content = (EObject)it.next();
            if (content == null || visited.contains(content)) continue;
            ResourceUtil.resolveDanglingReferencesInternal(resource, content, visited);
        }
    }

    public static EObject[] getRootElements(Resource resource) {
        ContainmentService s = ContainmentServiceImpl.INSTANCE;
        ArrayList<EObject> roots = new ArrayList<EObject>();
        Iterator it = resource.getContents().iterator();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (s.getContainer(obj) != null) break;
            roots.add(obj);
        }
        EObject[] r = new EObject[roots.size()];
        roots.toArray(r);
        return r;
    }
}

