/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jem.internal.beaninfo.core.SearchpathEntry;
import org.eclipse.jem.internal.beaninfo.ui.BPListElement;
import org.eclipse.jem.internal.beaninfo.ui.BPSearchListElement;
import org.eclipse.jem.internal.beaninfo.ui.BeanInfoUIMessages;
import org.eclipse.jem.internal.beaninfo.ui.BeaninfoPathsBlock;
import org.eclipse.jem.internal.beaninfo.ui.IBuildSearchPage;
import org.eclipse.jem.internal.beaninfo.ui.PackageOnlyContentProvider;
import org.eclipse.jem.internal.beaninfo.ui.SPListElementSorter;
import org.eclipse.jem.internal.beaninfo.ui.SearchPathListLabelProvider;
import org.eclipse.jem.internal.beaninfo.ui.StatusHelper;
import org.eclipse.jem.internal.beaninfo.ui.TypedViewerFilter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class PackagesWorkbookPage
implements IBuildSearchPage {
    private Label label = null;
    private Table table = null;
    private Composite buttonBar = null;
    private Button choosePackagesButton = null;
    private Button chooseDefPathsButton = null;
    private Label spacer1 = null;
    private Button removeButton = null;
    private IJavaProject javaProject = null;
    private SearchPathListLabelProvider labelProvider = null;
    private BeaninfoPathsBlock beaninfosPathsBlock = null;
    private IPackageFragmentRoot[][] rootsPerRawEntry;
    private IClasspathEntry[] rawList;
    private TableViewer tableViewer;
    private List packagesList = null;
    private Composite top;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public PackagesWorkbookPage(IWorkspaceRoot workspaceRoot, BeaninfoPathsBlock beaninfosPathsBlock) {
        this.beaninfosPathsBlock = beaninfosPathsBlock;
        this.packagesList = new ArrayList();
        this.labelProvider = new SearchPathListLabelProvider();
    }

    public Control createControl(Composite parent) {
        this.top = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.top.setLayout((Layout)gridLayout);
        this.label = new Label(this.top, 0);
        this.label.setText(BeanInfoUIMessages.PackagesWorkbook_LabelText);
        this.label.setLayoutData((Object)gridData);
        this.createTable();
        this.createButtonBar();
        this.top.setSize(new Point(300, 200));
        this.updateEnabledStates();
        return this.top;
    }

    private void createTable() {
        GridData gridData1 = new GridData();
        gridData1.grabExcessVerticalSpace = true;
        gridData1.verticalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.horizontalAlignment = 4;
        this.table = new Table(this.top, 2818);
        this.table.setLayoutData((Object)gridData1);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PackagesWorkbookPage.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewer.setSorter((ViewerSorter)new SPListElementSorter());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput((Object)this.packagesList);
    }

    private void createButtonBar() {
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.fill = true;
        GridData gridData2 = new GridData();
        gridData2.grabExcessVerticalSpace = true;
        gridData2.verticalAlignment = 4;
        gridData2.horizontalAlignment = 1;
        this.buttonBar = new Composite(this.top, 0);
        this.buttonBar.setLayoutData((Object)gridData2);
        this.buttonBar.setLayout((Layout)rowLayout);
        this.choosePackagesButton = new Button(this.buttonBar, 0);
        this.choosePackagesButton.setText(BeanInfoUIMessages.PackagesWorkbook_ChoosePackages);
        this.choosePackagesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List elementsToAdd = PackagesWorkbookPage.this.choosePackages();
                PackagesWorkbookPage.this.addToPackagesList(elementsToAdd);
            }
        });
        this.chooseDefPathsButton = new Button(this.buttonBar, 0);
        this.chooseDefPathsButton.setText(BeanInfoUIMessages.PackagesWorkbook_ChooseDefinedPaths);
        this.chooseDefPathsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List elementsToAdd = PackagesWorkbookPage.this.chooseDefined();
                PackagesWorkbookPage.this.addToPackagesList(elementsToAdd);
            }
        });
        this.spacer1 = new Label(this.buttonBar, 0);
        this.removeButton = new Button(this.buttonBar, 0);
        this.removeButton.setText(BeanInfoUIMessages.PackagesWorkbook_Remove);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selected = BeaninfoPathsBlock.getSelectedList(PackagesWorkbookPage.this.tableViewer.getSelection());
                PackagesWorkbookPage.this.packagesList.removeAll(selected);
                PackagesWorkbookPage.this.tableViewer.refresh();
                PackagesWorkbookPage.this.pageChanged();
            }
        });
    }

    private void addToPackagesList(final List toAdd) {
        if (toAdd != null && !toAdd.isEmpty()) {
            this.packagesList.addAll(toAdd);
            this.tableViewer.refresh();
            this.table.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PackagesWorkbookPage.this.tableViewer.setSelection((ISelection)new StructuredSelection(toAdd));
                }
            });
            this.pageChanged();
        }
    }

    public void init(IJavaProject jproject) {
        this.javaProject = jproject;
        this.labelProvider.setJavaProject(jproject);
        try {
            this.rawList = this.javaProject.getRawClasspath();
            this.rootsPerRawEntry = new IPackageFragmentRoot[this.rawList.length][];
            int i = 0;
            while (i < this.rawList.length) {
                this.rootsPerRawEntry[i] = this.javaProject.findPackageFragmentRoots(this.rawList[i]);
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            this.rawList = new IClasspathEntry[0];
            this.rootsPerRawEntry = new IPackageFragmentRoot[0][];
        }
        this.updatePackagesList();
    }

    public List getSelection() {
        return BeaninfoPathsBlock.getSelectedList(this.tableViewer.getSelection());
    }

    public void setSelection(List selection) {
        this.tableViewer.setSelection((ISelection)new StructuredSelection(selection));
    }

    private void updatePackagesList() {
        List spelements = this.beaninfosPathsBlock.getSearchpathOrderingPage().getElements();
        ArrayList<BPListElement> packageElements = new ArrayList<BPListElement>(spelements.size());
        int i = 0;
        while (i < spelements.size()) {
            BPListElement spe = (BPListElement)spelements.get(i);
            if (spe instanceof BPSearchListElement) {
                packageElements.add(spe);
            }
            ++i;
        }
        this.packagesList.clear();
        this.packagesList.addAll(packageElements);
        if (this.tableViewer != null && !this.table.isDisposed()) {
            this.tableViewer.refresh();
        }
    }

    private List choosePackages() {
        ChoosePackagesSelectionValidator validator = new ChoosePackagesSelectionValidator();
        Class[] classArray = new Class[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.IPackageFragmentRoot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jdt.core.IPackageFragment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class[] acceptedClasses = classArray;
        Object[] rejectedFragments = this.getFilteredExistingEntries();
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedFragments){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (super.select(viewer, parentElement, element)) {
                    if (element instanceof IPackageFragment) {
                        IPackageFragment pkg = (IPackageFragment)element;
                        try {
                            return pkg.hasChildren();
                        }
                        catch (JavaModelException javaModelException) {
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        PackageOnlyContentProvider provider = new PackageOnlyContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.top.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setTitle(BeanInfoUIMessages.BeaninfoPathsBlock_UI__addsearchpath_title);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setMessage(BeanInfoUIMessages.BeaninfoPathsBlock_UI__addsearchpath_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.javaProject);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            ArrayList<BPListElement> newElements = new ArrayList<BPListElement>(elements.length);
            int i = 0;
            while (i < elements.length) {
                BPListElement newGuy = this.newBPListElement(elements[i]);
                if (newGuy != null) {
                    newElements.add(newGuy);
                }
                ++i;
            }
            return newElements;
        }
        return Collections.EMPTY_LIST;
    }

    protected BPListElement newBPListElement(Object element) {
        SearchpathEntry se = null;
        boolean isExported = false;
        IPackageFragment frag = (IPackageFragment)element;
        IPackageFragmentRoot root = (IPackageFragmentRoot)frag.getParent();
        int i = 0;
        while (i < this.rootsPerRawEntry.length) {
            int j = 0;
            while (j < this.rootsPerRawEntry[i].length) {
                if (this.rootsPerRawEntry[i][j].equals(root)) {
                    isExported = this.rawList[i].isExported() || this.rawList[i].getEntryKind() == 3;
                    se = new SearchpathEntry(this.rawList[i].getEntryKind(), this.rawList[i].getPath(), frag.getElementName());
                    break;
                }
                ++j;
            }
            ++i;
        }
        return new BPSearchListElement(se, false, false, isExported);
    }

    protected Object[] getFilteredExistingEntries() {
        try {
            IPackageFragmentRoot[] roots = this.javaProject.getPackageFragmentRoots();
            List entries = this.packagesList;
            ArrayList fragments = new ArrayList(entries.size());
            Iterator itr = entries.iterator();
            while (itr.hasNext()) {
                BPListElement elem = (BPListElement)itr.next();
                if (!(elem instanceof BPSearchListElement)) continue;
                BPSearchListElement bse = (BPSearchListElement)elem;
                fragments.addAll(this.getPackages(bse, roots));
            }
            return fragments.toArray();
        }
        catch (JavaModelException javaModelException) {
            return new Object[0];
        }
    }

    protected List getPackages(BPSearchListElement element, IPackageFragmentRoot[] roots) {
        String packageName = ((SearchpathEntry)element.getEntry()).getPackage();
        if (packageName == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            ArrayList<IJavaElement> packages = new ArrayList<IJavaElement>(10);
            int i = 0;
            while (i < roots.length) {
                IJavaElement[] pfs = roots[i].getChildren();
                int j = 0;
                while (j < pfs.length) {
                    if (pfs[j].getElementType() == 4 && pfs[j].getElementName().equals(packageName)) {
                        packages.add(pfs[j]);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            return packages;
        }
        catch (JavaModelException javaModelException) {
            return Collections.EMPTY_LIST;
        }
    }

    private List chooseDefined() {
        ArrayList<BPSearchListElement> inputs = new ArrayList<BPSearchListElement>();
        List currentList = this.packagesList;
        int i = 0;
        while (i < this.rawList.length) {
            if (this.rawList[i].getEntryKind() == 2) {
                boolean exists = false;
                int j = 0;
                while (j < currentList.size()) {
                    BPSearchListElement bse = (BPSearchListElement)currentList.get(j);
                    if (bse.getEntry().getKind() == 2 && this.rawList[i].getPath().equals((Object)bse.getEntry().getPath())) {
                        exists = true;
                        break;
                    }
                    ++j;
                }
                if (!exists) {
                    inputs.add(new BPSearchListElement(new SearchpathEntry(2, this.rawList[i].getPath(), null), false, false, this.rawList[i].isExported()));
                }
            }
            ++i;
        }
        SearchPathListLabelProvider labelProvider1 = new SearchPathListLabelProvider(this.javaProject);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.top.getShell(), (ILabelProvider)labelProvider1);
        dialog.setTitle(BeanInfoUIMessages.PackagesWorkbook_SelectionDialog_DefinedPaths_Title);
        dialog.setMessage(BeanInfoUIMessages.PackagesWorkbook_SelectionDialog_DefinedPaths_Message);
        dialog.setElements(inputs.toArray());
        if (dialog.open() == 0) {
            return Arrays.asList(dialog.getResult());
        }
        return Collections.EMPTY_LIST;
    }

    protected void updateButtons() {
        this.chooseDefPathsButton.setEnabled(this.beaninfosPathsBlock.isBeaninfoEnabled());
        this.choosePackagesButton.setEnabled(this.beaninfosPathsBlock.isBeaninfoEnabled());
        List selected = BeaninfoPathsBlock.getSelectedList(this.tableViewer.getSelection());
        this.removeButton.setEnabled(selected != null && selected.size() > 0 && this.beaninfosPathsBlock.isBeaninfoEnabled());
    }

    protected void pageChanged() {
        this.updateSearchpathList();
    }

    private void updateSearchpathList() {
        List searchelements = this.beaninfosPathsBlock.getSearchpathOrderingPage().getElements();
        List packageelements = this.packagesList;
        boolean changeDone = false;
        ListIterator spitr = searchelements.listIterator(searchelements.size());
        while (spitr.hasPrevious()) {
            BPListElement element = (BPListElement)spitr.previous();
            if (!(element instanceof BPSearchListElement) || packageelements.remove(element)) continue;
            spitr.remove();
            changeDone = true;
        }
        searchelements.addAll(packageelements);
        boolean bl = changeDone = changeDone || !packageelements.isEmpty();
        if (changeDone) {
            this.beaninfosPathsBlock.setSearchOrderElements(searchelements);
        }
    }

    protected void updateEnabledStates() {
        this.updateButtons();
        this.table.setEnabled(this.beaninfosPathsBlock.isBeaninfoEnabled());
        this.label.setEnabled(this.beaninfosPathsBlock.isBeaninfoEnabled());
    }

    public void setBeaninfoEnabled(boolean enable) {
        if (this.top != null && !this.top.isDisposed()) {
            this.updateEnabledStates();
        }
    }

    public static class ChoosePackagesSelectionValidator
    implements ISelectionStatusValidator {
        private IStatus fgErrorStatus = StatusHelper.ERROR_STATUS;
        private IStatus fgOKStatus = StatusHelper.OK_STATUS;

        public IStatus validate(Object[] selection) {
            if (this.isValid(selection)) {
                return this.fgOKStatus;
            }
            return this.fgErrorStatus;
        }

        private boolean isValid(Object[] selection) {
            if (selection.length == 0) {
                return false;
            }
            int i = 0;
            while (i < selection.length) {
                if (!(selection[i] instanceof IPackageFragment)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

