/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.jdt.internal.integration.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jst.common.jdt.internal.integration.WTPWorkingCopyManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;

public class WTPUIWorkingCopyManager
extends WTPWorkingCopyManager {
    private IWorkingCopyManager javaWorkingCopyManager;
    private ICompilationUnitDocumentProvider cuDocumentProvider = JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
    private HashMap editorInputs;
    private CoreException lastError;

    public WTPUIWorkingCopyManager() {
        this.javaWorkingCopyManager = JavaUI.getWorkingCopyManager();
    }

    protected void syncConnect(final IEditorInput input, final ICompilationUnit cu) throws CoreException {
        Display d = Display.getCurrent();
        if (d != null) {
            this.lastError = null;
            d.syncExec(new Runnable(){

                public void run() {
                    try {
                        WTPUIWorkingCopyManager.this.connect(input, cu);
                    }
                    catch (CoreException e) {
                        WTPUIWorkingCopyManager.this.lastError = e;
                    }
                }
            });
        } else {
            this.connect(input, cu);
        }
        if (this.lastError != null) {
            throw this.lastError;
        }
    }

    protected void connect(IEditorInput input, ICompilationUnit cu) throws CoreException {
        if (input != null && this.javaWorkingCopyManager != null && this.cuDocumentProvider != null) {
            this.javaWorkingCopyManager.connect(input);
            this.getEditorInputs().put(cu, input);
            IDocument doc = this.cuDocumentProvider.getDocument((Object)input);
            if (doc != null && this.cuDocumentProvider.getAnnotationModel((Object)input) != null) {
                this.cuDocumentProvider.getAnnotationModel((Object)input).connect(doc);
            }
        }
    }

    protected void revertWorkingCopies() {
        if (this.getEditorInputs().isEmpty()) {
            return;
        }
        Iterator it = this.getEditorInputs().values().iterator();
        while (it.hasNext()) {
            IEditorInput input = (IEditorInput)it.next();
            this.revert(input);
        }
    }

    protected void disconnect(IEditorInput input) {
        IDocument doc = this.cuDocumentProvider.getDocument((Object)input);
        this.cuDocumentProvider.getAnnotationModel((Object)input).disconnect(doc);
        this.javaWorkingCopyManager.disconnect(input);
    }

    protected void revert(IEditorInput input) {
        try {
            this.cuDocumentProvider.resetDocument((Object)input);
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        IDocument doc = this.cuDocumentProvider.getDocument((Object)input);
        IAnnotationModel model = this.cuDocumentProvider.getAnnotationModel((Object)input);
        if (model instanceof AbstractMarkerAnnotationModel) {
            AbstractMarkerAnnotationModel markerModel = (AbstractMarkerAnnotationModel)model;
            markerModel.resetMarkers();
        }
        model.disconnect(doc);
        this.javaWorkingCopyManager.disconnect(input);
    }

    protected void disconnectEditorInputs() {
        Iterator it = this.getEditorInputs().values().iterator();
        while (it.hasNext()) {
            IEditorInput input = (IEditorInput)it.next();
            this.disconnect(input);
        }
    }

    protected void discardExistingCompilationUnits() {
        if (this.getEditorInputs().isEmpty()) {
            return;
        }
        Iterator it = this.getEditorInputs().values().iterator();
        while (it.hasNext()) {
            IEditorInput input = (IEditorInput)it.next();
            this.disconnect(input);
        }
    }

    public Set getAffectedFiles() {
        HashSet<IResource> aSet = new HashSet<IResource>();
        Iterator it = this.getEditorInputs().keySet().iterator();
        ICompilationUnit unit = null;
        IResource resource = null;
        while (it.hasNext()) {
            unit = (ICompilationUnit)it.next();
            if (!this.isDirty(unit)) continue;
            try {
                resource = unit.getUnderlyingResource();
            }
            catch (JavaModelException javaModelException) {
                continue;
            }
            if (!(resource instanceof IFile)) continue;
            aSet.add(resource);
        }
        return aSet;
    }

    protected IEditorInput getEditorInput(ICompilationUnit cu) {
        IEditorInput input = this.primGetEditorInput(cu);
        if (input == null) {
            try {
                input = this.getEditorInput((IJavaElement)cu);
            }
            catch (JavaModelException javaModelException) {}
        }
        return input;
    }

    protected IEditorInput getEditorInput(IJavaElement element) throws JavaModelException {
        while (element != null) {
            switch (element.getElementType()) {
                case 5: {
                    IResource resource;
                    ICompilationUnit cu = (ICompilationUnit)element;
                    if (cu.isWorkingCopy()) {
                        cu = cu.getPrimary();
                    }
                    if ((resource = cu.getUnderlyingResource()).getType() != 1) break;
                    return new FileEditorInput((IFile)resource);
                }
                case 6: {
                    return new InternalClassFileEditorInput((IClassFile)element);
                }
            }
            element = element.getParent();
        }
        return null;
    }

    protected HashMap getEditorInputs() {
        if (this.editorInputs == null) {
            this.editorInputs = new HashMap(20);
        }
        return this.editorInputs;
    }

    public ICompilationUnit getExistingWorkingCopy(ICompilationUnit cu) throws CoreException {
        if (cu == null || cu.isWorkingCopy()) {
            return cu;
        }
        ICompilationUnit newCU = super.getExistingWorkingCopy(cu);
        if (newCU != null) {
            return newCU;
        }
        IEditorInput editorInput = this.getEditorInput(cu);
        return this.javaWorkingCopyManager.getWorkingCopy(editorInput);
    }

    public ICompilationUnit getWorkingCopy(ICompilationUnit cu, boolean forNewCU) throws CoreException {
        if (forNewCU) {
            return super.getWorkingCopy(cu, forNewCU);
        }
        return this.primGetWorkingCopy(cu);
    }

    public boolean isDirty(ICompilationUnit cu) {
        if (cu == null) {
            return false;
        }
        ICompilationUnitDocumentProvider p = this.cuDocumentProvider;
        return p == null ? false : p.canSaveDocument((Object)this.getEditorInput(cu));
    }

    public boolean isSaveNeeded() {
        Iterator it = this.getEditorInputs().entrySet().iterator();
        while (it.hasNext()) {
            if (!this.cuDocumentProvider.mustSaveDocument(it.next())) continue;
            return true;
        }
        return false;
    }

    protected void primDispose() {
        super.primDispose();
        this.discardExistingCompilationUnits();
        this.editorInputs = null;
        this.javaWorkingCopyManager = null;
    }

    protected void primRevert() {
        super.primRevert();
        this.revertWorkingCopies();
        this.editorInputs = null;
        this.javaWorkingCopyManager = null;
    }

    protected IEditorInput primGetEditorInput(ICompilationUnit cu) {
        return (IEditorInput)this.getEditorInputs().get(cu);
    }

    protected ICompilationUnit primGetWorkingCopy(ICompilationUnit cu) throws CoreException {
        if (cu == null) {
            return cu;
        }
        ICompilationUnit primary = cu.getPrimary();
        ICompilationUnit newCU = this.getNewCompilationUnitWorkingCopy(primary);
        if (newCU != null) {
            return newCU;
        }
        IEditorInput editorInput = this.primGetEditorInput(primary);
        if (editorInput == null) {
            editorInput = this.getEditorInput(cu);
            this.syncConnect(editorInput, cu);
        }
        if (cu.isWorkingCopy()) {
            return cu;
        }
        return this.javaWorkingCopyManager.getWorkingCopy(editorInput);
    }

    protected void primSaveCompilationUnits(IProgressMonitor monitor) {
        super.primSaveCompilationUnits(null);
        this.saveExistingCompilationUnits(monitor);
    }

    protected void primSaveDocument(IEditorInput input, IDocument doc, IProgressMonitor monitor) throws CoreException {
        try {
            this.cuDocumentProvider.saveDocument(monitor, (Object)input, doc, true);
        }
        catch (CoreException ex) {
            if (!this.isFailedWriteFileFailure((Exception)((Object)ex))) {
                throw ex;
            }
            IResource resource = (IResource)input.getAdapter(IRESOURCE_CLASS);
            if (resource == null || resource.getType() != 1 || !resource.getResourceAttributes().isReadOnly()) {
                throw ex;
            }
            if (this.getSaveHandler().shouldContinueAndMakeFileEditable((IFile)resource)) {
                this.cuDocumentProvider.saveDocument(monitor, (Object)input, doc, false);
            }
            throw ex;
        }
    }

    /*
     * Exception decompiling
     */
    protected void saveDocument(IEditorInput input, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 127->131)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveExistingCompilationUnits(IProgressMonitor monitor) {
        if (this.getEditorInputs().isEmpty()) {
            return;
        }
        if (!this.validateState()) {
            if (monitor == null) return;
            monitor.setCanceled(true);
            return;
        }
        Iterator it = this.getEditorInputs().entrySet().iterator();
        try {
            while (it.hasNext()) {
                Object var5_5;
                Map.Entry entry = it.next();
                IEditorInput input = (IEditorInput)entry.getValue();
                try {
                    this.saveDocument(input, null);
                }
                catch (Throwable throwable) {
                    var5_5 = null;
                    this.disconnect(input);
                    throw throwable;
                }
                {
                    var5_5 = null;
                    this.disconnect(input);
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.getEditorInputs().clear();
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.getEditorInputs().clear();
            return;
        }
    }

    private boolean validateState() {
        List readOnlyFiles = this.getReadOnlyModifiedFiles();
        if (readOnlyFiles != null && !readOnlyFiles.isEmpty()) {
            IFile[] files = new IFile[readOnlyFiles.size()];
            readOnlyFiles.toArray(files);
            IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            Shell ctx = win == null ? null : win.getShell();
            IStatus status = ResourcesPlugin.getWorkspace().validateEdit(files, (Object)ctx);
            return status.isOK();
        }
        return true;
    }

    private List getReadOnlyModifiedFiles() {
        ArrayList<IFile> readOnlyFiles = null;
        IFile readOnlyFile = null;
        Iterator it = this.getEditorInputs().entrySet().iterator();
        ICompilationUnitDocumentProvider docProv = this.cuDocumentProvider;
        while (it.hasNext()) {
            readOnlyFile = null;
            Map.Entry entry = it.next();
            IEditorInput input = (IEditorInput)entry.getValue();
            if (docProv.canSaveDocument((Object)input)) {
                readOnlyFile = this.getReadOnlyFile(input);
            }
            if (readOnlyFile == null) continue;
            if (readOnlyFiles == null) {
                readOnlyFiles = new ArrayList<IFile>();
            }
            readOnlyFiles.add(readOnlyFile);
        }
        return readOnlyFiles;
    }

    private IFile getReadOnlyFile(IEditorInput input) {
        IFileEditorInput finput;
        IFile file;
        if (input instanceof IFileEditorInput && (file = (finput = (IFileEditorInput)input).getFile()).isReadOnly()) {
            return file;
        }
        return null;
    }

    protected void addDeletedCompilationUnit(ICompilationUnit cu) {
        IEditorInput input = this.primGetEditorInput(cu);
        if (input != null) {
            this.disconnect(input);
        }
        this.getEditorInputs().remove(cu);
        super.addDeletedCompilationUnit(cu);
    }

    public boolean hasWorkingCopies() {
        return super.hasWorkingCopies() || this.editorInputs != null && !this.editorInputs.isEmpty();
    }
}

