/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WTPEntityResolver
implements EntityResolver {
    protected static Map supportedDtDs;
    public static WTPEntityResolver INSTANCE;

    static {
        INSTANCE = new WTPEntityResolver();
    }

    public static Map getSupportedDtDs() {
        if (supportedDtDs == null) {
            supportedDtDs = new HashMap();
        }
        return supportedDtDs;
    }

    public static void registerDtD(String systemID, String localID) {
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        String localResourceName = null;
        boolean isJavaSytemId = false;
        if (this.shouldBeRegistered(systemId)) {
            localResourceName = (String)WTPEntityResolver.getSupportedDtDs().get(systemId);
            isJavaSytemId = true;
        } else {
            String shortName = WTPEntityResolver.getShortName(systemId);
            localResourceName = (String)WTPEntityResolver.getSupportedDtDs().get(shortName);
            if (localResourceName != null) {
                systemId = localResourceName;
            }
        }
        if (localResourceName == null) {
            if (isJavaSytemId) {
                String message = "Type is unrecognized or not yet supported: PUBLIC_ID= {0};SYSTEM_ID={1}";
                throw new SAXException(message);
            }
            return null;
        }
        ClassLoader loader = this.getClass().getClassLoader();
        URL url = null;
        url = loader == null ? ClassLoader.getSystemResource(localResourceName) : loader.getResource(localResourceName);
        if (url == null) {
            String message = "Could not parse xml because the resolved resource \"{0}\" could not be found in classpath";
            throw new FileNotFoundException(message);
        }
        InputSource result = new InputSource(url.toString());
        result.setPublicId(publicId);
        result.setEncoding("UTF-8");
        return result;
    }

    protected boolean shouldBeRegistered(String systemId) {
        return false;
    }

    private static String getShortName(String uri) {
        String tempURI = uri.replace('\\', '/');
        while (tempURI.endsWith("/")) {
            tempURI = tempURI.substring(0, tempURI.length() - 1);
        }
        int lastIndex = tempURI.lastIndexOf(47);
        if (lastIndex == -1) {
            return uri;
        }
        return uri.substring(lastIndex + 1, tempURI.length());
    }
}

