/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.properties.section;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.dtd.core.internal.Attribute;
import org.eclipse.wst.dtd.core.internal.AttributeList;
import org.eclipse.wst.dtd.core.internal.CMBasicNode;
import org.eclipse.wst.dtd.core.internal.CMGroupNode;
import org.eclipse.wst.dtd.core.internal.CMRepeatableNode;
import org.eclipse.wst.dtd.core.internal.Comment;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Element;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.core.internal.Notation;
import org.eclipse.wst.dtd.core.internal.ParameterEntityReference;
import org.eclipse.wst.dtd.ui.internal.DTDPropertiesMessages;

public class DTDSectionLabelProvider
extends LabelProvider {
    public Image getImage(Object object) {
        if (object == null || object.equals(StructuredSelection.EMPTY)) {
            return null;
        }
        Image result = null;
        Object selected = object;
        if (object instanceof IStructuredSelection) {
            selected = ((IStructuredSelection)object).getFirstElement();
        }
        if (selected instanceof DTDFile) {
            return null;
        }
        if (selected instanceof DTDNode) {
            if (selected instanceof ParameterEntityReference) {
                return null;
            }
            return ((DTDNode)selected).getImage();
        }
        if (selected instanceof org.w3c.dom.Element) {
            return null;
        }
        return result;
    }

    public String getText(Object object) {
        if (object == null || object.equals(StructuredSelection.EMPTY)) {
            return null;
        }
        Object selected = object;
        if (object instanceof IStructuredSelection) {
            selected = ((IStructuredSelection)object).getFirstElement();
        }
        if (selected instanceof DTDFile) {
            return ((DTDFile)selected).getName();
        }
        if (selected instanceof CMBasicNode) {
            if (((CMBasicNode)selected).isReference()) {
                return DTDPropertiesMessages._UI_PROPERTIES_VIEW_TITLE_ELEMENT_REF;
            }
            return ((CMBasicNode)selected).getName();
        }
        if (selected instanceof CMRepeatableNode) {
            CMRepeatableNode node = (CMRepeatableNode)selected;
            String name = node.getName();
            if (node instanceof CMGroupNode) {
                name = ((CMGroupNode)node).getConnector() == '|' ? DTDPropertiesMessages.DTDSectionLabelProvider_0 : DTDPropertiesMessages.DTDSectionLabelProvider_1;
            }
            char occurrence = node.getOccurrence();
            switch (occurrence) {
                case '1': {
                    name = String.valueOf(name) + " [1..1]";
                    break;
                }
                case '?': {
                    name = String.valueOf(name) + " [0..1]";
                    break;
                }
                case '+': {
                    name = String.valueOf(name) + " [1..*]";
                    break;
                }
                case '*': {
                    name = String.valueOf(name) + " [0..*]";
                }
            }
            return name;
        }
        if (selected instanceof DTDNode) {
            if (selected instanceof Element) {
                return DTDPropertiesMessages.DTDSectionLabelProvider_6;
            }
            if (selected instanceof Attribute) {
                return DTDPropertiesMessages.DTDSectionLabelProvider_7;
            }
            if (selected instanceof AttributeList) {
                return DTDPropertiesMessages.DTDSectionLabelProvider_8;
            }
            if (selected instanceof Comment) {
                return DTDPropertiesMessages.DTDSectionLabelProvider_9;
            }
            if (selected instanceof Entity) {
                return DTDPropertiesMessages.DTDSectionLabelProvider_10;
            }
            if (selected instanceof Notation) {
                return DTDPropertiesMessages.DTDSectionLabelProvider_11;
            }
            if (selected instanceof ParameterEntityReference) {
                return null;
            }
            return ((DTDNode)selected).getName();
        }
        if (selected instanceof org.w3c.dom.Element) {
            return ((org.w3c.dom.Element)selected).getLocalName();
        }
        if (object instanceof ITextSelection) {
            return "";
        }
        return object.toString();
    }
}

