/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.core.fragment;

import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.core.CommandFactory;
import org.eclipse.wst.command.internal.env.core.CommandManager;
import org.eclipse.wst.command.internal.env.core.EnvironmentCoreMessages;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.data.DataFlowManager;
import org.eclipse.wst.command.internal.env.core.data.DataMappingRegistry;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragment;
import org.eclipse.wst.command.internal.env.core.fragment.FragmentListener;
import org.eclipse.wst.command.internal.env.core.fragment.SequenceFragment;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class CommandFragmentEngine
implements CommandManager {
    private Stack commandStack_;
    private FragmentListener undoFragmentListener_;
    private FragmentListener nextFragmentListener_;
    private FragmentListener afterExecuteFragmentListener_;
    private FragmentListener peekFragmentListener_;
    private DataFlowManager dataManager_;
    private IEnvironment environment_;
    private IStatus lastStatus_;

    public CommandFragmentEngine(CommandFragment startFragment, DataFlowManager dataManager, IEnvironment environment) {
        SequenceFragment root = new SequenceFragment();
        root.add(startFragment);
        this.commandStack_ = new Stack();
        this.addToStack(root, -1);
        this.addToStack(startFragment, 0);
        this.dataManager_ = dataManager;
        this.environment_ = environment;
    }

    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append(newline);
        buffer.append("Command stack start:");
        buffer.append(newline);
        int index = 0;
        while (index < this.commandStack_.size()) {
            CommandListEntry entry = (CommandListEntry)this.commandStack_.elementAt(index);
            entry.dump(buffer, index);
            ++index;
        }
        buffer.append("Command start end:");
        buffer.append(newline);
        return buffer.toString();
    }

    public DataMappingRegistry getMappingRegistry() {
        return this.dataManager_.getMappingRegistry();
    }

    public IStatus getLastStatus() {
        return this.lastStatus_;
    }

    public boolean isUndoEnabled() {
        return true;
    }

    public void setNextFragmentListener(FragmentListener listener) {
        this.nextFragmentListener_ = listener;
    }

    public void setAfterExecuteFragmentListener(FragmentListener listener) {
        this.afterExecuteFragmentListener_ = listener;
    }

    public void setPeekFragmentListener(FragmentListener listener) {
        this.peekFragmentListener_ = listener;
    }

    public void setUndoFragmentListener(FragmentListener listener) {
        this.undoFragmentListener_ = listener;
    }

    public void peekForwardToNextStop() {
        CommandListEntry topEntry = (CommandListEntry)this.commandStack_.lastElement();
        int parentIndex = topEntry.parentIndex_;
        CommandFragment childFragment = topEntry.fragment_;
        boolean continueLoop = this.navigateChildFragments(childFragment, false);
        while (parentIndex != -1 && continueLoop) {
            CommandListEntry parentEntry = (CommandListEntry)this.commandStack_.elementAt(parentIndex);
            CommandFragment parentFragment = parentEntry.fragment_;
            CommandFragment nextFragment = parentFragment.getNextSubFragment(childFragment);
            if (nextFragment == null) {
                parentIndex = parentEntry.parentIndex_;
                childFragment = parentFragment;
                continue;
            }
            if (this.navigateChildFragments(nextFragment, true)) {
                childFragment = nextFragment;
                continue;
            }
            continueLoop = false;
        }
    }

    public void moveForwardToNextStop(IProgressMonitor monitor) {
        CommandListEntry topEntry = (CommandListEntry)this.commandStack_.lastElement();
        int parentIndex = topEntry.parentIndex_;
        CommandFragment currentFragment = topEntry.fragment_;
        boolean continueExecute = this.visitTop(monitor);
        CommandFragment childFragment = currentFragment.getFirstSubFragment();
        while (childFragment != null && continueExecute) {
            parentIndex = this.commandStack_.size() - 1;
            this.addToStack(childFragment, parentIndex);
            continueExecute = this.visitTop(monitor);
            currentFragment = childFragment;
            childFragment = currentFragment.getFirstSubFragment();
        }
        while (parentIndex != -1 && continueExecute) {
            CommandListEntry parentEntry = (CommandListEntry)this.commandStack_.elementAt(parentIndex);
            CommandFragment parentFragment = parentEntry.fragment_;
            CommandFragment nextFragment = null;
            nextFragment = currentFragment == null ? parentFragment.getFirstSubFragment() : parentFragment.getNextSubFragment(currentFragment);
            if (nextFragment == null) {
                parentIndex = parentEntry.parentIndex_;
                currentFragment = parentFragment;
                continue;
            }
            this.addToStack(nextFragment, parentIndex);
            parentIndex = this.commandStack_.size() - 1;
            continueExecute = this.visitTop(monitor);
            currentFragment = null;
        }
    }

    public boolean undoToLastStop() {
        CommandListEntry topEntry = (CommandListEntry)this.commandStack_.lastElement();
        if (topEntry.fragmentStopped_ && !topEntry.beforeExecute_) {
            this.performUndo(topEntry);
            return topEntry.parentIndex_ == 0;
        }
        this.performUndo(topEntry);
        while (topEntry.parentIndex_ != 0) {
            this.commandStack_.pop();
            topEntry = (CommandListEntry)this.commandStack_.lastElement();
            this.performUndo(topEntry);
            if (topEntry.fragmentStopped_) break;
        }
        return topEntry.parentIndex_ == 0;
    }

    private void performUndo(CommandListEntry entry) {
        if (entry.parentIndex_ == 0) {
            return;
        }
        AbstractDataModelOperation cmd = entry.command_;
        if (cmd != null && cmd.canUndo() && !entry.beforeExecute_) {
            try {
                cmd.undo(null, null);
                this.dataManager_.unprocess(cmd);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            entry.beforeExecute_ = true;
        }
        this.undoFragmentListener_.notify(entry.fragment_);
    }

    private boolean navigateChildFragments(CommandFragment fragment, boolean visitCurrent) {
        boolean continueNavigate = true;
        CommandFragment childFrag = null;
        if (visitCurrent) {
            continueNavigate = this.peekFragmentListener_.notify(fragment);
            this.dataManager_.process(fragment);
        }
        childFrag = fragment.getFirstSubFragment();
        while (childFrag != null && continueNavigate) {
            continueNavigate = this.navigateChildFragments(childFrag, true);
            childFrag = fragment.getNextSubFragment(childFrag);
        }
        return continueNavigate;
    }

    private boolean visitTop(IProgressMonitor monitor) {
        CommandListEntry entry = (CommandListEntry)this.commandStack_.lastElement();
        boolean continueNavigate = this.nextFragmentListener_.notify(entry.fragment_);
        if (continueNavigate) {
            this.dataManager_.process(entry.fragment_);
            entry.fragment_.registerDataMappings(this.dataManager_.getMappingRegistry());
            this.lastStatus_ = this.runCommand(entry, monitor);
            if (this.afterExecuteFragmentListener_ != null && !(continueNavigate = this.afterExecuteFragmentListener_.notify(entry.fragment_))) {
                this.lastStatus_ = new Status(4, this.lastStatus_.getPlugin(), this.lastStatus_.getCode(), this.lastStatus_.getMessage(), this.lastStatus_.getException());
            }
            if (continueNavigate && this.lastStatus_.getSeverity() == 4) {
                continueNavigate = false;
            }
        }
        if (!continueNavigate) {
            entry.fragmentStopped_ = true;
        }
        return continueNavigate;
    }

    private void addToStack(CommandFragment fragment, int parentIndex) {
        CommandListEntry entry = new CommandListEntry(fragment, parentIndex);
        this.commandStack_.push(entry);
    }

    protected IStatus initBeforeExecute(AbstractDataModelOperation operation) {
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus runCommand(CommandListEntry entry, IProgressMonitor monitor) {
        String message2;
        AbstractDataModelOperation cmd;
        CommandFactory factory = entry.fragment_.getCommandFactory();
        IStatus status = Status.OK_STATUS;
        if (factory == null) return status;
        entry.command_ = cmd = factory.create();
        if (cmd == null) return status;
        try {
            try {
                this.dataManager_.process(cmd);
                status = this.initBeforeExecute(cmd);
                this.environment_.getLog().log(1, "command", 5001, (Object)this, "runCommand", (Object)("Executing: " + cmd.getClass().getName()));
                cmd.setEnvironment(this.environment_);
                status = cmd.execute(monitor, null);
                entry.beforeExecute_ = false;
            }
            catch (Throwable exc) {
                IStatus unexpectedError = StatusUtils.errorStatus(exc);
                MultiStatus parentStatus = new MultiStatus("id", 0, new IStatus[]{unexpectedError}, EnvironmentCoreMessages.MSG_ERROR_UNEXPECTED_ERROR, null);
                this.environment_.getStatusHandler().reportError((IStatus)parentStatus);
                status = unexpectedError;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            String message2 = "Ok";
            if (status.getSeverity() == 4) {
                message2 = "Error: " + status.getMessage();
            }
            this.environment_.getLog().log(1, "command", 5001, (Object)this, "runCommand", (Object)("Execution status: " + message2));
            throw throwable;
        }
        {
            Object var9_11 = null;
            message2 = "Ok";
        }
        if (status.getSeverity() == 4) {
            message2 = "Error: " + status.getMessage();
        }
        this.environment_.getLog().log(1, "command", 5001, (Object)this, "runCommand", (Object)("Execution status: " + message2));
        return status;
    }

    private class CommandListEntry {
        public AbstractDataModelOperation command_;
        public CommandFragment fragment_;
        public int parentIndex_;
        public boolean fragmentStopped_;
        public boolean beforeExecute_;

        public CommandListEntry(CommandFragment fragment, int parentIndex) {
            this.fragment_ = fragment;
            this.parentIndex_ = parentIndex;
            this.fragmentStopped_ = false;
            this.beforeExecute_ = true;
        }

        public void dump(StringBuffer buffer, int index) {
            String newline = System.getProperty("line.separator");
            String line = "  " + index + "- frag: " + this.fragment_.getId() + " parIndex: " + this.parentIndex_ + " stop: " + this.fragmentStopped_ + " beforeExecute: " + this.beforeExecute_;
            buffer.append(line);
            buffer.append(newline);
        }
    }
}

