/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewContextMenuProvider;
import org.eclipse.wst.xsd.ui.internal.adt.design.BaseGraphicalViewerKeyHandler;
import org.eclipse.wst.xsd.ui.internal.adt.editor.CommonSelectionManager;

public class DesignViewGraphicalViewer
extends ScrollingGraphicalViewer
implements ISelectionChangedListener {
    protected ASDSelectionChangedListener internalSelectionProvider = new ASDSelectionChangedListener();

    public DesignViewGraphicalViewer(IEditorPart editor, CommonSelectionManager manager) {
        this.setContextMenu((MenuManager)new DesignViewContextMenuProvider((EditPartViewer)this, (ISelectionProvider)this));
        editor.getEditorSite().registerContextMenu("org.eclipse.wst.wsdl.editor.popup.graph", this.getContextMenu(), (ISelectionProvider)this.internalSelectionProvider, false);
        this.addSelectionChangedListener(this.internalSelectionProvider);
        this.internalSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)manager);
        manager.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setKeyHandler((KeyHandler)new BaseGraphicalViewerKeyHandler((GraphicalViewer)this));
    }

    public void selectionChanged(SelectionChangedEvent event) {
        EditPart editPart;
        Object selectedObject = ((StructuredSelection)event.getSelection()).getFirstElement();
        if (event.getSource() != this.internalSelectionProvider && (editPart = this.getEditPart((EditPart)this.getRootEditPart(), selectedObject)) != null) {
            this.setSelection((ISelection)new StructuredSelection((Object)editPart));
        }
    }

    protected EditPart getEditPart(EditPart editPart, Object model) {
        EditPart result = null;
        if (editPart.getModel() == model) {
            result = editPart;
        } else {
            Iterator i = editPart.getChildren().iterator();
            while (i.hasNext()) {
                result = this.getEditPart((EditPart)i.next(), model);
                if (result != null) break;
            }
        }
        return result;
    }

    class ASDSelectionChangedListener
    implements ISelectionProvider,
    ISelectionChangedListener {
        protected List listenerList = new ArrayList();
        protected ISelection selection = new StructuredSelection();

        ASDSelectionChangedListener() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listenerList.add(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listenerList.remove(listener);
        }

        public ISelection getSelection() {
            return this.selection;
        }

        protected void notifyListeners(SelectionChangedEvent event) {
            Iterator i = this.listenerList.iterator();
            while (i.hasNext()) {
                ISelectionChangedListener listener = (ISelectionChangedListener)i.next();
                listener.selectionChanged(event);
            }
        }

        public StructuredSelection convertSelectionFromEditPartToModel(ISelection editPartSelection) {
            ArrayList<Object> selectedModelObjectList = new ArrayList<Object>();
            if (editPartSelection instanceof IStructuredSelection) {
                Iterator i = ((IStructuredSelection)editPartSelection).iterator();
                while (i.hasNext()) {
                    Object obj = i.next();
                    Object model = null;
                    if (obj instanceof EditPart) {
                        EditPart editPart = (EditPart)obj;
                        model = editPart.getModel();
                    }
                    if (model == null) continue;
                    selectedModelObjectList.add(model);
                }
            }
            return new StructuredSelection(selectedModelObjectList);
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection newSelection = this.convertSelectionFromEditPartToModel(event.getSelection());
            this.selection = newSelection;
            SelectionChangedEvent newEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)newSelection);
            this.notifyListeners(newEvent);
        }
    }
}

