/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.properties.internal.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.common.ui.properties.internal.provisional.ISectionDescriptor;
import org.eclipse.wst.common.ui.properties.internal.provisional.ITypeMapper;

public class TabbedPropertyRegistryClassSectionFilter {
    private ITypeMapper typeMapper = null;

    protected TabbedPropertyRegistryClassSectionFilter(ITypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    protected boolean appliesToSelection(ISectionDescriptor descriptor, ISelection selection) {
        boolean ret = false;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            if (descriptor.getEnablesFor() != -1 && ((IStructuredSelection)selection).size() != descriptor.getEnablesFor()) {
                return false;
            }
            ret = true;
            HashSet<Class> effectiveTypes = new HashSet<Class>();
            Iterator i = ((IStructuredSelection)selection).iterator();
            while (ret && i.hasNext()) {
                Object object = i.next();
                Class<?> effectiveType = object.getClass();
                Class remapType = this.remapType(descriptor.getFilter(), object, effectiveType);
                if (!effectiveTypes.add(remapType) || this.appliesToEffectiveType(descriptor, remapType)) continue;
                ret = false;
            }
        }
        return ret;
    }

    private boolean appliesToEffectiveType(ISectionDescriptor descriptor, Class inputClass) {
        ArrayList classTypes = this.getClassTypes(inputClass);
        List sectionInputTypes = descriptor.getInputTypes();
        Iterator j = sectionInputTypes.iterator();
        while (j.hasNext()) {
            String type = (String)j.next();
            if (!classTypes.contains(type)) continue;
            return true;
        }
        return false;
    }

    protected Class remapType(ITypeMapper sectionFilter, Object object, Class effectiveType) {
        if (sectionFilter != null) {
            return sectionFilter.remapType(object, effectiveType);
        }
        if (this.typeMapper != null) {
            return this.typeMapper.remapType(object, effectiveType);
        }
        return effectiveType;
    }

    protected ArrayList getClassTypes(Class target) {
        ArrayList<String> result = new ArrayList<String>();
        List classes = this.computeClassOrder(target);
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            result.add(((Class)i.next()).getName());
        }
        result.addAll(this.computeInterfaceOrder(classes));
        return result;
    }

    private List computeClassOrder(Class target) {
        ArrayList result = new ArrayList(4);
        Class clazz = target;
        while (clazz != null) {
            result.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private List computeInterfaceOrder(List classes) {
        ArrayList result = new ArrayList(4);
        HashMap seen = new HashMap(4);
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            Class[] interfaces = ((Class)iter.next()).getInterfaces();
            this.internalComputeInterfaceOrder(interfaces, result, seen);
        }
        return result;
    }

    private void internalComputeInterfaceOrder(Class[] interfaces, List result, Map seen) {
        ArrayList<Class> newInterfaces = new ArrayList<Class>(seen.size());
        int i = 0;
        while (i < interfaces.length) {
            Class interfac = interfaces[i];
            if (seen.get(interfac) == null) {
                result.add(interfac.getName());
                seen.put(interfac, interfac);
                newInterfaces.add(interfac);
            }
            ++i;
        }
        Iterator iter = newInterfaces.iterator();
        while (iter.hasNext()) {
            this.internalComputeInterfaceOrder(((Class)iter.next()).getInterfaces(), result, seen);
        }
    }
}

