/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.internal.modelqueryimpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.modelqueryimpl.ModelQueryExtensionRegistry;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.extension.ModelQueryExtension;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.extension.ModelQueryExtensionManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModelQueryExtensionManagerImpl
implements ModelQueryExtensionManager {
    protected ModelQueryExtensionRegistry modelQueryExtensionRegistry = new ModelQueryExtensionRegistry();

    public List getDataTypeValues(Element element, CMNode cmNode) {
        ArrayList<String> list = new ArrayList<String>();
        String contentTypeId = this.getContentTypeId(element);
        String namespace = this.getNamespace(cmNode);
        String name = cmNode.getNodeName();
        Iterator i = this.modelQueryExtensionRegistry.getApplicableExtensions(contentTypeId, namespace).iterator();
        while (i.hasNext()) {
            ModelQueryExtension extension = (ModelQueryExtension)i.next();
            String[] values = null;
            values = cmNode.getNodeType() == 2 ? extension.getAttributeValues(element, namespace, name) : extension.getElementValues(element, namespace, name);
            if (values == null) continue;
            list.addAll(Arrays.asList(values));
        }
        return list;
    }

    public void filterAvailableElementContent(List cmnodes, Element element, CMElementDeclaration ed) {
        String contentTypeId = this.getContentTypeId(element);
        String parentNamespace = element.getNamespaceURI();
        List modelQueryExtensions = this.modelQueryExtensionRegistry.getApplicableExtensions(contentTypeId, parentNamespace);
        Iterator j = cmnodes.iterator();
        while (j.hasNext()) {
            CMNode cmNode = (CMNode)j.next();
            String namespace = this.getNamespace(cmNode);
            String name = cmNode.getNodeName();
            boolean include = true;
            int k = 0;
            while (k < modelQueryExtensions.size() && include) {
                ModelQueryExtension extension = (ModelQueryExtension)modelQueryExtensions.get(k);
                include = extension.isApplicableChildElement(element, namespace, name);
                if (!include) {
                    j.remove();
                }
                ++k;
            }
        }
    }

    private String getNamespace(CMNode cmNode) {
        String namespace = null;
        CMDocument cmDocument = (CMDocument)cmNode.getProperty("CMDocument");
        if (cmDocument != null) {
            namespace = (String)cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI");
        }
        return namespace;
    }

    private String getContentTypeId(Node node) {
        String contentTypeId = "org.eclipse.core.runtime.xml";
        if (node instanceof IDOMNode) {
            IDOMNode domNode = (IDOMNode)node;
            contentTypeId = domNode.getModel().getContentTypeIdentifier();
        }
        return contentTypeId;
    }
}

