/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.ui.internal.wizards;

import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.navigator.ResourceNavigator;
import org.eclipse.wst.wsi.ui.internal.Messages;
import org.eclipse.wst.wsi.ui.internal.wizards.ValidationWizardLogPage;
import org.eclipse.wst.wsi.ui.internal.wizards.ValidationWizardWSDLContentPage;
import org.eclipse.wst.wsi.ui.internal.wizards.ValidationWizardWSDLPage;

public class ValidationWizard
extends Wizard {
    protected ValidationWizardLogPage logPage;
    protected ValidationWizardWSDLPage wsdlPage;
    protected ValidationWizardWSDLContentPage wsdlContentPage;
    protected String filename;
    protected IFile file;
    protected IPath containerFullPath;
    protected boolean isValid;
    protected String elementname;
    protected String namespace;
    protected String parentname;
    protected String type;
    protected String wsdlfile;
    protected boolean includewsdlfile;
    protected String[] wsdllocations = null;
    static /* synthetic */ Class class$0;

    public ValidationWizard(String filename) {
        this.filename = filename;
        this.setWindowTitle(Messages.VALIDATION_WIZARD_TITLE);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.wsi.ui.internal.WSIUIPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile((Class)clazz, (String)"actions/icons/wsi_logfile_wiz.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.logPage = new ValidationWizardLogPage((IStructuredSelection)this.getResourceNavigatorSelection(), this.filename);
        this.wsdlPage = new ValidationWizardWSDLPage((IStructuredSelection)this.getResourceNavigatorSelection());
        this.wsdlContentPage = new ValidationWizardWSDLContentPage((IStructuredSelection)this.getResourceNavigatorSelection());
        this.addPage((IWizardPage)this.logPage);
        this.addPage((IWizardPage)this.wsdlPage);
        this.addPage((IWizardPage)this.wsdlContentPage);
    }

    public boolean includeWSDLFile() {
        if (!this.isValid) {
            return this.wsdlPage.includeWSDLFile();
        }
        return this.includewsdlfile;
    }

    public String getElementName() {
        return this.elementname;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getParentName() {
        return this.parentname;
    }

    public String getType() {
        return this.type;
    }

    public String getWSDLFile() {
        if (!this.isValid) {
            return this.wsdlPage.getWSDLFile();
        }
        return this.wsdlfile;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        if (currentPage == this.wsdlPage) {
            if (!this.wsdlPage.includeWSDLFile()) {
                return null;
            }
            try {
                WSDLFactory factory = WSDLFactory.newInstance();
                WSDLReader reader = factory.newWSDLReader();
                reader.readWSDL(this.getWSDLFile());
            }
            catch (Exception exception) {
                return null;
            }
        }
        return super.getNextPage(currentPage);
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean performFinish() {
        this.file = this.logPage.getFile();
        this.containerFullPath = this.logPage.getContainerFullPath();
        this.includewsdlfile = this.wsdlPage.includeWSDLFile();
        this.wsdlfile = this.wsdlPage.getWSDLFile();
        this.elementname = this.wsdlContentPage.getElementName();
        this.namespace = this.wsdlContentPage.getNamespace();
        this.parentname = this.wsdlContentPage.getParentName();
        this.type = this.wsdlContentPage.getType();
        this.isValid = true;
        return true;
    }

    public IFile getFile() {
        return this.file;
    }

    public IPath getContainerFullPath() {
        return this.containerFullPath;
    }

    public ISelection getResourceNavigatorSelection() {
        IViewReference[] viewParts = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int i = 0;
        while (i < viewParts.length) {
            if (viewParts[i] instanceof ResourceNavigator) {
                return ((ResourceNavigator)viewParts[i]).getViewSite().getSelectionProvider().getSelection();
            }
            ++i;
        }
        return StructuredSelection.EMPTY;
    }

    public void setWSDLLocations(String[] wsdllocations) {
        this.wsdllocations = wsdllocations;
    }

    public String[] getWSDLLocations() {
        return this.wsdllocations;
    }
}

