/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.standalone.InstallCommand;
import org.eclipse.wst.server.core.internal.IInstallableServer;
import org.eclipse.wst.server.core.internal.InstallableRuntime;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.Trace;
import org.osgi.framework.Version;

public class InstallableServer
implements IInstallableServer {
    private IConfigurationElement element;

    public InstallableServer(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        try {
            return this.element.getAttribute("id");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getName() {
        try {
            return this.element.getAttribute("name");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDescription() {
        try {
            return this.element.getAttribute("description");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getVendor() {
        try {
            String vendor = this.element.getAttribute("vendor");
            if (vendor != null) {
                return vendor;
            }
        }
        catch (Exception exception) {}
        return Messages.defaultVendor;
    }

    public String getVersion() {
        try {
            String version = this.element.getAttribute("version");
            if (version != null) {
                return version;
            }
        }
        catch (Exception exception) {}
        return Messages.defaultVersion;
    }

    public String getFeatureVersion() {
        try {
            return this.element.getAttribute("featureVersion");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFeatureId() {
        try {
            return this.element.getAttribute("featureId");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFromSite() {
        try {
            return this.element.getAttribute("featureSite");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getLicense(IProgressMonitor monitor) throws CoreException {
        String featureId = this.getFeatureId();
        String featureVersion = this.getFeatureVersion();
        String fromSite = this.getFromSite();
        if (featureId == null || featureVersion == null || fromSite == null) {
            return null;
        }
        ISite site = InstallableRuntime.getSite(fromSite, monitor);
        ISiteFeatureReference[] featureRefs = site.getFeatureReferences();
        int i = 0;
        while (i < featureRefs.length) {
            if (featureId.equals(featureRefs[i].getVersionedIdentifier().getIdentifier()) && featureVersion.equals(featureRefs[i].getVersionedIdentifier().getVersion().toString())) {
                IFeature feature = featureRefs[i].getFeature(monitor);
                IURLEntry license = feature.getLicense();
                if (license != null) {
                    return license.getAnnotation();
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public void install(IProgressMonitor monitor) throws CoreException {
        String featureId = this.getFeatureId();
        String featureVersion = this.getFeatureVersion();
        String fromSite = this.getFromSite();
        if (featureId == null || featureVersion == null || fromSite == null) {
            return;
        }
        ISite site = InstallableRuntime.getSite(fromSite, monitor);
        fromSite = InstallableRuntime.getMirror(fromSite, site);
        featureVersion = InstallableServer.getLatestVersion(site, featureVersion, featureId);
        try {
            InstallCommand command = new InstallCommand(featureId, featureVersion, fromSite, null, "false");
            boolean b = command.run(monitor);
            if (!b) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorInstallingServerFeature, null));
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error installing feature", e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
    }

    public static String getLatestVersion(ISite site, String version, String featureId) {
        Version latestVersion = new Version(version);
        try {
            ISiteFeatureReference[] features = site.getFeatureReferences();
            int i = 0;
            while (i < features.length) {
                Version nextCand;
                if (features[i].getVersionedIdentifier().getIdentifier().equals(featureId) && (nextCand = new Version(features[i].getVersionedIdentifier().getVersion().toString())).compareTo((Object)latestVersion) > 0) {
                    latestVersion = nextCand;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error searching for latest feature version", e);
        }
        return latestVersion.toString();
    }

    public String toString() {
        return "InstallableServer[" + this.getId() + ", " + this.getName() + "]";
    }
}

