/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntry;
import org.tigris.subversion.subclipse.core.history.Tags;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class GetLogsCommand
implements ISVNCommand {
    private ISVNRemoteResource remoteResource;
    private SVNRevision pegRevision = SVNRevision.HEAD;
    private SVNRevision revisionStart = new SVNRevision.Number(0L);
    private SVNRevision revisionEnd = SVNRevision.HEAD;
    private boolean stopOnCopy = false;
    private long limit = 0L;
    private AliasManager tagManager;
    private ILogEntry[] logEntries;

    public GetLogsCommand(ISVNRemoteResource remoteResource, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, long limit, AliasManager tagManager) {
        this.remoteResource = remoteResource;
        this.pegRevision = pegRevision != null ? pegRevision : SVNRevision.HEAD;
        this.revisionStart = revisionStart;
        this.revisionEnd = revisionEnd != null ? revisionEnd : SVNRevision.HEAD;
        this.stopOnCopy = stopOnCopy;
        this.limit = limit;
        this.tagManager = tagManager;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor aMonitor) throws SVNException {
        this.logEntries = null;
        IProgressMonitor monitor = Policy.monitorFor(aMonitor);
        monitor.beginTask(Policy.bind("RemoteFile.getLogEntries"), 100);
        try {
            try {
                ISVNLogMessage[] logMessages = this.remoteResource.getLogMessages(this.pegRevision, this.revisionStart, this.revisionEnd, this.stopOnCopy, !SVNProviderPlugin.getPlugin().getSVNClientManager().isFetchChangePathOnDemand(), this.limit);
                this.logEntries = this.remoteResource.isFolder() ? LogEntry.createLogEntriesFrom((ISVNRemoteFolder)this.remoteResource, logMessages, this.getTags(logMessages)) : LogEntry.createLogEntriesFrom((ISVNRemoteFile)this.remoteResource, logMessages, this.getTags(logMessages), this.getUrls(logMessages));
            }
            catch (TeamException e) {
                throw SVNException.wrapException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    public ILogEntry[] getLogEntries() {
        return this.logEntries;
    }

    private SVNUrl[] fillUrlsWith(SVNUrl[] urls, SVNUrl url) {
        int i = 0;
        while (i < urls.length) {
            urls[i] = url;
            ++i;
        }
        return urls;
    }

    private SVNUrl[] getUrls(ISVNLogMessage[] logMessages) {
        SVNUrl urlCopyPath;
        SVNUrl urlChangedPath;
        int j;
        ISVNLogMessageChangePath[] changePaths;
        SVNUrl[] urls = new SVNUrl[logMessages.length];
        SVNUrl rootRepositoryUrl = this.remoteResource.getRepository().getRepositoryRoot();
        if (rootRepositoryUrl == null) {
            return this.fillUrlsWith(urls, this.remoteResource.getUrl());
        }
        int indexRemote = -1;
        int i = 0;
        while (i < logMessages.length) {
            if (logMessages[i].getRevision().equals((Object)this.remoteResource.getLastChangedRevision())) {
                indexRemote = i;
                break;
            }
            ++i;
        }
        if (indexRemote > -1) {
            urls[indexRemote] = this.remoteResource.getUrl();
        }
        SVNUrl currentUrl = this.remoteResource.getUrl();
        int i2 = indexRemote + 1;
        while (i2 < logMessages.length) {
            changePaths = logMessages[i2].getChangedPaths();
            j = 0;
            while (j < changePaths.length) {
                urlChangedPath = rootRepositoryUrl.appendPath(changePaths[j].getPath());
                if (currentUrl.equals((Object)urlChangedPath)) {
                    urls[i2] = currentUrl;
                    break;
                }
                if (changePaths[j].getCopySrcPath() != null && currentUrl.equals((Object)(urlCopyPath = rootRepositoryUrl.appendPath(changePaths[j].getCopySrcPath())))) {
                    urls[i2] = currentUrl = rootRepositoryUrl.appendPath(changePaths[j].getPath());
                    break;
                }
                ++j;
            }
            if (urls[i2] == null) {
                return this.fillUrlsWith(urls, this.remoteResource.getUrl());
            }
            ++i2;
        }
        currentUrl = this.remoteResource.getUrl();
        i2 = indexRemote - 1;
        while (i2 >= 0) {
            changePaths = logMessages[i2].getChangedPaths();
            j = 0;
            while (j < changePaths.length) {
                urlChangedPath = rootRepositoryUrl.appendPath(changePaths[j].getPath());
                if (currentUrl.equals((Object)urlChangedPath)) {
                    urls[i2] = currentUrl;
                    if (changePaths[j].getCopySrcPath() == null) break;
                    currentUrl = urlCopyPath = rootRepositoryUrl.appendPath(changePaths[j].getCopySrcPath());
                    break;
                }
                ++j;
            }
            if (urls[i2] == null) {
                return this.fillUrlsWith(urls, this.remoteResource.getUrl());
            }
            --i2;
        }
        return urls;
    }

    private Tags[] getTags(ISVNLogMessage[] logMessages) throws NumberFormatException {
        Tags[] tags = new Tags[logMessages.length];
        int i = 0;
        while (i < logMessages.length) {
            if (this.tagManager != null) {
                String rev = logMessages[i].getRevision().toString();
                int revNo = Integer.parseInt(rev);
                tags[i] = new Tags(this.tagManager.getTags(revNo));
            }
            ++i;
        }
        return tags;
    }
}

