/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.ui.PerlDebugImages;

public class LaunchConfigurationCGIWebServerTab
extends AbstractLaunchConfigurationTab
implements IPropertyChangeListener {
    private Text fCGISuffix;
    private DirectoryFieldEditor fCGIRootDir;
    private DirectoryFieldEditor fHTMLRootDir;
    private FileFieldEditor fHTMLRootFile;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        Composite fields = new Composite(comp, 0);
        GridLayout fieldsLayout = new GridLayout();
        fieldsLayout.numColumns = 3;
        fields.setFont(font);
        fields.setLayout((Layout)fieldsLayout);
        fields.setLayoutData((Object)new GridData(768));
        this.createHTMLRootDirectoryGroup(fields);
        this.createStartupFileGroup(fields);
        this.createCGIRootDirectoryGroup(fields);
        this.createVerticalSpacer(comp, 1);
        this.createCGISuffixGroup(comp);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateParamsFromConfig(config);
    }

    private void updateParamsFromConfig(ILaunchConfiguration config) {
        try {
            this.fHTMLRootDir.setStringValue(config.getAttribute("ATTR_HTML_ROOT_DIR", null));
            this.fHTMLRootFile.setStringValue(config.getAttribute("ATTR_HTML_ROOT_FILE", null));
            this.fCGIRootDir.setStringValue(config.getAttribute("ATTR_CGI_ROOT_DIR", null));
            this.fCGISuffix.setText(config.getAttribute("ATTR_CGI_FILE_EXTENSION", ".cgi,.pl"));
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("ATTR_HTML_ROOT_DIR", this.fHTMLRootDir.getStringValue());
        config.setAttribute("ATTR_HTML_ROOT_FILE", this.fHTMLRootFile.getStringValue());
        config.setAttribute("ATTR_CGI_ROOT_DIR", this.fCGIRootDir.getStringValue());
        config.setAttribute("ATTR_CGI_FILE_EXTENSION", this.fCGISuffix.getText());
        config.setAttribute("ATTR_DEBUG_CGI", "OK");
    }

    public void dispose() {
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String value = this.fHTMLRootDir.getStringValue();
        if (value == null) {
            this.setErrorMessage("HTML Root Directory is missing");
            return false;
        }
        File file = new File(value);
        if (!file.exists() || !file.isDirectory()) {
            this.setErrorMessage("HTML Root Directory is invalid");
            return false;
        }
        value = this.fHTMLRootFile.getStringValue();
        if (value == null) {
            this.setErrorMessage("HTML Startup File is missing");
            return false;
        }
        file = new File(value);
        if (!file.exists() || !file.isFile()) {
            this.setErrorMessage("HTML Startup File is invalid");
            return false;
        }
        if (value.indexOf(this.fHTMLRootDir.getStringValue()) != 0) {
            this.setErrorMessage("HTML Startup File must be located within HTML Root Directory (or one of its subfolders)");
            return false;
        }
        value = this.fCGIRootDir.getStringValue();
        if (value == null) {
            this.setErrorMessage("CGI Root Directory is missing");
            return false;
        }
        file = new File(value);
        if (!file.exists() || !file.isDirectory()) {
            this.setErrorMessage("CGI Root Directory is invalid");
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        String root = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        config.setAttribute("ATTR_HTML_ROOT_DIR", root);
        config.setAttribute("ATTR_HTML_ROOT_FILE", root);
        config.setAttribute("ATTR_CGI_ROOT_DIR", root);
        config.setAttribute("ATTR_DEBUG_PORT", PerlDebugPlugin.getDefaultDebugPort());
        config.setAttribute("ATTR_DEBUG_CGI", "OK");
        config.setAttribute("ATTR_CGI_ENV", null);
        config.setAttribute("ATTR_CGI_FILE_EXTENSION", ".cgi,.pl");
    }

    public String getName() {
        return "Web Server";
    }

    public Image getImage() {
        return PerlDebugPlugin.getDefaultDesciptorImageRegistry().get(PerlDebugImages.DESC_OBJS_LaunchTabCGI);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.fHTMLRootDir && this.fHTMLRootFile.getStringValue().indexOf(this.fHTMLRootDir.getStringValue()) != 0) {
            this.fHTMLRootFile.setStringValue(this.fHTMLRootDir.getStringValue());
        }
        this.updateLaunchConfigurationDialog();
    }

    public void update() {
        this.updateLaunchConfigurationDialog();
    }

    private void createCGIRootDirectoryGroup(Composite parent) {
        this.fCGIRootDir = new DirectoryFieldEditor("", "CGI &Root Directory:", parent);
        this.fCGIRootDir.fillIntoGrid(parent, 3);
        this.fCGIRootDir.setPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void createCGISuffixGroup(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        comp.setFont(parent.getFont());
        Label label = new Label(comp, 0);
        label.setText("File Extension for CGI Files (comma-separated list, e.g. \".cgi,.pl\"):");
        label.setFont(parent.getFont());
        gd = new GridData(768);
        label.setLayoutData((Object)gd);
        this.fCGISuffix = new Text(comp, 2052);
        gd = new GridData(768);
        this.fCGISuffix.setLayoutData((Object)gd);
        this.fCGISuffix.setFont(parent.getFont());
        this.fCGISuffix.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                LaunchConfigurationCGIWebServerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createHTMLRootDirectoryGroup(Composite parent) {
        this.fHTMLRootDir = new DirectoryFieldEditor("", "&HTML Root Directory:", parent);
        this.fHTMLRootDir.fillIntoGrid(parent, 3);
        this.fHTMLRootDir.setPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void createStartupFileGroup(Composite parent) {
        this.fHTMLRootFile = new FileFieldEditor("", "HTML &Startup File:", parent);
        this.fHTMLRootFile.fillIntoGrid(parent, 3);
        this.fHTMLRootFile.setPropertyChangeListener((IPropertyChangeListener)this);
    }
}

