/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.calculator;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.steps.calculator.Messages;
import org.w3c.dom.Node;

public class CalculatorMetaFunction
implements Cloneable {
    public static final String XML_TAG = "calculation";
    public static final int CALC_NONE = 0;
    public static final int CALC_CONSTANT = 1;
    public static final int CALC_COPY_OF_FIELD = 2;
    public static final int CALC_ADD = 3;
    public static final int CALC_SUBTRACT = 4;
    public static final int CALC_MULTIPLY = 5;
    public static final int CALC_DIVIDE = 6;
    public static final int CALC_SQUARE = 7;
    public static final int CALC_SQUARE_ROOT = 8;
    public static final int CALC_PERCENT_1 = 9;
    public static final int CALC_PERCENT_2 = 10;
    public static final int CALC_PERCENT_3 = 11;
    public static final int CALC_COMBINATION_1 = 12;
    public static final int CALC_COMBINATION_2 = 13;
    public static final int CALC_ROUND_1 = 14;
    public static final int CALC_ROUND_2 = 15;
    public static final int CALC_NVL = 16;
    public static final int CALC_ADD_DAYS = 17;
    public static final int CALC_YEAR_OF_DATE = 18;
    public static final int CALC_MONTH_OF_DATE = 19;
    public static final int CALC_DAY_OF_YEAR = 20;
    public static final int CALC_DAY_OF_MONTH = 21;
    public static final int CALC_DAY_OF_WEEK = 22;
    public static final int CALC_WEEK_OF_YEAR = 23;
    public static final int CALC_WEEK_OF_YEAR_ISO8601 = 24;
    public static final int CALC_YEAR_OF_DATE_ISO8601 = 25;
    public static final int CALC_BYTE_TO_HEX_ENCODE = 26;
    public static final int CALC_HEX_TO_BYTE_DECODE = 27;
    public static final int CALC_CHAR_TO_HEX_ENCODE = 28;
    public static final int CALC_HEX_TO_CHAR_DECODE = 29;
    public static final int CALC_CRC32 = 30;
    public static final int CALC_ADLER32 = 31;
    public static final int CALC_MD5 = 32;
    public static final int CALC_SHA1 = 33;
    public static final int CALC_LEVENSHTEIN_DISTANCE = 34;
    public static final int CALC_METAPHONE = 35;
    public static final int CALC_DOUBLE_METAPHONE = 36;
    public static final int CALC_ABS = 37;
    public static final int CALC_REMOVE_TIME_FROM_DATE = 38;
    public static final int CALC_DATE_DIFF = 39;
    public static final int CALC_ADD3 = 40;
    public static final int CALC_INITCAP = 41;
    public static final int CALC_UPPER_CASE = 42;
    public static final int CALC_LOWER_CASE = 43;
    public static final int CALC_MASK_XML = 44;
    public static final int CALC_USE_CDATA = 45;
    public static final int CALC_REMOVE_CR = 46;
    public static final int CALC_REMOVE_LF = 47;
    public static final int CALC_REMOVE_CRLF = 48;
    public static final int CALC_REMOVE_TAB = 49;
    public static final int CALC_GET_ONLY_DIGITS = 50;
    public static final int CALC_REMOVE_DIGITS = 51;
    public static final int CALC_STRING_LEN = 52;
    public static final int CALC_LOAD_FILE_CONTENT_BINARY = 53;
    public static final int CALC_ADD_TIME_TO_DATE = 54;
    public static final String[] calc_desc = new String[]{"-", "CONSTANT", "COPY_FIELD", "ADD", "SUBTRACT", "MULTIPLY", "DIVIDE", "SQUARE", "SQUARE_ROOT", "PERCENT_1", "PERCENT_2", "PERCENT_3", "COMBINATION_1", "COMBINATION_2", "ROUND_1", "ROUND_2", "NVL", "ADD_DAYS", "YEAR_OF_DATE", "MONTH_OF_DATE", "DAY_OF_YEAR", "DAY_OF_MONTH", "DAY_OF_WEEK", "WEEK_OF_YEAR", "WEEK_OF_YEAR_ISO8601", "YEAR_OF_DATE_ISO8601", "BYTE_TO_HEX_ENCODE", "HEX_TO_BYTE_DECODE", "CHAR_TO_HEX_ENCODE", "HEX_TO_CHAR_DECODE", "CRC32", "ADLER32", "MD5", "SHA1", "LEVENSHTEIN_DISTANCE", "METAPHONE", "DOUBLE_METAPHONE", "ABS", "REMOVE_TIME_FROM_DATE", "DATE_DIFF", "ADD3", "INIT_CAP", "UPPER_CASE", "LOWER_CASE", "MASK_XML", "USE_CDATA", "REMOVE_CR", "REMOVE_LF", "REMOVE_CRLF", "REMOVE_TAB", "GET_ONLY_DIGITS", "REMOVE_DIGITS", "STRING_LEN", "LOAD_FILE_CONTENT_BINARY", "ADD_TIME_TO_DATE"};
    public static final String[] calcLongDesc = new String[]{"-", Messages.getString("CalculatorMetaFunction.CalcFunctions.SetFieldToConstant"), Messages.getString("CalculatorMetaFunction.CalcFunctions.CreateCopyOfField"), "A + B", "A - B", "A * B", "A / B", "A * A", Messages.getString("CalculatorMetaFunction.CalcFunctions.SQRT"), "100 * A / B", "A - ( A * B / 100 )", "A + ( A * B / 100 )", "A + B * C", Messages.getString("CalculatorMetaFunction.CalcFunctions.Hypotenuse"), Messages.getString("CalculatorMetaFunction.CalcFunctions.Round"), Messages.getString("CalculatorMetaFunction.CalcFunctions.Round2"), Messages.getString("CalculatorMetaFunction.CalcFunctions.NVL"), Messages.getString("CalculatorMetaFunction.CalcFunctions.DatePlusDays"), Messages.getString("CalculatorMetaFunction.CalcFunctions.YearOfDate"), Messages.getString("CalculatorMetaFunction.CalcFunctions.MonthOfDate"), Messages.getString("CalculatorMetaFunction.CalcFunctions.DayOfYear"), Messages.getString("CalculatorMetaFunction.CalcFunctions.DayOfMonth"), Messages.getString("CalculatorMetaFunction.CalcFunctions.DayOfWeek"), Messages.getString("CalculatorMetaFunction.CalcFunctions.WeekOfYear"), Messages.getString("CalculatorMetaFunction.CalcFunctions.WeekOfYearISO8601"), Messages.getString("CalculatorMetaFunction.CalcFunctions.YearOfDateISO8601"), Messages.getString("CalculatorMetaFunction.CalcFunctions.ByteToHexEncode"), Messages.getString("CalculatorMetaFunction.CalcFunctions.HexToByteDecode"), Messages.getString("CalculatorMetaFunction.CalcFunctions.CharToHexEncode"), Messages.getString("CalculatorMetaFunction.CalcFunctions.HexToCharDecode"), Messages.getString("CalculatorMetaFunction.CalcFunctions.CRC32"), Messages.getString("CalculatorMetaFunction.CalcFunctions.Adler32"), Messages.getString("CalculatorMetaFunction.CalcFunctions.MD5"), Messages.getString("CalculatorMetaFunction.CalcFunctions.SHA1"), Messages.getString("CalculatorMetaFunction.CalcFunctions.LevenshteinDistance"), Messages.getString("CalculatorMetaFunction.CalcFunctions.Metaphone"), Messages.getString("CalculatorMetaFunction.CalcFunctions.DoubleMetaphone"), Messages.getString("CalculatorMetaFunction.CalcFunctions.Abs"), Messages.getString("CalculatorMetaFunction.CalcFunctions.RemoveTimeFromDate"), Messages.getString("CalculatorMetaFunction.CalcFunctions.DateDiff"), "A + B + C", Messages.getString("CalculatorMetaFunction.CalcFunctions.InitCap"), Messages.getString("CalculatorMetaFunction.CalcFunctions.UpperCase"), Messages.getString("CalculatorMetaFunction.CalcFunctions.LowerCase"), Messages.getString("CalculatorMetaFunction.CalcFunctions.MaskXML"), Messages.getString("CalculatorMetaFunction.CalcFunctions.UseCDATA"), Messages.getString("CalculatorMetaFunction.CalcFunctions.RemoveCR"), Messages.getString("CalculatorMetaFunction.CalcFunctions.RemoveLF"), Messages.getString("CalculatorMetaFunction.CalcFunctions.RemoveCRLF"), Messages.getString("CalculatorMetaFunction.CalcFunctions.RemoveTAB"), Messages.getString("CalculatorMetaFunction.CalcFunctions.GetOnlyDigits"), Messages.getString("CalculatorMetaFunction.CalcFunctions.RemoveDigits"), Messages.getString("CalculatorMetaFunction.CalcFunctions.StringLen"), Messages.getString("CalculatorMetaFunction.CalcFunctions.LoadFileContentInBinary"), Messages.getString("CalculatorMetaFunction.CalcFunctions.AddTimeToDate")};
    private String fieldName;
    private int calcType;
    private String fieldA;
    private String fieldB;
    private String fieldC;
    private int valueType;
    private int valueLength;
    private int valuePrecision;
    private String conversionMask;
    private String decimalSymbol;
    private String groupingSymbol;
    private String currencySymbol;
    private boolean removedFromResult;

    public CalculatorMetaFunction(String fieldName, int calcType, String fieldA, String fieldB, String fieldC, int valueType, int valueLength, int valuePrecision, boolean removedFromResult, String conversionMask, String decimalSymbol, String groupingSymbol, String currencySymbol) {
        this.fieldName = fieldName;
        this.calcType = calcType;
        this.fieldA = fieldA;
        this.fieldB = fieldB;
        this.fieldC = fieldC;
        this.valueType = valueType;
        this.valueLength = valueLength;
        this.valuePrecision = valuePrecision;
        this.removedFromResult = removedFromResult;
        this.conversionMask = conversionMask;
        this.decimalSymbol = decimalSymbol;
        this.groupingSymbol = groupingSymbol;
        this.currencySymbol = currencySymbol;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            CalculatorMetaFunction mf = (CalculatorMetaFunction)obj;
            return this.getXML() == mf.getXML();
        }
        return false;
    }

    public Object clone() {
        try {
            CalculatorMetaFunction retval = (CalculatorMetaFunction)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getXML() {
        String xml = "";
        xml = xml + "<calculation>";
        xml = xml + XMLHandler.addTagValue((String)"field_name", (String)this.fieldName);
        xml = xml + XMLHandler.addTagValue((String)"calc_type", (String)this.getCalcTypeDesc());
        xml = xml + XMLHandler.addTagValue((String)"field_a", (String)this.fieldA);
        xml = xml + XMLHandler.addTagValue((String)"field_b", (String)this.fieldB);
        xml = xml + XMLHandler.addTagValue((String)"field_c", (String)this.fieldC);
        xml = xml + XMLHandler.addTagValue((String)"value_type", (String)ValueMeta.getTypeDesc((int)this.valueType));
        xml = xml + XMLHandler.addTagValue((String)"value_length", (int)this.valueLength);
        xml = xml + XMLHandler.addTagValue((String)"value_precision", (int)this.valuePrecision);
        xml = xml + XMLHandler.addTagValue((String)"remove", (boolean)this.removedFromResult);
        xml = xml + XMLHandler.addTagValue((String)"conversion_mask", (String)this.conversionMask);
        xml = xml + XMLHandler.addTagValue((String)"decimal_symbol", (String)this.decimalSymbol);
        xml = xml + XMLHandler.addTagValue((String)"grouping_symbol", (String)this.groupingSymbol);
        xml = xml + XMLHandler.addTagValue((String)"currency_symbol", (String)this.currencySymbol);
        xml = xml + "</calculation>";
        return xml;
    }

    public CalculatorMetaFunction(Node calcnode) {
        this.fieldName = XMLHandler.getTagValue((Node)calcnode, (String)"field_name");
        this.calcType = CalculatorMetaFunction.getCalcFunctionType(XMLHandler.getTagValue((Node)calcnode, (String)"calc_type"));
        this.fieldA = XMLHandler.getTagValue((Node)calcnode, (String)"field_a");
        this.fieldB = XMLHandler.getTagValue((Node)calcnode, (String)"field_b");
        this.fieldC = XMLHandler.getTagValue((Node)calcnode, (String)"field_c");
        this.valueType = ValueMeta.getType((String)XMLHandler.getTagValue((Node)calcnode, (String)"value_type"));
        this.valueLength = Const.toInt((String)XMLHandler.getTagValue((Node)calcnode, (String)"value_length"), (int)-1);
        this.valuePrecision = Const.toInt((String)XMLHandler.getTagValue((Node)calcnode, (String)"value_precision"), (int)-1);
        this.removedFromResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)calcnode, (String)"remove"));
        this.conversionMask = XMLHandler.getTagValue((Node)calcnode, (String)"conversion_mask");
        this.decimalSymbol = XMLHandler.getTagValue((Node)calcnode, (String)"decimal_symbol");
        this.groupingSymbol = XMLHandler.getTagValue((Node)calcnode, (String)"grouping_symbol");
        this.currencySymbol = XMLHandler.getTagValue((Node)calcnode, (String)"currency_symbol");
        if (XMLHandler.getSubNode((Node)calcnode, (String)"conversion_mask") == null) {
            this.fixBackwardCompatibility();
        }
    }

    private void fixBackwardCompatibility() {
        if (this.valueType == 5) {
            if (Const.isEmpty((String)this.conversionMask)) {
                this.conversionMask = "0";
            }
            if (Const.isEmpty((String)this.decimalSymbol)) {
                this.decimalSymbol = ".";
            }
            if (Const.isEmpty((String)this.groupingSymbol)) {
                this.groupingSymbol = ",";
            }
        }
        if (this.valueType == 1) {
            if (Const.isEmpty((String)this.conversionMask)) {
                this.conversionMask = "0.0";
            }
            if (Const.isEmpty((String)this.decimalSymbol)) {
                this.decimalSymbol = ".";
            }
            if (Const.isEmpty((String)this.groupingSymbol)) {
                this.groupingSymbol = ",";
            }
        }
    }

    public void saveRep(Repository rep, long id_transformation, long id_step, int nr) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "field_name", this.fieldName);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "calc_type", this.getCalcTypeDesc());
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "field_a", this.fieldA);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "field_b", this.fieldB);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "field_c", this.fieldC);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "value_type", ValueMeta.getTypeDesc((int)this.valueType));
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "value_length", this.valueLength);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "value_precision", this.valuePrecision);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "remove", this.removedFromResult);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "conversion_mask", this.conversionMask);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "decimal_symbol", this.decimalSymbol);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "grouping_symbol", this.groupingSymbol);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "currency_symbol", this.currencySymbol);
    }

    public CalculatorMetaFunction(Repository rep, long id_step, int nr) throws KettleException {
        this.fieldName = rep.getStepAttributeString(id_step, nr, "field_name");
        this.calcType = CalculatorMetaFunction.getCalcFunctionType(rep.getStepAttributeString(id_step, nr, "calc_type"));
        this.fieldA = rep.getStepAttributeString(id_step, nr, "field_a");
        this.fieldB = rep.getStepAttributeString(id_step, nr, "field_b");
        this.fieldC = rep.getStepAttributeString(id_step, nr, "field_c");
        this.valueType = ValueMeta.getType((String)rep.getStepAttributeString(id_step, nr, "value_type"));
        this.valueLength = (int)rep.getStepAttributeInteger(id_step, nr, "value_length");
        this.valuePrecision = (int)rep.getStepAttributeInteger(id_step, nr, "value_precision");
        this.removedFromResult = rep.getStepAttributeBoolean(id_step, nr, "remove");
        this.conversionMask = rep.getStepAttributeString(id_step, nr, "conversion_mask");
        this.decimalSymbol = rep.getStepAttributeString(id_step, nr, "decimal_symbol");
        this.groupingSymbol = rep.getStepAttributeString(id_step, nr, "grouping_symbol");
        this.currencySymbol = rep.getStepAttributeString(id_step, nr, "currency_symbol");
        if (rep.findStepAttributeID(id_step, nr, "conversion_mask") < 0L) {
            this.fixBackwardCompatibility();
        }
    }

    public static final int getCalcFunctionType(String desc) {
        int i;
        for (i = 1; i < calc_desc.length; ++i) {
            if (!calc_desc[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        for (i = 1; i < calcLongDesc.length; ++i) {
            if (!calcLongDesc[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public static final String getCalcFunctionDesc(int type) {
        if (type < 0 || type >= calc_desc.length) {
            return null;
        }
        return calc_desc[type];
    }

    public static final String getCalcFunctionLongDesc(int type) {
        if (type < 0 || type >= calcLongDesc.length) {
            return null;
        }
        return calcLongDesc[type];
    }

    public int getCalcType() {
        return this.calcType;
    }

    public void setCalcType(int calcType) {
        this.calcType = calcType;
    }

    public String getCalcTypeDesc() {
        return CalculatorMetaFunction.getCalcFunctionDesc(this.calcType);
    }

    public String getCalcTypeLongDesc() {
        return CalculatorMetaFunction.getCalcFunctionLongDesc(this.calcType);
    }

    public String getFieldA() {
        return this.fieldA;
    }

    public void setFieldA(String fieldA) {
        this.fieldA = fieldA;
    }

    public String getFieldB() {
        return this.fieldB;
    }

    public void setFieldB(String fieldB) {
        this.fieldB = fieldB;
    }

    public String getFieldC() {
        return this.fieldC;
    }

    public void setFieldC(String fieldC) {
        this.fieldC = fieldC;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public void setValueLength(int valueLength) {
        this.valueLength = valueLength;
    }

    public int getValuePrecision() {
        return this.valuePrecision;
    }

    public void setValuePrecision(int valuePrecision) {
        this.valuePrecision = valuePrecision;
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    public boolean isRemovedFromResult() {
        return this.removedFromResult;
    }

    public void setRemovedFromResult(boolean removedFromResult) {
        this.removedFromResult = removedFromResult;
    }

    public String getConversionMask() {
        return this.conversionMask;
    }

    public void setConversionMask(String conversionMask) {
        this.conversionMask = conversionMask;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    public String getGroupingSymbol() {
        return this.groupingSymbol;
    }

    public void setGroupingSymbol(String groupingSymbol) {
        this.groupingSymbol = groupingSymbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }
}

