require '_h2ph_pre.ph';

no warnings qw(redefine misc);

require 'sys/buf.ph';
require 'sys/types.ph';
require 'sys/queue.ph';
require 'sys/lock.ph';
require 'sys/namei.ph';
require 'sys/selinfo.ph';
require 'sys/tree.ph';
require 'uvm/uvm.ph';
require 'uvm/uvm_vnode.ph';
eval("sub VNON () { 0; }") unless defined(&VNON);
eval("sub VREG () { 1; }") unless defined(&VREG);
eval("sub VDIR () { 2; }") unless defined(&VDIR);
eval("sub VBLK () { 3; }") unless defined(&VBLK);
eval("sub VCHR () { 4; }") unless defined(&VCHR);
eval("sub VLNK () { 5; }") unless defined(&VLNK);
eval("sub VSOCK () { 6; }") unless defined(&VSOCK);
eval("sub VFIFO () { 7; }") unless defined(&VFIFO);
eval("sub VBAD () { 8; }") unless defined(&VBAD);
unless(defined(&VTYPE_NAMES)) {
    sub VTYPE_NAMES () {	"VNON", "VREG", "VDIR", "VBLK", "VCHR", "VLNK", "VSOCK", "VFIFO", "VBAD";}
}
eval("sub VT_NON () { 0; }") unless defined(&VT_NON);
eval("sub VT_UFS () { 1; }") unless defined(&VT_UFS);
eval("sub VT_NFS () { 2; }") unless defined(&VT_NFS);
eval("sub VT_MFS () { 3; }") unless defined(&VT_MFS);
eval("sub VT_MSDOSFS () { 4; }") unless defined(&VT_MSDOSFS);
eval("sub VT_PORTAL () { 5; }") unless defined(&VT_PORTAL);
eval("sub VT_PROCFS () { 6; }") unless defined(&VT_PROCFS);
eval("sub VT_AFS () { 7; }") unless defined(&VT_AFS);
eval("sub VT_ISOFS () { 8; }") unless defined(&VT_ISOFS);
eval("sub VT_ADOSFS () { 9; }") unless defined(&VT_ADOSFS);
eval("sub VT_EXT2FS () { 10; }") unless defined(&VT_EXT2FS);
eval("sub VT_VFS () { 11; }") unless defined(&VT_VFS);
eval("sub VT_NNPFS () { 12; }") unless defined(&VT_NNPFS);
eval("sub VT_NTFS () { 13; }") unless defined(&VT_NTFS);
eval("sub VT_UDF () { 14; }") unless defined(&VT_UDF);
eval("sub VT_XFS () { VT_NNPFS; }") unless defined(&VT_XFS);
unless(defined(&VTAG_NAMES)) {
    sub VTAG_NAMES () {	"NON", "UFS", "NFS", "MFS", "MSDOSFS", "PORTAL", "PROCFS", "AFS", "ISOFS", "ADOSFS", "EXT2FS", "VFS", "NNPFS", "NTFS", "UDF";}
}
unless(defined(&v_mountedhere)) {
    sub v_mountedhere () {	 ($v_un->{vu_mountedhere});}
}
unless(defined(&v_socket)) {
    sub v_socket () {	 ($v_un->{vu_socket});}
}
unless(defined(&v_specinfo)) {
    sub v_specinfo () {	 ($v_un->{vu_specinfo});}
}
unless(defined(&v_fifoinfo)) {
    sub v_fifoinfo () {	 ($v_un->{vu_fifoinfo});}
}
unless(defined(&VROOT)) {
    sub VROOT () {	0x1;}
}
unless(defined(&VTEXT)) {
    sub VTEXT () {	0x2;}
}
unless(defined(&VSYSTEM)) {
    sub VSYSTEM () {	0x4;}
}
unless(defined(&VISTTY)) {
    sub VISTTY () {	0x8;}
}
unless(defined(&VXLOCK)) {
    sub VXLOCK () {	0x100;}
}
unless(defined(&VXWANT)) {
    sub VXWANT () {	0x200;}
}
unless(defined(&VCLONED)) {
    sub VCLONED () {	0x400;}
}
unless(defined(&VALIASED)) {
    sub VALIASED () {	0x800;}
}
unless(defined(&VLARVAL)) {
    sub VLARVAL () {	0x1000;}
}
unless(defined(&VLOCKSWORK)) {
    sub VLOCKSWORK () {	0x4000;}
}
unless(defined(&VCLONE)) {
    sub VCLONE () {	0x8000;}
}
unless(defined(&VBITS)) {
    sub VBITS () {	"\010\001ROOT\002TEXT\003SYSTEM\004ISTTY\010XLOCK" "\011XWANT\013ALIASED\014LARVAL\016LOCKSWORK\017CLONE";}
}
unless(defined(&VBIOWAIT)) {
    sub VBIOWAIT () {	0x1;}
}
unless(defined(&VBIOONSYNCLIST)) {
    sub VBIOONSYNCLIST () {	0x2;}
}
unless(defined(&VBIOONFREELIST)) {
    sub VBIOONFREELIST () {	0x4;}
}
unless(defined(&VA_UTIMES_NULL)) {
    sub VA_UTIMES_NULL () {	0x1;}
}
unless(defined(&VA_EXCLUSIVE)) {
    sub VA_EXCLUSIVE () {	0x2;}
}
unless(defined(&IO_UNIT)) {
    sub IO_UNIT () {	0x1;}
}
unless(defined(&IO_APPEND)) {
    sub IO_APPEND () {	0x2;}
}
unless(defined(&IO_SYNC)) {
    sub IO_SYNC () {	0x4;}
}
unless(defined(&IO_NODELOCKED)) {
    sub IO_NODELOCKED () {	0x8;}
}
unless(defined(&IO_NDELAY)) {
    sub IO_NDELAY () {	0x10;}
}
unless(defined(&IO_NOLIMIT)) {
    sub IO_NOLIMIT () {	0x20;}
}
unless(defined(&VSUID)) {
    sub VSUID () {	04000;}
}
unless(defined(&VSGID)) {
    sub VSGID () {	02000;}
}
unless(defined(&VSVTX)) {
    sub VSVTX () {	01000;}
}
unless(defined(&VREAD)) {
    sub VREAD () {	00400;}
}
unless(defined(&VWRITE)) {
    sub VWRITE () {	00200;}
}
unless(defined(&VEXEC)) {
    sub VEXEC () {	00100;}
}
unless(defined(&VNOVAL)) {
    sub VNOVAL () {	(-1);}
}
if(defined(&_KERNEL)) {
    eval 'sub IFTOVT {
        my($mode) = @_;
	    eval q(( $iftovt_tab[(($mode) &  &S_IFMT) >> 12]));
    }' unless defined(&IFTOVT);
    eval 'sub VTTOIF {
        my($indx) = @_;
	    eval q(( $vttoif_tab[($indx)]));
    }' unless defined(&VTTOIF);
    eval 'sub MAKEIMODE {
        my($indx, $mode) = @_;
	    eval q(( &VTTOIF($indx) | ($mode)));
    }' unless defined(&MAKEIMODE);
    eval 'sub SKIPSYSTEM () {0x1;}' unless defined(&SKIPSYSTEM);
    eval 'sub FORCECLOSE () {0x2;}' unless defined(&FORCECLOSE);
    eval 'sub WRITECLOSE () {0x4;}' unless defined(&WRITECLOSE);
    eval 'sub DOCLOSE () {0x8;}' unless defined(&DOCLOSE);
    eval 'sub V_SAVE () {0x1;}' unless defined(&V_SAVE);
    eval 'sub V_SAVEMETA () {0x2;}' unless defined(&V_SAVEMETA);
    eval 'sub REVOKEALL () {0x1;}' unless defined(&REVOKEALL);
    eval 'sub VATTR_NULL {
        my($vap) = @_;
	    eval q( &vattr_null($vap));
    }' unless defined(&VATTR_NULL);
    eval 'sub NULLVP () {( &NULL);}' unless defined(&NULLVP);
    eval 'sub VN_KNOTE {
        my($vp, $b) = @_;
	    eval q( &KNOTE( ($vp->{v_selectinfo}->{si_note}), ($b)));
    }' unless defined(&VN_KNOTE);
}
if(defined(&_KERNEL)) {
    eval 'sub GETCWD_CHECK_ACCESS () {0x1;}' unless defined(&GETCWD_CHECK_ACCESS);
}
1;
