require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&TX_CTL)) {
    sub TX_CTL () {	0x;}
}
unless(defined(&TX_DESC)) {
    sub TX_DESC () {	0x4;}
}
unless(defined(&Reserved0)) {
    sub Reserved0 () {	0x8;}
}
unless(defined(&TX_NEXT)) {
    sub TX_NEXT () {	0xc;}
}
unless(defined(&RX_CTL)) {
    sub RX_CTL () {	0x10;}
}
unless(defined(&RX_DESC)) {
    sub RX_DESC () {	0x14;}
}
unless(defined(&Reserved1)) {
    sub Reserved1 () {	0x18;}
}
unless(defined(&RX_NEXT)) {
    sub RX_NEXT () {	0x1c;}
}
unless(defined(&IntrStatus)) {
    sub IntrStatus () {	0x20;}
}
unless(defined(&IntrMask)) {
    sub IntrMask () {	0x24;}
}
unless(defined(&IntrControl)) {
    sub IntrControl () {	0x28;}
}
unless(defined(&IntrTimer)) {
    sub IntrTimer () {	0x2c;}
}
unless(defined(&PMControl)) {
    sub PMControl () {	0x30;}
}
unless(defined(&Reserved2)) {
    sub Reserved2 () {	0x34;}
}
unless(defined(&ROMControl)) {
    sub ROMControl () {	0x38;}
}
unless(defined(&ROMInterface)) {
    sub ROMInterface () {	0x3c;}
}
unless(defined(&StationControl)) {
    sub StationControl () {	0x40;}
}
unless(defined(&GMIIControl)) {
    sub GMIIControl () {	0x44;}
}
unless(defined(&GMacIOCR)) {
    sub GMacIOCR () {	0x48;}
}
unless(defined(&GMacIOCTL)) {
    sub GMacIOCTL () {	0x4c;}
}
unless(defined(&TxMacControl)) {
    sub TxMacControl () {	0x50;}
}
unless(defined(&TxMacTimeLimit)) {
    sub TxMacTimeLimit () {	0x54;}
}
unless(defined(&RGMIIDelay)) {
    sub RGMIIDelay () {	0x58;}
}
unless(defined(&Reserved3)) {
    sub Reserved3 () {	0x5c;}
}
unless(defined(&RxMacControl)) {
    sub RxMacControl () {	0x60;}
}
unless(defined(&RxMacAddr)) {
    sub RxMacAddr () {	0x62;}
}
unless(defined(&RxHashTable)) {
    sub RxHashTable () {	0x68;}
}
unless(defined(&RxHashTable2)) {
    sub RxHashTable2 () {	0x6c;}
}
unless(defined(&RxWakeOnLan)) {
    sub RxWakeOnLan () {	0x70;}
}
unless(defined(&RxWakeOnLanData)) {
    sub RxWakeOnLanData () {	0x74;}
}
unless(defined(&RxMPSControl)) {
    sub RxMPSControl () {	0x78;}
}
unless(defined(&Reserved4)) {
    sub Reserved4 () {	0x7c;}
}
unless(defined(&INTR_SOFT)) {
    sub INTR_SOFT () {	0x40000000;}
}
unless(defined(&INTR_TIMER)) {
    sub INTR_TIMER () {	0x20000000;}
}
unless(defined(&INTR_PAUSE_FRAME)) {
    sub INTR_PAUSE_FRAME () {	0x80000;}
}
unless(defined(&INTR_MAGIC_FRAME)) {
    sub INTR_MAGIC_FRAME () {	0x40000;}
}
unless(defined(&INTR_WAKE_FRAME)) {
    sub INTR_WAKE_FRAME () {	0x20000;}
}
unless(defined(&INTR_LINK)) {
    sub INTR_LINK () {	0x10000;}
}
unless(defined(&INTR_RX_IDLE)) {
    sub INTR_RX_IDLE () {	0x80;}
}
unless(defined(&INTR_RX_DONE)) {
    sub INTR_RX_DONE () {	0x40;}
}
unless(defined(&INTR_TXQ1_IDLE)) {
    sub INTR_TXQ1_IDLE () {	0x20;}
}
unless(defined(&INTR_TXQ1_DONE)) {
    sub INTR_TXQ1_DONE () {	0x10;}
}
unless(defined(&INTR_TX_IDLE)) {
    sub INTR_TX_IDLE () {	0x8;}
}
unless(defined(&INTR_TX_DONE)) {
    sub INTR_TX_DONE () {	0x4;}
}
unless(defined(&INTR_RX_HALT)) {
    sub INTR_RX_HALT () {	0x2;}
}
unless(defined(&INTR_TX_HALT)) {
    sub INTR_TX_HALT () {	0x1;}
}
unless(defined(&SE_INTRS)) {
    sub SE_INTRS () {	( &INTR_RX_IDLE |  &INTR_RX_DONE |  &INTR_TXQ1_IDLE |  &INTR_TXQ1_DONE | &INTR_TX_IDLE |  &INTR_TX_DONE |  &INTR_TX_HALT |  &INTR_RX_HALT);}
}
unless(defined(&RxRES)) {
    sub RxRES () {	0x200000;}
}
unless(defined(&RxCRC)) {
    sub RxCRC () {	0x80000;}
}
unless(defined(&RxRUNT)) {
    sub RxRUNT () {	0x100000;}
}
unless(defined(&RxRWT)) {
    sub RxRWT () {	0x400000;}
}
unless(defined(&RX_CTL_POLL)) {
    sub RX_CTL_POLL () {	0x10;}
}
unless(defined(&RX_CTL_ENB)) {
    sub RX_CTL_ENB () {	0x1;}
}
unless(defined(&TX_CTL_POLL)) {
    sub TX_CTL_POLL () {	0x10;}
}
unless(defined(&TX_CTL_ENB)) {
    sub TX_CTL_ENB () {	0x1;}
}
unless(defined(&AcceptBroadcast)) {
    sub AcceptBroadcast () {	0x800;}
}
unless(defined(&AcceptMulticast)) {
    sub AcceptMulticast () {	0x400;}
}
unless(defined(&AcceptMyPhys)) {
    sub AcceptMyPhys () {	0x200;}
}
unless(defined(&AcceptAllPhys)) {
    sub AcceptAllPhys () {	0x100;}
}
unless(defined(&AcceptErr)) {
    sub AcceptErr () {	0x20;}
}
unless(defined(&AcceptRunt)) {
    sub AcceptRunt () {	0x10;}
}
unless(defined(&RXMAC_STRIP_VLAN)) {
    sub RXMAC_STRIP_VLAN () {	0x20;}
}
unless(defined(&RXMAC_STRIP_FCS)) {
    sub RXMAC_STRIP_FCS () {	0x10;}
}
unless(defined(&RXMAC_PAD_ENB)) {
    sub RXMAC_PAD_ENB () {	0x4;}
}
unless(defined(&RXMAC_CSUM_ENB)) {
    sub RXMAC_CSUM_ENB () {	0x2;}
}
unless(defined(&SE_RX_PAD_BYTES)) {
    sub SE_RX_PAD_BYTES () {	10;}
}
unless(defined(&SC_LOOPBACK)) {
    sub SC_LOOPBACK () {	0x80000000;}
}
unless(defined(&SC_RGMII)) {
    sub SC_RGMII () {	0x8000;}
}
unless(defined(&SC_FDX)) {
    sub SC_FDX () {	0x1000;}
}
unless(defined(&SC_SPEED_MASK)) {
    sub SC_SPEED_MASK () {	0xc00;}
}
unless(defined(&SC_SPEED_10)) {
    sub SC_SPEED_10 () {	0x400;}
}
unless(defined(&SC_SPEED_100)) {
    sub SC_SPEED_100 () {	0x800;}
}
unless(defined(&SC_SPEED_1000)) {
    sub SC_SPEED_1000 () {	0xc00;}
}
unless(defined(&GMI_DATA)) {
    sub GMI_DATA () {	0xffff0000;}
}
unless(defined(&GMI_DATA_SHIFT)) {
    sub GMI_DATA_SHIFT () {	16;}
}
unless(defined(&GMI_REG)) {
    sub GMI_REG () {	0xf800;}
}
unless(defined(&GMI_REG_SHIFT)) {
    sub GMI_REG_SHIFT () {	11;}
}
unless(defined(&GMI_PHY)) {
    sub GMI_PHY () {	0x7c0;}
}
unless(defined(&GMI_PHY_SHIFT)) {
    sub GMI_PHY_SHIFT () {	6;}
}
unless(defined(&GMI_OP_WR)) {
    sub GMI_OP_WR () {	0x20;}
}
unless(defined(&GMI_OP_RD)) {
    sub GMI_OP_RD () {	0x;}
}
unless(defined(&GMI_REQ)) {
    sub GMI_REQ () {	0x10;}
}
unless(defined(&GMI_MDIO)) {
    sub GMI_MDIO () {	0x8;}
}
unless(defined(&GMI_MDDIR)) {
    sub GMI_MDDIR () {	0x4;}
}
unless(defined(&GMI_MDC)) {
    sub GMI_MDC () {	0x2;}
}
unless(defined(&GMI_MDEN)) {
    sub GMI_MDEN () {	0x1;}
}
unless(defined(&TDC_OWN)) {
    sub TDC_OWN () {	0x80000000;}
}
unless(defined(&TDC_INTR)) {
    sub TDC_INTR () {	0x40000000;}
}
unless(defined(&TDC_THOL3)) {
    sub TDC_THOL3 () {	0x30000000;}
}
unless(defined(&TDC_THOL2)) {
    sub TDC_THOL2 () {	0x20000000;}
}
unless(defined(&TDC_THOL1)) {
    sub TDC_THOL1 () {	0x10000000;}
}
unless(defined(&TDC_THOL0)) {
    sub TDC_THOL0 () {	0x;}
}
unless(defined(&TDC_LS)) {
    sub TDC_LS () {	0x8000000;}
}
unless(defined(&TDC_IP_CSUM)) {
    sub TDC_IP_CSUM () {	0x4000000;}
}
unless(defined(&TDC_TCP_CSUM)) {
    sub TDC_TCP_CSUM () {	0x2000000;}
}
unless(defined(&TDC_UDP_CSUM)) {
    sub TDC_UDP_CSUM () {	0x1000000;}
}
unless(defined(&TDC_BST)) {
    sub TDC_BST () {	0x800000;}
}
unless(defined(&TDC_EXT)) {
    sub TDC_EXT () {	0x400000;}
}
unless(defined(&TDC_DEF)) {
    sub TDC_DEF () {	0x200000;}
}
unless(defined(&TDC_BKF)) {
    sub TDC_BKF () {	0x100000;}
}
unless(defined(&TDC_CRS)) {
    sub TDC_CRS () {	0x80000;}
}
unless(defined(&TDC_COL)) {
    sub TDC_COL () {	0x40000;}
}
unless(defined(&TDC_CRC)) {
    sub TDC_CRC () {	0x20000;}
}
unless(defined(&TDC_PAD)) {
    sub TDC_PAD () {	0x10000;}
}
unless(defined(&TDC_VLAN_MASK)) {
    sub TDC_VLAN_MASK () {	0xffff;}
}
unless(defined(&SE_TX_INTR_FRAMES)) {
    sub SE_TX_INTR_FRAMES () {	32;}
}
unless(defined(&TDS_OWC)) {
    sub TDS_OWC () {	0x80000;}
}
unless(defined(&TDS_ABT)) {
    sub TDS_ABT () {	0x40000;}
}
unless(defined(&TDS_FIFO)) {
    sub TDS_FIFO () {	0x20000;}
}
unless(defined(&TDS_CRS)) {
    sub TDS_CRS () {	0x10000;}
}
unless(defined(&TDS_COLLS)) {
    sub TDS_COLLS () {	0xffff;}
}
unless(defined(&SE_TX_ERROR)) {
    sub SE_TX_ERROR {
	my($x) = @_;
	eval q((($x) & ( &TDS_OWC |  &TDS_ABT |  &TDS_FIFO |  &TDS_CRS)));
    }
}
unless(defined(&TX_ERR_BITS)) {
    sub TX_ERR_BITS () {	"\20" "\21CRS\22FIFO\23ABT\24OWC";}
}
unless(defined(&RDC_OWN)) {
    sub RDC_OWN () {	0x80000000;}
}
unless(defined(&RDC_INTR)) {
    sub RDC_INTR () {	0x40000000;}
}
unless(defined(&RDC_IP_CSUM)) {
    sub RDC_IP_CSUM () {	0x20000000;}
}
unless(defined(&RDC_TCP_CSUM)) {
    sub RDC_TCP_CSUM () {	0x10000000;}
}
unless(defined(&RDC_UDP_CSUM)) {
    sub RDC_UDP_CSUM () {	0x8000000;}
}
unless(defined(&RDC_IP_CSUM_OK)) {
    sub RDC_IP_CSUM_OK () {	0x4000000;}
}
unless(defined(&RDC_TCP_CSUM_OK)) {
    sub RDC_TCP_CSUM_OK () {	0x2000000;}
}
unless(defined(&RDC_UDP_CSUM_OK)) {
    sub RDC_UDP_CSUM_OK () {	0x1000000;}
}
unless(defined(&RDC_WAKEUP)) {
    sub RDC_WAKEUP () {	0x400000;}
}
unless(defined(&RDC_MAGIC)) {
    sub RDC_MAGIC () {	0x200000;}
}
unless(defined(&RDC_PAUSE)) {
    sub RDC_PAUSE () {	0x100000;}
}
unless(defined(&RDC_BCAST)) {
    sub RDC_BCAST () {	0xc0000;}
}
unless(defined(&RDC_MCAST)) {
    sub RDC_MCAST () {	0x80000;}
}
unless(defined(&RDC_UCAST)) {
    sub RDC_UCAST () {	0x40000;}
}
unless(defined(&RDC_CRCOFF)) {
    sub RDC_CRCOFF () {	0x20000;}
}
unless(defined(&RDC_PREADD)) {
    sub RDC_PREADD () {	0x10000;}
}
unless(defined(&RDC_VLAN_MASK)) {
    sub RDC_VLAN_MASK () {	0xffff;}
}
unless(defined(&RDS_VLAN)) {
    sub RDS_VLAN () {	0x80000000;}
}
unless(defined(&RDS_DESCS)) {
    sub RDS_DESCS () {	0x3f000000;}
}
unless(defined(&RDS_ABORT)) {
    sub RDS_ABORT () {	0x800000;}
}
unless(defined(&RDS_SHORT)) {
    sub RDS_SHORT () {	0x400000;}
}
unless(defined(&RDS_LIMIT)) {
    sub RDS_LIMIT () {	0x200000;}
}
unless(defined(&RDS_MIIER)) {
    sub RDS_MIIER () {	0x100000;}
}
unless(defined(&RDS_OVRUN)) {
    sub RDS_OVRUN () {	0x80000;}
}
unless(defined(&RDS_NIBON)) {
    sub RDS_NIBON () {	0x40000;}
}
unless(defined(&RDS_COLON)) {
    sub RDS_COLON () {	0x20000;}
}
unless(defined(&RDS_CRCOK)) {
    sub RDS_CRCOK () {	0x10000;}
}
unless(defined(&SE_RX_ERROR)) {
    sub SE_RX_ERROR {
	my($x) = @_;
	eval q((($x) & ( &RDS_COLON |  &RDS_NIBON |  &RDS_OVRUN |  &RDS_MIIER |  &RDS_LIMIT |  &RDS_SHORT |  &RDS_ABORT)));
    }
}
unless(defined(&SE_RX_NSEGS)) {
    sub SE_RX_NSEGS {
	my($x) = @_;
	eval q(((($x) &  &RDS_DESCS) >> 24));
    }
}
unless(defined(&RX_ERR_BITS)) {
    sub RX_ERR_BITS () {	"\20" "\21CRCOK\22COLON\23NIBON\24OVRUN" "\25MIIER\26LIMIT\27SHORT\30ABORT" "\40VLAN";}
}
unless(defined(&RING_END)) {
    sub RING_END () {	0x80000000;}
}
unless(defined(&SE_RX_BYTES)) {
    sub SE_RX_BYTES {
	my($x) = @_;
	eval q((($x) & 0xffff));
    }
}
unless(defined(&SE_INC)) {
    sub SE_INC {
	my($x, $y) = @_;
	eval q(($x) = ((($x) + 1) % $y));
    }
}
unless(defined(&EI_DATA)) {
    sub EI_DATA () {	0xffff0000;}
}
unless(defined(&EI_DATA_SHIFT)) {
    sub EI_DATA_SHIFT () {	16;}
}
unless(defined(&EI_OFFSET)) {
    sub EI_OFFSET () {	0xfc00;}
}
unless(defined(&EI_OFFSET_SHIFT)) {
    sub EI_OFFSET_SHIFT () {	10;}
}
unless(defined(&EI_OP)) {
    sub EI_OP () {	0x300;}
}
unless(defined(&EI_OP_SHIFT)) {
    sub EI_OP_SHIFT () {	8;}
}
unless(defined(&EI_OP_RD)) {
    sub EI_OP_RD () {	(2<<  &EI_OP_SHIFT);}
}
unless(defined(&EI_OP_WR)) {
    sub EI_OP_WR () {	(1<<  &EI_OP_SHIFT);}
}
unless(defined(&EI_REQ)) {
    sub EI_REQ () {	0x80;}
}
unless(defined(&EI_DO)) {
    sub EI_DO () {	0x8;}
}
unless(defined(&EI_DI)) {
    sub EI_DI () {	0x4;}
}
unless(defined(&EI_CLK)) {
    sub EI_CLK () {	0x2;}
}
unless(defined(&EI_CS)) {
    sub EI_CS () {	0x1;}
}
unless(defined(&EEPROMSignature)) {
    sub EEPROMSignature () {	0x;}
}
unless(defined(&EEPROMCLK)) {
    sub EEPROMCLK () {	0x1;}
}
unless(defined(&EEPROMInfo)) {
    sub EEPROMInfo () {	0x2;}
}
unless(defined(&EEPROMMACAddr)) {
    sub EEPROMMACAddr () {	0x3;}
}
unless(defined(&SE_TIMEOUT)) {
    sub SE_TIMEOUT () {	1000;}
}
1;
