/*
 * Decompiled with CFR 0.152.
 */
package msfgui;

import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import msfgui.Base64;
import msfgui.InteractWindow;
import msfgui.MsfFrame;
import msfgui.MsfguiApp;
import msfgui.RpcConnection;
import msfgui.TableHelper;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class ProcessList
extends MsfFrame {
    protected final Map session;
    protected final RpcConnection rpcConn;
    protected ReentrantLock lock;
    protected final DefaultTableModel model;
    protected Timer readTimer = null;
    private JScrollPane jScrollPane1;
    private JButton killButton;
    private JButton migrateButton;
    private JTable processTable;
    private JButton refreshButton;

    public ProcessList(RpcConnection rpcConn, Map session, Map sessionPopupMap) {
        super("Meterpreter remote process list");
        this.initComponents();
        this.model = new DefaultTableModel(){

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.processTable.setModel(this.model);
        this.processTable.setShowHorizontalLines(false);
        this.processTable.setShowVerticalLines(false);
        this.rpcConn = rpcConn;
        this.session = session;
        this.lock = ((InteractWindow)sessionPopupMap.get(session.get((Object)"uuid"))).lock;
    }

    protected void listProcs() throws HeadlessException {
        block2: {
            try {
                this.rpcConn.execute("session.meterpreter_write", this.session.get("id"), Base64.encode("ps\n".getBytes()));
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex);
                if (!ex.getMessage().equals("unknown session")) break block2;
                return;
            }
        }
        this.readTimer = new Timer(300, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Map received = (Map)ProcessList.this.rpcConn.execute("session.meterpreter_read", ProcessList.this.session.get("id"));
                    if (!received.get("encoding").equals("base64")) {
                        JOptionPane.showMessageDialog(null, "uhoh. encoding changed. Time to update msfgui?");
                        return;
                    }
                    byte[] decodedBytes = Base64.decode(received.get("data").toString());
                    if (decodedBytes.length == 0) {
                        return;
                    }
                    String[] lines = new String(decodedBytes).split("\n");
                    String headerRow = null;
                    for (String line : lines) {
                        if ((line = line.trim()).startsWith("PID")) {
                            headerRow = line;
                            ProcessList.this.model.setColumnIdentifiers(line.split("\\s+"));
                            while (ProcessList.this.model.getRowCount() > 0) {
                                ProcessList.this.model.removeRow(0);
                            }
                        }
                        if (line.length() < 2 || line.charAt(1) < '0' || line.charAt(1) > '9') continue;
                        ProcessList.this.model.addRow(TableHelper.fill(line, headerRow));
                    }
                    ProcessList.this.readTimer.stop();
                    TableHelper.fitColumnWidths(ProcessList.this.model, ProcessList.this.processTable);
                }
                catch (NullPointerException nex) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (ex.getMessage().equals("unknown session")) {
                        ProcessList.this.readTimer.stop();
                    }
                    JOptionPane.showMessageDialog(null, ex.getMessage());
                }
            }
        });
        this.readTimer.start();
    }

    private void initComponents() {
        this.migrateButton = new JButton();
        this.killButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.processTable = new JTable();
        this.refreshButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ProcessList.this.formWindowClosing(evt);
            }

            public void windowOpened(WindowEvent evt) {
                ProcessList.this.formWindowOpened(evt);
            }
        });
        ResourceMap resourceMap = Application.getInstance(MsfguiApp.class).getContext().getResourceMap(ProcessList.class);
        this.migrateButton.setText(resourceMap.getString("migrateButton.text", new Object[0]));
        this.migrateButton.setName("migrateButton");
        this.migrateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcessList.this.migrateButtonActionPerformed(evt);
            }
        });
        this.killButton.setText(resourceMap.getString("killButton.text", new Object[0]));
        this.killButton.setName("killButton");
        this.killButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcessList.this.killButtonActionPerformed(evt);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.processTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "PID", "User", "Session", "Path"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.processTable.setName("processTable");
        this.jScrollPane1.setViewportView(this.processTable);
        this.refreshButton.setText(resourceMap.getString("refreshButton.text", new Object[0]));
        this.refreshButton.setName("refreshButton");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcessList.this.refreshButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 807, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 588, Short.MAX_VALUE).addComponent(this.killButton).addGap(18, 18, 18).addComponent(this.migrateButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 602, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.migrateButton).addComponent(this.killButton).addComponent(this.refreshButton)).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.lock.unlock();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.lock.lock();
        this.listProcs();
    }

    private void migrateButtonActionPerformed(ActionEvent evt) {
        try {
            this.rpcConn.execute("session.meterpreter_write", this.session.get("id"), Base64.encode(("migrate " + this.processTable.getModel().getValueAt(this.processTable.getSelectedRow(), 0) + "\n").getBytes()));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex);
        }
        this.listProcs();
    }

    private void killButtonActionPerformed(ActionEvent evt) {
        try {
            this.rpcConn.execute("session.meterpreter_write", this.session.get("id"), Base64.encode(("kill " + this.processTable.getModel().getValueAt(this.processTable.getSelectedRow(), 0) + "\n").getBytes()));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex);
        }
        this.listProcs();
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.listProcs();
    }
}

