C      $Id: x19f.fm4 6645 2006-05-27 22:02:53Z hbabcock $
C
C      Copyright (C) 2004  Alan W. Irwin
C
C      This file is part of PLplot.
C
C      PLplot is free software; you can redistribute it and/or modify
C      it under the terms of the GNU General Library Public License as
C      published by the Free Software Foundation; either version 2 of the
C      License, or (at your option) any later version.
C
C      PLplot is distributed in the hope that it will be useful,
C      but WITHOUT ANY WARRANTY; without even the implied warranty of
C      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C      GNU Library General Public License for more details.
C
C      You should have received a copy of the GNU Library General Public
C      License along with PLplot; if not, write to the Free Software
C      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA


!--------------------------------------------------------------------------
! ident
!
! Defines identity transformation for example 19.
! x(), y() are the coordinates to be plotted.
! This is a 0-OP routine, to play the role of NULL in the C version!
!--------------------------------------------------------------------------

      subroutine ident(n, x, y)
      implicit none

      integer n
      real*8    x
      real*8    y

      return
      end

!--------------------------------------------------------------------------
! mapform19
!
! Defines specific coordinate transformation for example 19.
! Not to be confused with mapform in src/plmap.c.
! x(), y() are the coordinates to be plotted.
!--------------------------------------------------------------------------

      subroutine mapform19(n, x, y)
      implicit none

      integer n
      real*8    x(n)
      real*8    y(n)
      real*8    PI
      parameter ( PI = 3.1415926535897932384d0 )

      integer i
      real*8    xp, yp, radius

      do i = 1,n
         radius = 90.0d0 - y(i)
         xp = radius * cos(x(i) * PI / 180.0d0)
         yp = radius * sin(x(i) * PI / 180.0d0)
         x(i) = xp
         y(i) = yp
      enddo
      return
      end

!--------------------------------------------------------------------------
! main
!
! Shows two views of the world map.
!--------------------------------------------------------------------------

      program x19f
      implicit none
      real*8    minx, maxx, miny, maxy
      external ident
      external mapform19

      integer PL_PARSE_FULL
      parameter(PL_PARSE_FULL = 1)
C      Process command-line arguments
      call plparseopts(PL_PARSE_FULL)

! Longitude (x) and latitude (y)

      miny = -70
      maxy = 80

      call plinit()

! Cartesian plots
! Most of world

      minx = 190
      maxx = 190+360

      call plcol0(1)
      call plenv(minx, maxx, miny, maxy, 1, -1)
      call plmap(ident, 'usaglobe', minx, maxx, miny, maxy)

! The Americas

      minx = 190
      maxx = 340

      call plcol0(1)
      call plenv(minx, maxx, miny, maxy, 1, -1)
      call plmap(ident, 'usaglobe', minx, maxx, miny, maxy)

! Polar, Northern hemisphere

      minx = 0
      maxx = 360

      call plenv(-75.d0, 75.d0, -75.d0,
     &        75.d0, 1, -1)
      call plmap(mapform19,'globe', minx, maxx, miny, maxy)

      call pllsty(2)
      call plmeridians(mapform19,10.0d0, 10.0d0,
     &        0.0d0, 360.0d0, -10.0d0,
     &        80.0d0)
      call plend()
      end
