/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class UndoableEditSupport {
    protected int updateLevel;
    protected CompoundEdit compoundEdit;
    protected Vector listeners;
    protected Object realSource;

    private /* synthetic */ void finit$() {
        this.listeners = new Vector();
    }

    public UndoableEditSupport() {
        this.finit$();
        this.realSource = this;
    }

    public UndoableEditSupport(Object object) {
        this.finit$();
        if (object == null) {
            object = this;
        }
        this.realSource = object;
    }

    public String toString() {
        return super.toString() + " updateLevel: " + this.updateLevel + " listeners: " + this.listeners + " compoundEdit: " + this.compoundEdit;
    }

    public synchronized void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(undoableEditListener);
    }

    public synchronized void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.removeElement(undoableEditListener);
    }

    public synchronized UndoableEditListener[] getUndoableEditListeners() {
        Object[] objectArray = new UndoableEditListener[this.listeners.size()];
        return (UndoableEditListener[])this.listeners.toArray(objectArray);
    }

    protected void _postEdit(UndoableEdit undoableEdit) {
        if (this.listeners.isEmpty()) {
            return;
        }
        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this.realSource, undoableEdit);
        Iterator iterator = ((Vector)this.listeners.clone()).iterator();
        while (iterator.hasNext()) {
            ((UndoableEditListener)iterator.next()).undoableEditHappened(undoableEditEvent);
        }
    }

    public synchronized void postEdit(UndoableEdit undoableEdit) {
        if (this.compoundEdit != null) {
            this.compoundEdit.addEdit(undoableEdit);
        } else {
            this._postEdit(undoableEdit);
        }
    }

    public int getUpdateLevel() {
        return this.updateLevel;
    }

    public synchronized void beginUpdate() {
        if (this.compoundEdit == null) {
            this.compoundEdit = this.createCompoundEdit();
        }
        ++this.updateLevel;
    }

    protected CompoundEdit createCompoundEdit() {
        return new CompoundEdit();
    }

    public synchronized void endUpdate() {
        if (this.updateLevel == 0) {
            throw new IllegalStateException();
        }
        if (--this.updateLevel > 0) {
            return;
        }
        this.compoundEdit.end();
        this._postEdit(this.compoundEdit);
        this.compoundEdit = null;
    }
}

