/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import gnu.javax.security.auth.login.GnuConfiguration;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;

public abstract class Configuration {
    private static Configuration config;

    protected Configuration() {
    }

    public static synchronized Configuration getConfiguration() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getLoginConfiguration"));
        }
        return Configuration.getConfig();
    }

    public static synchronized void setConfiguration(Configuration configuration) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("setLoginConfiguration"));
        }
        config = configuration;
    }

    public abstract AppConfigurationEntry[] getAppConfigurationEntry(String var1);

    public abstract void refresh();

    static Configuration getConfig() {
        if (config == null) {
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(null){
                private /* synthetic */ Configuration this$0;
                {
                    this.this$0 = configuration;
                }

                public Object run() {
                    return Security.getProperty("login.configuration.provider");
                }
            });
            try {
                config = string != null ? (Configuration)Class.forName(string).newInstance() : new GnuConfiguration();
            }
            catch (Exception exception) {
                config = new GnuConfiguration();
            }
        }
        return config;
    }
}

