/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import gnu.java.util.regex.RE;
import gnu.java.util.regex.REException;
import gnu.java.util.regex.RESyntax;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;

public final class Pattern
implements Serializable {
    private static final long serialVersionUID = 5073258162644648461L;
    public static final int CANON_EQ = 128;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int DOTALL = 32;
    public static final int MULTILINE = 8;
    public static final int UNICODE_CASE = 64;
    public static final int UNIX_LINES = 1;
    private final String regex;
    private final int flags;
    private final RE re;

    private Pattern(String string, int n) throws PatternSyntaxException {
        this.regex = string;
        this.flags = n;
        RESyntax rESyntax = RESyntax.RE_SYNTAX_JAVA_1_4;
        int n2 = 0;
        n2 |= 0x800;
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        if ((n & 8) != 0) {
            n2 |= 8;
            rESyntax = new RESyntax(rESyntax);
            rESyntax.setLineSeparator(null);
        }
        if ((n & 0x20) != 0) {
            n2 |= 4;
        }
        if ((n & 0x40) != 0) {
            n2 &= 0xFFFFF7FF;
        }
        if ((n & 1) != 0) {
            rESyntax = new RESyntax(rESyntax);
            rESyntax.setLineSeparator("\n");
        }
        if ((n & 4) != 0) {
            n2 |= 0x400;
        }
        try {
            this.re = new RE(string, n2, rESyntax);
        }
        catch (REException rEException) {
            PatternSyntaxException patternSyntaxException = new PatternSyntaxException(rEException.getMessage(), string, rEException.getPosition());
            patternSyntaxException.initCause(rEException);
            throw patternSyntaxException;
        }
    }

    RE getRE() {
        return this.re;
    }

    public static Pattern compile(String string) throws PatternSyntaxException {
        return Pattern.compile(string, 0);
    }

    public static Pattern compile(String string, int n) throws PatternSyntaxException {
        if ((n & 0xFFFFFF10) != 0) {
            throw new IllegalArgumentException();
        }
        return new Pattern(string, n);
    }

    public int flags() {
        return this.flags;
    }

    public static boolean matches(String string, CharSequence charSequence) {
        return Pattern.compile(string).matcher(charSequence).matches();
    }

    public Matcher matcher(CharSequence charSequence) {
        return new Matcher(this, charSequence);
    }

    public String[] split(CharSequence charSequence) {
        return this.split(charSequence, 0);
    }

    public String[] split(CharSequence charSequence, int n) {
        String string;
        boolean bl;
        Matcher matcher = new Matcher(this, charSequence);
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = matcher.find();
        while (bl2 && (n <= 0 || n3 < n - 1)) {
            ++n3;
            int n5 = matcher.start();
            if (n4 == n5) {
                ++n2;
            } else {
                while (n2 > 0) {
                    arrayList.add("");
                    --n2;
                }
                String string2 = charSequence.subSequence(n4, n5).toString();
                arrayList.add(string2);
            }
            n4 = matcher.end();
            bl2 = matcher.find();
        }
        if (!bl2 && n3 == 0) {
            return new String[]{charSequence.toString()};
        }
        boolean bl3 = bl = n4 == charSequence.length();
        if (arrayList.size() < n || n < 0 || n == 0 && !bl) {
            if (n > arrayList.size()) {
                int n6 = n - arrayList.size();
                int n7 = n2 = n2 > n6 ? n6 : n2;
            }
            while (n2 > 0) {
                arrayList.add("");
                --n2;
            }
        }
        if (!(n == 0 && (n != 0 || bl) || "".equals(string = charSequence.subSequence(n4, charSequence.length()).toString()) && n == 0)) {
            arrayList.add(string);
        }
        Object[] objectArray = new String[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    public String pattern() {
        return this.regex;
    }
}

