/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class TimeType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    TimeType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "time"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        int n2 = 3;
        int n3 = 0;
        block13: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '-' && n2 == 0) {
                ++n3;
                continue;
            }
            if (c >= '0' && c <= '9') continue;
            switch (n2) {
                case 3: {
                    if (c != ':') throw new DatatypeException(i, "invalid time value");
                    if (i - n3 != 2) {
                        throw new DatatypeException(i, "invalid time value");
                    }
                    n2 = 4;
                    n3 = i + 1;
                    continue block13;
                }
                case 4: {
                    if (c != ':') throw new DatatypeException(i, "invalid time value");
                    if (i - n3 != 2) {
                        throw new DatatypeException(i, "invalid time value");
                    }
                    n2 = 5;
                    n3 = i + 1;
                    continue block13;
                }
                case 5: {
                    if (c == '.') {
                        if (i - n3 != 2) {
                            throw new DatatypeException(i, "invalid time value");
                        }
                        n2 = 6;
                        n3 = i + 1;
                        continue block13;
                    }
                    if (c != ' ') throw new DatatypeException(i, "invalid time value");
                    if (i - n3 != 2) {
                        throw new DatatypeException(i, "invalid time value");
                    }
                    n2 = 7;
                    n3 = i + 1;
                    continue block13;
                }
                case 6: {
                    if (c != ' ') throw new DatatypeException(i, "invalid time value");
                    n2 = 7;
                    n3 = i + 1;
                    continue block13;
                }
                case 7: {
                    if (n3 == i) {
                        if (c == '+' || c == '-') continue block13;
                        if (c == 'Z') {
                            n2 = 9;
                            n3 = i + 1;
                            continue block13;
                        }
                    }
                    if (c != ':') throw new DatatypeException(i, "invalid time value");
                    if (i - n3 != 2) {
                        throw new DatatypeException(i, "invalid time value");
                    }
                    n2 = 8;
                    n3 = i + 1;
                    continue block13;
                }
                default: {
                    throw new DatatypeException(i, "invalid time value");
                }
            }
        }
        switch (n2) {
            case 5: {
                if (n - n3 == 2) return;
                throw new DatatypeException(n, "invalid time value");
            }
            case 6: {
                return;
            }
            case 8: {
                if (n - n3 == 2) return;
                throw new DatatypeException(n, "invalid time value");
            }
            case 9: {
                return;
            }
            default: {
                throw new DatatypeException(n, "invalid time value");
            }
        }
    }

    public Object createValue(String string, ValidationContext validationContext) {
        int n = string.length();
        int n2 = 3;
        int n3 = 0;
        Time time = new Time();
        try {
            int n4;
            block7: for (int i = 0; i < n; ++i) {
                n4 = string.charAt(i);
                if (n4 >= 48 && n4 <= 57) continue;
                switch (n2) {
                    case 3: {
                        if (n4 != 58) continue block7;
                        time.minutes = Integer.parseInt(string.substring(n3, i)) * 60;
                        n2 = 4;
                        n3 = i + 1;
                        continue block7;
                    }
                    case 4: {
                        if (n4 != 58) continue block7;
                        time.minutes += Integer.parseInt(string.substring(n3, i));
                        n2 = 5;
                        n3 = i + 1;
                        continue block7;
                    }
                    case 5: {
                        if (n4 != 32) continue block7;
                        time.seconds = Float.parseFloat(string.substring(n3, i));
                        n2 = 7;
                        n3 = i + 1;
                        continue block7;
                    }
                }
            }
            if (n - n3 > 0 && n2 == 7) {
                String string2 = string.substring(n - n3);
                n4 = string2.indexOf(58);
                if (n4 == -1) {
                    TimeZone timeZone;
                    if ("Z".equals(string2)) {
                        string2 = "UTC";
                    }
                    if ((timeZone = TimeZone.getTimeZone(string2)) == null) {
                        return null;
                    }
                    time.minutes += timeZone.getRawOffset();
                } else {
                    String string3 = string2.substring(0, n4);
                    String string4 = string2.substring(n4 + 1);
                    int n5 = Integer.parseInt(string3) * 60;
                    n5 = n5 < 0 ? (n5 -= Integer.parseInt(string4)) : (n5 += Integer.parseInt(string4));
                    time.minutes += n5;
                }
            }
            return time;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static class Time
    implements Comparable {
        int minutes;
        float seconds;

        public int hashCode() {
            return this.minutes * 31 + new Float(this.seconds).hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Time) {
                Time time = (Time)object;
                return time.minutes == this.minutes && time.seconds == this.seconds;
            }
            return false;
        }

        public int compareTo(Object object) {
            if (object instanceof Time) {
                Time time = (Time)object;
                if (time.minutes != this.minutes) {
                    return this.minutes - time.minutes;
                }
                if (time.seconds == this.seconds) {
                    return 0;
                }
                if (this.seconds < time.seconds) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        Time() {
        }
    }
}

