/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.channels;

import gnu.java.nio.FileLockImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class FileChannelImpl
extends FileChannel {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int APPEND = 4;
    public static final int EXCL = 8;
    public static final int SYNC = 16;
    public static final int DSYNC = 32;
    private int fd;
    private long pos;
    private int mode;
    public static FileChannelImpl in;
    public static FileChannelImpl out;
    public static FileChannelImpl err;

    private /* synthetic */ void finit$() {
        this.fd = -1;
    }

    private static native void init();

    public FileChannelImpl() {
        this.finit$();
    }

    public static FileChannelImpl create(File file, int n) throws FileNotFoundException {
        return new FileChannelImpl(file, n);
    }

    private FileChannelImpl(File file, int n) throws FileNotFoundException {
        this.finit$();
        String string = file.getPath();
        this.fd = this.open(string, n);
        this.mode = n;
        if (file.isDirectory()) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new FileNotFoundException(string + " is a directory");
        }
    }

    FileChannelImpl(int n, int n2) {
        this.finit$();
        this.fd = n;
        this.mode = n2;
    }

    private native int open(String var1, int var2) throws FileNotFoundException;

    public native int available() throws IOException;

    private native long implPosition() throws IOException;

    private native void seek(long var1) throws IOException;

    private native void implTruncate(long var1) throws IOException;

    public native void unlock(long var1, long var3) throws IOException;

    public native long size() throws IOException;

    protected native void implCloseChannel() throws IOException;

    protected void finalize() throws IOException {
        this.close();
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = new byte[byteBuffer.remaining()];
        int n = this.read(byArray, 0, byArray.length);
        if (n > 0) {
            byteBuffer.put(byArray, 0, n);
        }
        return n;
    }

    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        long l2 = this.implPosition();
        this.position(l);
        int n = this.read(byteBuffer);
        this.position(l2);
        return n;
    }

    public native int read() throws IOException;

    public native int read(byte[] var1, int var2, int var3) throws IOException;

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l = 0L;
        for (int i = n; i < n + n2; ++i) {
            l += (long)this.read(byteBufferArray[i]);
        }
        return l;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            this.write(byArray, byteBuffer.arrayOffset() + byteBuffer.position(), n);
            byteBuffer.position(byteBuffer.position() + n);
        } else {
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray, 0, n);
            this.write(byArray, 0, n);
        }
        return n;
    }

    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        long l2 = this.implPosition();
        this.seek(l);
        int n = this.write(byteBuffer);
        this.seek(l2);
        return n;
    }

    public native void write(byte[] var1, int var2, int var3) throws IOException;

    public native void write(int var1) throws IOException;

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l = 0L;
        for (int i = n; i < n + n2; ++i) {
            l += (long)this.write(byteBufferArray[i]);
        }
        return l;
    }

    public native MappedByteBuffer mapImpl(char var1, long var2, int var4) throws IOException;

    public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l2) throws IOException {
        char c = '\u0000';
        if (mapMode == FileChannel.MapMode.READ_ONLY) {
            c = 'r';
            if ((this.mode & 1) == 0) {
                throw new NonReadableChannelException();
            }
        } else if (mapMode == FileChannel.MapMode.READ_WRITE || mapMode == FileChannel.MapMode.PRIVATE) {
            char c2 = c = mapMode == FileChannel.MapMode.READ_WRITE ? (char)'+' : 'c';
            if ((this.mode & 3) != 3) {
                throw new NonWritableChannelException();
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (l < 0L || l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.mapImpl(c, l, (int)l2);
    }

    public void force(boolean bl) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private int smallTransferTo(long l, int n, WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer byteBuffer;
        try {
            byteBuffer = this.map(FileChannel.MapMode.READ_ONLY, l, n);
        }
        catch (IOException iOException) {
            byteBuffer = ByteBuffer.allocate(n);
            this.read(byteBuffer, l);
            byteBuffer.flip();
        }
        return writableByteChannel.write(byteBuffer);
    }

    public long transferTo(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
        int n;
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 1) == 0) {
            throw new NonReadableChannelException();
        }
        int n2 = 65536;
        long l3 = 0L;
        while (l2 > 0L && (n = this.smallTransferTo(l, (int)Math.min(l2, (long)n2), writableByteChannel)) >= 0) {
            l3 += (long)n;
            l += (long)n;
            l2 -= (long)n;
        }
        return l3;
    }

    private int smallTransferFrom(ReadableByteChannel readableByteChannel, long l, int n) throws IOException {
        ByteBuffer byteBuffer = null;
        if (readableByteChannel instanceof FileChannel) {
            try {
                byteBuffer = ((FileChannel)readableByteChannel).map(FileChannel.MapMode.READ_ONLY, l, n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(n);
            readableByteChannel.read(byteBuffer);
            byteBuffer.flip();
        }
        return this.write(byteBuffer, l);
    }

    public long transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
        int n;
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        int n2 = 65536;
        long l3 = 0L;
        while (l2 > 0L && (n = this.smallTransferFrom(readableByteChannel, l, (int)Math.min(l2, (long)n2))) >= 0) {
            l3 += (long)n;
            l += (long)n;
            l2 -= (long)n;
        }
        return l3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        FileLock fileLock;
        boolean bl2;
        block9: {
            FileLockImpl fileLockImpl;
            block8: {
                if (l < 0L) {
                    throw new IllegalArgumentException();
                }
                if (l2 < 0L) {
                    throw new IllegalArgumentException();
                }
                if (!this.isOpen()) {
                    throw new ClosedChannelException();
                }
                if (bl && (this.mode & 1) == 0) {
                    throw new NonReadableChannelException();
                }
                if (!bl && (this.mode & 2) == 0) {
                    throw new NonWritableChannelException();
                }
                bl2 = false;
                try {
                    this.begin();
                    boolean bl3 = this.lock(l, l2, bl, false);
                    bl2 = true;
                    if (bl3) {
                        fileLockImpl = new FileLockImpl(this, l, l2, bl);
                        Object var9_8 = null;
                        break block8;
                    }
                    fileLock = null;
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.end(bl2);
                    throw throwable;
                }
            }
            this.end(bl2);
            return fileLockImpl;
        }
        Object var9_9 = null;
        this.end(bl2);
        return fileLock;
    }

    private native boolean lock(long var1, long var3, boolean var5, boolean var6) throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileLock lock(long l, long l2, boolean bl) throws IOException {
        FileLock fileLock;
        boolean bl2;
        block7: {
            FileLockImpl fileLockImpl;
            block6: {
                if (l < 0L) {
                    throw new IllegalArgumentException();
                }
                if (l2 < 0L) {
                    throw new IllegalArgumentException();
                }
                if (!this.isOpen()) {
                    throw new ClosedChannelException();
                }
                bl2 = false;
                try {
                    boolean bl3 = this.lock(l, l2, bl, true);
                    bl2 = true;
                    if (bl3) {
                        fileLockImpl = new FileLockImpl(this, l, l2, bl);
                        Object var9_8 = null;
                        break block6;
                    }
                    fileLock = null;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.end(bl2);
                    throw throwable;
                }
            }
            this.end(bl2);
            return fileLockImpl;
        }
        Object var9_9 = null;
        this.end(bl2);
        return fileLock;
    }

    public long position() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.implPosition();
    }

    public FileChannel position(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.seek(l);
        return this;
    }

    public FileChannel truncate(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        if (l < this.size()) {
            this.implTruncate(l);
        }
        return this;
    }

    static {
        FileChannelImpl.init();
    }
}

