# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{amalgalite}
  s.version = "1.1.2"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Jeremy Hinegardner"]
  s.date = %q{2011-04-01}
  s.default_executable = %q{amalgalite-pack}
  s.description = %q{Amalgalite embeds the SQLite database engine in a ruby extension.  There is no
need to install SQLite separately.  

Look in the examples/ directory to see

* general usage
* blob io
* schema information
* custom functions
* custom aggregates
* requiring ruby code from a database
* full text search

Also Scroll through Amalgalite::Database for a quick example, and a general
overview of the API.

Amalgalite adds in the following additional non-default SQLite extensions:

* {R*Tree index extension}[http://sqlite.org/rtree.html]
* {Full Text Search}[http://sqlite.org/fts3.html]}
  s.email = %q{jeremy@hinegardner.org}
  s.executables = ["amalgalite-pack"]
  s.extensions = ["ext/amalgalite/extconf.rb"]
  s.extra_rdoc_files = ["README.rdoc", "HISTORY.rdoc", "LICENSE", "lib/amalgalite/aggregate.rb", "lib/amalgalite/blob.rb", "lib/amalgalite/boolean.rb", "lib/amalgalite/busy_timeout.rb", "lib/amalgalite/column.rb", "lib/amalgalite/core_ext/kernel/require.rb", "lib/amalgalite/csv_table_importer.rb", "lib/amalgalite/database.rb", "lib/amalgalite/function.rb", "lib/amalgalite/index.rb", "lib/amalgalite/memory_database.rb", "lib/amalgalite/packer.rb", "lib/amalgalite/paths.rb", "lib/amalgalite/profile_tap.rb", "lib/amalgalite/progress_handler.rb", "lib/amalgalite/requires.rb", "lib/amalgalite/schema.rb", "lib/amalgalite/sqlite3/constants.rb", "lib/amalgalite/sqlite3/database/function.rb", "lib/amalgalite/sqlite3/database/status.rb", "lib/amalgalite/sqlite3/status.rb", "lib/amalgalite/sqlite3/version.rb", "lib/amalgalite/sqlite3.rb", "lib/amalgalite/statement.rb", "lib/amalgalite/table.rb", "lib/amalgalite/taps/console.rb", "lib/amalgalite/taps/io.rb", "lib/amalgalite/taps.rb", "lib/amalgalite/trace_tap.rb", "lib/amalgalite/type_map.rb", "lib/amalgalite/type_maps/default_map.rb", "lib/amalgalite/type_maps/storage_map.rb", "lib/amalgalite/type_maps/text_map.rb", "lib/amalgalite/version.rb", "lib/amalgalite/view.rb", "lib/amalgalite.rb"]
  s.files = ["bin/amalgalite-pack", "ext/amalgalite/amalgalite3.c", "ext/amalgalite/amalgalite3_blob.c", "ext/amalgalite/amalgalite3_constants.c", "ext/amalgalite/amalgalite3_database.c", "ext/amalgalite/amalgalite3_requires_bootstrap.c", "ext/amalgalite/amalgalite3_statement.c", "ext/amalgalite/sqlite3.c", "ext/amalgalite/amalgalite3.h", "ext/amalgalite/sqlite3.h", "ext/amalgalite/sqlite3_options.h", "ext/amalgalite/sqlite3ext.h", "ext/amalgalite/extconf.rb", "ext/amalgalite/gen_constants.rb", "examples/a.rb", "examples/blob.rb", "examples/bootstrap.rb", "examples/define_aggregate.rb", "examples/define_function.rb", "examples/fts3.rb", "examples/gem-db.rb", "examples/require_me.rb", "examples/requires.rb", "examples/schema-info.rb", "lib/amalgalite/aggregate.rb", "lib/amalgalite/blob.rb", "lib/amalgalite/boolean.rb", "lib/amalgalite/busy_timeout.rb", "lib/amalgalite/column.rb", "lib/amalgalite/core_ext/kernel/require.rb", "lib/amalgalite/csv_table_importer.rb", "lib/amalgalite/database.rb", "lib/amalgalite/function.rb", "lib/amalgalite/index.rb", "lib/amalgalite/memory_database.rb", "lib/amalgalite/packer.rb", "lib/amalgalite/paths.rb", "lib/amalgalite/profile_tap.rb", "lib/amalgalite/progress_handler.rb", "lib/amalgalite/requires.rb", "lib/amalgalite/schema.rb", "lib/amalgalite/sqlite3/constants.rb", "lib/amalgalite/sqlite3/database/function.rb", "lib/amalgalite/sqlite3/database/status.rb", "lib/amalgalite/sqlite3/status.rb", "lib/amalgalite/sqlite3/version.rb", "lib/amalgalite/sqlite3.rb", "lib/amalgalite/statement.rb", "lib/amalgalite/table.rb", "lib/amalgalite/taps/console.rb", "lib/amalgalite/taps/io.rb", "lib/amalgalite/taps.rb", "lib/amalgalite/trace_tap.rb", "lib/amalgalite/type_map.rb", "lib/amalgalite/type_maps/default_map.rb", "lib/amalgalite/type_maps/storage_map.rb", "lib/amalgalite/type_maps/text_map.rb", "lib/amalgalite/version.rb", "lib/amalgalite/view.rb", "lib/amalgalite.rb", "spec/aggregate_spec.rb", "spec/amalgalite_spec.rb", "spec/blob_spec.rb", "spec/boolean_spec.rb", "spec/busy_handler.rb", "spec/database_spec.rb", "spec/default_map_spec.rb", "spec/function_spec.rb", "spec/integeration_spec.rb", "spec/iso_3166_database.rb", "spec/packer_spec.rb", "spec/paths_spec.rb", "spec/progress_handler_spec.rb", "spec/requires_spec.rb", "spec/rtree_spec.rb", "spec/schema_spec.rb", "spec/spec_helper.rb", "spec/sqlite3/constants_spec.rb", "spec/sqlite3/database_status_spec.rb", "spec/sqlite3/status_spec.rb", "spec/sqlite3/version_spec.rb", "spec/sqlite3_spec.rb", "spec/statement_spec.rb", "spec/storage_map_spec.rb", "spec/tap_spec.rb", "spec/text_map_spec.rb", "spec/type_map_spec.rb", "spec/version_spec.rb", "spec/data/iso-3166-schema.sql", "spec/data/iso-3166-country.txt", "spec/data/iso-3166-subcountry.txt", "spec/data/make-iso-db.sh", "README.rdoc", "HISTORY.rdoc", "LICENSE", "tasks/announce.rake", "tasks/distribution.rake", "tasks/documentation.rake", "tasks/extension.rake", "tasks/rspec.rake", "tasks/config.rb", "tasks/utils.rb", "gemspec.rb"]
  s.homepage = %q{http://copiousfreetime.rubyforge.org/amalgalite/}
  s.rdoc_options = ["--main", "README.rdoc"]
  s.require_paths = ["lib"]
  s.rubyforge_project = %q{copiousfreetime}
  s.rubygems_version = %q{1.3.7}
  s.summary = %q{Amalgalite embeds the SQLite database engine in a ruby extension}

  if s.respond_to? :specification_version then
    current_version = Gem::Specification::CURRENT_SPECIFICATION_VERSION
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<arrayfields>, ["~> 4.7.4"])
      s.add_runtime_dependency(%q<fastercsv>, ["~> 1.5.4"])
      s.add_development_dependency(%q<rake>, ["~> 0.8.7"])
      s.add_development_dependency(%q<configuration>, ["~> 1.2.0"])
      s.add_development_dependency(%q<rspec>, ["~> 2.5.1"])
      s.add_development_dependency(%q<rake-compiler>, ["~> 0.7.6"])
      s.add_development_dependency(%q<zip>, ["~> 2.0.2"])
      s.add_development_dependency(%q<rcov>, ["~> 0.9.9"])
    else
      s.add_dependency(%q<arrayfields>, ["~> 4.7.4"])
      s.add_dependency(%q<fastercsv>, ["~> 1.5.4"])
      s.add_dependency(%q<rake>, ["~> 0.8.7"])
      s.add_dependency(%q<configuration>, ["~> 1.2.0"])
      s.add_dependency(%q<rspec>, ["~> 2.5.1"])
      s.add_dependency(%q<rake-compiler>, ["~> 0.7.6"])
      s.add_dependency(%q<zip>, ["~> 2.0.2"])
      s.add_dependency(%q<rcov>, ["~> 0.9.9"])
    end
  else
    s.add_dependency(%q<arrayfields>, ["~> 4.7.4"])
    s.add_dependency(%q<fastercsv>, ["~> 1.5.4"])
    s.add_dependency(%q<rake>, ["~> 0.8.7"])
    s.add_dependency(%q<configuration>, ["~> 1.2.0"])
    s.add_dependency(%q<rspec>, ["~> 2.5.1"])
    s.add_dependency(%q<rake-compiler>, ["~> 0.7.6"])
    s.add_dependency(%q<zip>, ["~> 2.0.2"])
    s.add_dependency(%q<rcov>, ["~> 0.9.9"])
  end
end
