#! /usr/bin/env python
"""Test dlmodule.c
   Roger E. Masse  revised strategy by Barry Warsaw
"""

import dl
from test.test_support import verbose,TestSkipped

import dircache

libcName = ''
for file in dircache.listdir('/usr/lib/'):
        if 'libc.so' in file:
                libcName = file
                break

if not libcName:
	raise TestSkipped

sharedlibs = [
    (libcName, 'getpid'),
    ]

for s, func in sharedlibs:
    try:
        if verbose:
            print 'trying to open:', s,
        l = dl.open(s)
    except dl.error, err:
        if verbose:
            print 'failed', repr(str(err))
        pass
    else:
        if verbose:
            print 'succeeded...',
        l.call(func)
        l.close()
        if verbose:
            print 'worked!'
        break
else:
    raise TestSkipped, 'Could not open any shared libraries'
