# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Benjamin Kampmann <benjamin@fluendo.com>

"""
Common models related to network services and shares.
"""

from elisa.core.components.model import Model

class NetworkServiceModel(Model):
    """
    A representation of a NetworkService inside elisa.

    @ivar uid:          if a network service is removed this is the thing you
                        should compare.
    @type uid:          C{unicode}
    @ivar name:         a generic name of the service (like 'SFTP on ...')
    @type name:         C{unicode}
    @ivar type:         the type of service (like 'sftp', or 'daap')
    @type type:         C{unicode}
    @ivar elisa_uri:    the uri to access this service from inside elisa
    @type elisa_uri     C{elisa.core.media_uri.MediaUri}
    """
    def __init__(self):
        super(NetworkServiceModel, self).__init__()
        self.uid = None
        self.name = None
        self.type = None
        self.elisa_uri = None
