// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_ELEMENTFACTORY_H
#define _GSTREAMERMM_ELEMENTFACTORY_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstelement.h>
#include <gstreamermm/pad.h>
#include <gstreamermm/pluginfeature.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstElementFactory GstElementFactory;
typedef struct _GstElementFactoryClass GstElementFactoryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class ElementFactory_Class; } // namespace Gst
namespace Gst
{

enum ElementFactoryListType
{
  ELEMENT_FACTORY_TYPE_ANY,
  ELEMENT_FACTORY_TYPE_AUDIOVIDEO_SINKS,
  ELEMENT_FACTORY_TYPE_AUDIO_ENCODER,
  ELEMENT_FACTORY_TYPE_DECODABLE,
  ELEMENT_FACTORY_TYPE_DECODER,
  ELEMENT_FACTORY_TYPE_DEMUXER,
  ELEMENT_FACTORY_TYPE_DEPAYLOADER,
  ELEMENT_FACTORY_TYPE_ENCODER,
  ELEMENT_FACTORY_TYPE_FORMATTER,
  ELEMENT_FACTORY_TYPE_MAX_ELEMENTS,
  ELEMENT_FACTORY_TYPE_MEDIA_AUDIO,
  ELEMENT_FACTORY_TYPE_MEDIA_IMAGE,
  ELEMENT_FACTORY_TYPE_MEDIA_METADATA,
  ELEMENT_FACTORY_TYPE_MEDIA_SUBTITLE,
  ELEMENT_FACTORY_TYPE_MEDIA_VIDEO,
  ELEMENT_FACTORY_TYPE_MEDIA_ANY,
  ELEMENT_FACTORY_TYPE_MUXER,
  ELEMENT_FACTORY_TYPE_PARSER,
  ELEMENT_FACTORY_TYPE_PAYLOADER,
  ELEMENT_FACTORY_TYPE_SINK,
  ELEMENT_FACTORY_TYPE_SRC,
  ELEMENT_FACTORY_TYPE_VIDEO_ENCODER
};

class Caps;
class Element;
class PadTemplate;
class Plugin;

/** A class that creates Gst::Element objects from a factory.
 * Gst::ElementFactory is used to create instances of elements. A
 * Gst::ElementFactory can be added to a Gst::Plugin as it is also a
 * Gst::PluginFeature. Use find() to get a particular element factory. Use
 * create_named_element() and the create_element() functions to create element
 * instances.
 *
 * The following code example shows you how to create a 'filesrc' element.
 *
 * @code
 *  #include <gstreamermm.h>
 *  #include <iostream>

 *  int main (int argc, char *argc[])
 *  {
 *    Glib::RefPtr<Gst::Element> src;
 *    Glib::RefPtr<Gst::ElementFactory> srcfactory;
 *
 *    Gst::init(&argc,&argv);
 *
 *    srcfactory = Gst::ElementFactory::find("filesrc");
 *
 *    if(!srcfactory)
 *    {
 *      std::cout << "Could not find factory 'filesrc'" << std::endl;
 *      exit(1);
 *    }
 *
 *    src = srcfactory->create_named_element("src");
 *
 *    if(!src)
 *    {
 *      std::cout << "Could not create element 'src'" << std::endl;
 *      exit(1);
 *    }
 *    ...
 *  }
 * @endcode
 *
 */

class ElementFactory : public PluginFeature
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ElementFactory CppObjectType;
  typedef ElementFactory_Class CppClassType;
  typedef GstElementFactory BaseObjectType;
  typedef GstElementFactoryClass BaseClassType;

private:  friend class ElementFactory_Class;
  static CppClassType elementfactory_class_;

private:
  // noncopyable
  ElementFactory(const ElementFactory&);
  ElementFactory& operator=(const ElementFactory&);

protected:
  explicit ElementFactory(const Glib::ConstructParams& construct_params);
  explicit ElementFactory(GstElementFactory* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ElementFactory();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstElementFactory*       gobj()       { return reinterpret_cast<GstElementFactory*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstElementFactory* gobj() const { return reinterpret_cast<GstElementFactory*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstElementFactory* gobj_copy();

private:


public:
  
  /** Search for an element factory of the given name. Refs the returned
   * element factory; caller is responsible for unreffing.
   * @param name Name of factory to find.
   * @return Gst::ElementFactory if found, <tt>0</tt> otherwise.
   */
  static Glib::RefPtr<Gst::ElementFactory> find(const Glib::ustring& name);

  //Note that name can't be null here, though it seems like gstreamer should allow that as for gst_element_factory_make().
  
  /** Create a new element of the type defined by the given elementfactory.
   * It will be given the name supplied, since all elements require a name as
   * their first argument.
   * @param name Name of new element.
   * @return New Gst::Element or <tt>0</tt> if the element couldn't
   * be created.
   */
  Glib::RefPtr<Gst::Element> create_named_element(const Glib::ustring& name);

  
  /** Create a new element of the type defined by the given element factory.
   * @param factoryname A named factory to instantiate.
   * @param name Name of new element.
   * @return New Gst::Element or <tt>0</tt> if unable to create element.
   */
  static Glib::RefPtr<Gst::Element> create_element(const Glib::ustring& factory_name, const Glib::ustring& name);
  
  /** Create a new element of the type defined by the given element factory, 
   * with a guaranteed unique name consisting of the element factory name and a
   * number.
   * @param factoryname A named factory to instantiate.
   * @param name Name of new element.
   * @return New Gst::Element or an empty RefPtr if unable to create element.
   */
  static Glib::RefPtr<Gst::Element> create_element(const Glib::ustring& factory_name);

  
  /** Checks if the factory can sink all possible capabilities.
   * @param caps The caps to check.
   * @return <tt>true</tt> if the caps are fully compatible.
   */
  bool can_sink_all_caps(const Glib::RefPtr<const Gst::Caps>& caps) const;
  
  /** Checks if the factory can src all possible capabilities.
   * @param caps The caps to check.
   * @return <tt>true</tt> if the caps are fully compatible.
   */
  bool can_src_all_caps(const Glib::RefPtr<const Gst::Caps>& caps) const;
  
  /** Checks if the factory can sink any possible capability.
   * @param caps The caps to check.
   * @return <tt>true</tt> if the caps have a common subset.
   */
  bool can_sink_any_caps(const Glib::RefPtr<const Gst::Caps>& caps) const;
  
  /** Checks if the factory can src any possible capability.
   * @param caps The caps to check.
   * @return <tt>true</tt> if the caps have a common subset.
   */
  bool can_src_any_caps(const Glib::RefPtr<const Gst::Caps>& caps) const;

  
  /** Get the Type for elements managed by this factory. The type can
   * only be retrieved if the element factory is loaded, which can be
   * assured with Gst::PluginFeature::load().
   * @return The Type for elements managed by this factory or 0 if
   * the factory is not loaded.
   */
  GType get_element_type() const;
  
  /** Gets the longname for this factory
   * @return The longname.
   */
  Glib::ustring get_long_name() const;
  
  /** Gets the class for this factory.
   * @return The class.
   */
  Glib::ustring get_kclass() const;
  
  /** Gets the description for this factory.
   * @return The description.
   */
  Glib::ustring get_description() const;
  
  /** Gets the author for this factory.
   * @return The author.
   */
  Glib::ustring get_author() const;
  
  /** Gets documentation uri for this factory if set.
   * @return The documentation uri.
   */
  Glib::ustring get_documentation_uri() const;
  
  /** Gets icon name for this factory if set.
   * @return The icon name.
   */
  Glib::ustring get_icon_name() const;
  
  /** Gets the number of pad_templates in this factory.
   * @return The number of pad_templates.
   */
  guint get_num_pad_templates() const;
  
  /** Gets the type of URIs the element supports or Gst::URI_UNKNOWN if none.
   * @return Type of URIs this element supports.
   */
  int get_uri_type() const;

 
  /** Gets a <tt>0</tt>-terminated array of protocols this element supports or <tt>0</tt> if
   * no protocols are supported. You may not change the contents of the returned
   * array, as it is still owned by the element factory. Use Glib::strdupv() to
   * make a copy of the protocol string array if you need to.
   * @return The supported protocols
   * or <tt>0</tt>.
   */
  Glib::StringArrayHandle get_uri_protocols() const;

  
  /** Check if @a factory implements the interface with name @a interfacename.
   * @param interfacename An interface name.
   * @return #<tt>true</tt> when @a factory implement the interface.
   */
  bool has_interface(const Glib::ustring& name) const;
  
  /** Checks if the factory can sink the given capability.
   * 
   * Deprecated: use can_sink_all_caps() instead.
   * @param caps The caps to check.
   * @return <tt>true</tt> if it can sink the capabilities.
   */
  bool can_sink_caps(const Glib::RefPtr<const Gst::Caps>& caps) const;
  
  /** Checks if the factory can source the given capability.
   * 
   * Deprecated: use can_src_all_caps() instead.
   * @param caps The caps to check.
   * @return <tt>true</tt> if it can src the capabilities.
   */
  bool can_src_caps(const Glib::RefPtr<const Gst::Caps>& caps) const;

 
  /** Gets the List of Gst::StaticPadTemplate for this factory.
   * @return The
   * static pad templates.
   */
  Glib::ListHandle< Glib::RefPtr<Gst::PadTemplate> > get_static_pad_templates();

 
  /** Gets the List of Gst::StaticPadTemplate for this factory.
   * @return The
   * static pad templates.
   */
  Glib::ListHandle< Glib::RefPtr<const Gst::PadTemplate> > get_static_pad_templates() const;

 
  /** Filter out all the elementfactories in @a list that can handle @a caps in
   * the given direction.
   * 
   * If @a subsetonly is <tt>true</tt>, then only the elements whose pads templates
   * are a complete superset of @a caps will be returned. Else any element
   * whose pad templates caps can intersect with @a caps will be returned.
   * @param list A List of
   * Gst::ElementFactory to filter.
   * @param caps A Gst::Caps.
   * @param direction A Gst::PadDirection to filter on.
   * @param subsetonly Whether to filter on caps subsets or not.
   * @return A List of
   * Gst::ElementFactory elements that match the given requisits.
   * Use #gst_plugin_feature_list_free after usage.
   */
  static std::vector< Glib::RefPtr<Gst::ElementFactory> > filter(const std::vector< Glib::RefPtr<Gst::ElementFactory> >& list, const Glib::RefPtr<const Gst::Caps>& caps, PadDirection direction, bool subsetonly);

 
  /** Get a list of factories that match the given @a type. Only elements
   * with a rank greater or equal to @a minrank will be returned.
   * The list of factories is returned by decreasing rank.
   * @param type A Gst::ElementFactoryListType.
   * @param minrank Minimum rank.
   * @return A List of
   * Gst::ElementFactory elements. Use Gst::PluginFeature::list_free() after
   * usage.
   */
  static std::vector< Glib::RefPtr<Gst::ElementFactory> > get_elements(ElementFactoryListType type, Rank minrank);
  
  /** Check if @a factory if of the given types.
   * @param type A Gst::ElementFactoryListType.
   * @return <tt>true</tt> if @a factory is of @a type.
   */
  bool is_type(ElementFactoryListType type) const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::ElementFactory
   */
  Glib::RefPtr<Gst::ElementFactory> wrap(GstElementFactory* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_ELEMENTFACTORY_H */

