/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class BasicComboBoxUI
extends ComboBoxUI {
    protected JButton arrowButton;
    protected JComboBox comboBox;
    protected Component editor;
    protected FocusListener focusListener;
    protected boolean hasFocus;
    protected ItemListener itemListener;
    protected KeyListener keyListener;
    protected JList listBox;
    protected ListDataListener listDataListener;
    protected ComboPopup popup;
    protected KeyListener popupKeyListener;
    protected MouseListener popupMouseListener;
    protected MouseMotionListener popupMouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    Dimension displaySize;
    protected CellRendererPane currentValuePane;
    protected Dimension cachedMinimumSize;
    protected boolean isMinimumSizeDirty;
    private static final ListCellRenderer DEFAULT_RENDERER = new DefaultListCellRenderer();

    private /* synthetic */ void finit$() {
        this.displaySize = new Dimension();
        this.isMinimumSizeDirty = true;
    }

    public BasicComboBoxUI() {
        this.finit$();
        this.currentValuePane = new CellRendererPane();
        this.cachedMinimumSize = new Dimension();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JComboBox) {
            ComboBoxEditor comboBoxEditor;
            this.isMinimumSizeDirty = true;
            this.comboBox = (JComboBox)jComponent;
            this.installDefaults();
            ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
            if (listCellRenderer == null || listCellRenderer instanceof UIResource) {
                this.comboBox.setRenderer(this.createRenderer());
            }
            if ((comboBoxEditor = this.comboBox.getEditor()) == null || comboBoxEditor instanceof UIResource) {
                comboBoxEditor = this.createEditor();
                this.comboBox.setEditor(comboBoxEditor);
            }
            this.editor = comboBoxEditor.getEditorComponent();
            this.installComponents();
            this.installListeners();
            if (this.arrowButton != null) {
                this.configureArrowButton();
            }
            if (this.editor != null) {
                this.configureEditor();
            }
            this.comboBox.setLayout(this.createLayoutManager());
            this.comboBox.setFocusable(true);
            this.installKeyboardActions();
            this.comboBox.putClientProperty("noCancelPopup", Boolean.TRUE);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.setPopupVisible(this.comboBox, false);
        this.popup.uninstallingUI();
        this.uninstallKeyboardActions();
        this.comboBox.setLayout(null);
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.comboBox = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        LookAndFeel.installBorder(this.comboBox, "ComboBox.border");
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        this.focusListener = this.createFocusListener();
        this.comboBox.addFocusListener(this.focusListener);
        this.itemListener = this.createItemListener();
        this.comboBox.addItemListener(this.itemListener);
        this.keyListener = this.createKeyListener();
        this.comboBox.addKeyListener(this.keyListener);
        this.listDataListener = this.createListDataListener();
        this.comboBox.getModel().addListDataListener(this.listDataListener);
        this.popupMouseListener = this.popup.getMouseListener();
        this.comboBox.addMouseListener(this.popupMouseListener);
        this.popupMouseMotionListener = this.popup.getMouseMotionListener();
        this.comboBox.addMouseMotionListener(this.popupMouseMotionListener);
        this.popupKeyListener = this.popup.getKeyListener();
        this.comboBox.addKeyListener(this.popupKeyListener);
    }

    protected void uninstallDefaults() {
        if (this.comboBox.getFont() instanceof UIResource) {
            this.comboBox.setFont(null);
        }
        if (this.comboBox.getForeground() instanceof UIResource) {
            this.comboBox.setForeground(null);
        }
        if (this.comboBox.getBackground() instanceof UIResource) {
            this.comboBox.setBackground(null);
        }
        LookAndFeel.uninstallBorder(this.comboBox);
    }

    protected void uninstallListeners() {
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.comboBox.removeFocusListener(this.focusListener);
        this.listBox.removeFocusListener(this.focusListener);
        this.focusListener = null;
        this.comboBox.removeItemListener(this.itemListener);
        this.itemListener = null;
        this.comboBox.removeKeyListener(this.keyListener);
        this.keyListener = null;
        this.comboBox.getModel().removeListDataListener(this.listDataListener);
        this.listDataListener = null;
        if (this.popupMouseListener != null) {
            this.comboBox.removeMouseListener(this.popupMouseListener);
        }
        this.popupMouseListener = null;
        if (this.popupMouseMotionListener != null) {
            this.comboBox.removeMouseMotionListener(this.popupMouseMotionListener);
        }
        this.popupMouseMotionListener = null;
        if (this.popupKeyListener != null) {
            this.comboBox.removeKeyListener(this.popupKeyListener);
        }
        this.popupKeyListener = null;
    }

    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox);
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler(this);
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler(this);
    }

    protected ItemListener createItemListener() {
        return new ItemHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager(this);
    }

    protected ListCellRenderer createRenderer() {
        return new BasicComboBoxRenderer.UIResource();
    }

    protected ComboBoxEditor createEditor() {
        return new BasicComboBoxEditor.UIResource();
    }

    protected void installComponents() {
        this.popup = this.createPopup();
        this.listBox = this.popup.getList();
        this.arrowButton = this.createArrowButton();
        this.comboBox.add(this.arrowButton);
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    protected void uninstallComponents() {
        ComboBoxEditor comboBoxEditor;
        this.unconfigureArrowButton();
        this.comboBox.remove(this.arrowButton);
        this.arrowButton = null;
        this.popup = null;
        if (this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(null);
        }
        if ((comboBoxEditor = this.comboBox.getEditor()) instanceof UIResource) {
            this.comboBox.setEditor(null);
            this.editor = null;
        }
    }

    public void addEditor() {
        this.removeEditor();
        this.editor = this.comboBox.getEditor().getEditorComponent();
        this.comboBox.add(this.editor);
    }

    public void removeEditor() {
        if (this.editor != null) {
            this.unconfigureEditor();
            this.comboBox.remove(this.editor);
        }
    }

    protected void configureEditor() {
        this.editor.setFont(this.comboBox.getFont());
        if (this.popupKeyListener != null) {
            this.editor.addKeyListener(this.popupKeyListener);
        }
        if (this.keyListener != null) {
            this.editor.addKeyListener(this.keyListener);
        }
        this.comboBox.configureEditor(this.comboBox.getEditor(), this.comboBox.getSelectedItem());
    }

    protected void unconfigureEditor() {
        if (this.popupKeyListener != null) {
            this.editor.removeKeyListener(this.popupKeyListener);
        }
        if (this.keyListener != null) {
            this.editor.removeKeyListener(this.keyListener);
        }
    }

    public void configureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.setEnabled(this.comboBox.isEnabled());
            this.arrowButton.setFocusable(false);
            if (this.popupMouseListener != null) {
                this.arrowButton.addMouseListener(this.popupMouseListener);
            }
            if (this.popupMouseMotionListener != null) {
                this.arrowButton.addMouseMotionListener(this.popupMouseMotionListener);
            }
            this.arrowButton.putClientProperty("noCancelPopup", Boolean.TRUE);
        }
    }

    public void unconfigureArrowButton() {
        if (this.arrowButton != null) {
            if (this.popupMouseListener != null) {
                this.arrowButton.removeMouseListener(this.popupMouseListener);
            }
            if (this.popupMouseMotionListener != null) {
                this.arrowButton.removeMouseMotionListener(this.popupMouseMotionListener);
            }
        }
    }

    protected JButton createArrowButton() {
        return new BasicArrowButton(5);
    }

    public boolean isPopupVisible(JComboBox jComboBox) {
        return this.popup.isVisible();
    }

    public void setPopupVisible(JComboBox jComboBox, boolean bl) {
        if (bl) {
            this.popup.show();
        } else {
            this.popup.hide();
        }
    }

    public boolean isFocusTraversable(JComboBox jComboBox) {
        return !this.comboBox.isEditable();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(graphics, rectangle, this.hasFocus);
            this.paintCurrentValue(graphics, rectangle, this.hasFocus);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.isMinimumSizeDirty) {
            Insets insets = this.getInsets();
            Dimension dimension = this.getDisplaySize();
            dimension.width += insets.left + insets.right + dimension.height;
            this.cachedMinimumSize = new Dimension(dimension.width, dimension.height + insets.top + insets.bottom);
            this.isMinimumSizeDirty = false;
        }
        return new Dimension(this.cachedMinimumSize);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public int getAccessibleChildrenCount(JComponent jComponent) {
        int n = 1;
        if (this.comboBox.isEditable()) {
            n = 2;
        }
        return n;
    }

    public Accessible getAccessibleChild(JComponent jComponent, int n) {
        Accessible accessible = null;
        switch (n) {
            case 0: {
                if (!(this.popup instanceof Accessible)) break;
                AccessibleContext accessibleContext = ((Accessible)((Object)this.popup)).getAccessibleContext();
                accessibleContext.setAccessibleParent(this.comboBox);
                accessible = (Accessible)((Object)this.popup);
                break;
            }
            case 1: {
                if (!this.comboBox.isEditable() || !(this.editor instanceof Accessible)) break;
                AccessibleContext accessibleContext = ((Accessible)((Object)this.editor)).getAccessibleContext();
                accessibleContext.setAccessibleParent(this.comboBox);
                accessible = (Accessible)((Object)this.editor);
            }
        }
        return accessible;
    }

    protected boolean isNavigationKey(int n) {
        return n == 38 || n == 40 || n == 37 || n == 39 || n == 10 || n == 27 || n == 9;
    }

    protected void selectNextPossibleValue() {
        int n = this.comboBox.getSelectedIndex();
        if (n != this.comboBox.getItemCount() - 1) {
            this.comboBox.setSelectedIndex(n + 1);
        }
    }

    protected void selectPreviousPossibleValue() {
        int n = this.comboBox.getSelectedIndex();
        if (n > 0) {
            this.comboBox.setSelectedIndex(n - 1);
        }
    }

    protected void toggleOpenClose() {
        this.setPopupVisible(this.comboBox, this.isPopupVisible(this.comboBox) ^ true);
    }

    protected Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.comboBox.getInsets();
        int n3 = n2 - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            n3 = this.arrowButton.getWidth();
        }
        return new Rectangle(insets.left, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.left));
    }

    protected Insets getInsets() {
        return this.comboBox.getInsets();
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        Object object = this.comboBox.getSelectedItem();
        boolean bl2 = this.arrowButton.getModel().isPressed();
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        if (this.comboBox.getSelectedIndex() != -1) {
            Color color;
            Component component;
            if (bl && !this.isPopupVisible(this.comboBox)) {
                component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
            } else {
                component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
                color = UIManager.getColor("ComboBox.disabledForeground");
                component.setBackground(color);
            }
            component.setFont(this.comboBox.getFont());
            if (bl && !this.isPopupVisible(this.comboBox)) {
                component.setForeground(this.listBox.getSelectionForeground());
                component.setBackground(this.listBox.getSelectionBackground());
            } else if (this.comboBox.isEnabled()) {
                component.setForeground(this.comboBox.getForeground());
                component.setBackground(this.comboBox.getBackground());
            } else {
                color = UIManager.getColor("ComboBox.disabledForeground");
                component.setForeground(color);
                Color color2 = UIManager.getColor("ComboBox.disabledBackground");
                component.setBackground(color2);
            }
            this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
        Color color = graphics.getColor();
        if (this.comboBox.isEnabled()) {
            graphics.setColor(UIManager.getColor("UIManager.background"));
        } else {
            graphics.setColor(UIManager.getColor("UIManager.disabledBackground"));
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
    }

    protected Dimension getDefaultSize() {
        Component component = DEFAULT_RENDERER.getListCellRendererComponent(this.listBox, " ", -1, false, false);
        this.currentValuePane.add(component);
        component.setFont(this.comboBox.getFont());
        Dimension dimension = component.getPreferredSize();
        this.currentValuePane.remove(component);
        return dimension;
    }

    protected Dimension getDisplaySize() {
        Object object;
        Object object2;
        Dimension dimension = new Dimension();
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        if (listCellRenderer == null) {
            listCellRenderer = DEFAULT_RENDERER;
        }
        if ((object2 = this.comboBox.getPrototypeDisplayValue()) != null) {
            object = listCellRenderer.getListCellRendererComponent(this.listBox, object2, -1, false, false);
            this.currentValuePane.add((Component)object);
            ((Component)object).setFont(this.comboBox.getFont());
            Dimension dimension2 = ((Component)object).getPreferredSize();
            this.currentValuePane.remove((Component)object);
            dimension.height = dimension2.height;
            dimension.width = dimension2.width;
        } else {
            object = this.comboBox.getModel();
            int n = object.getSize();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    Component component = listCellRenderer.getListCellRendererComponent(this.listBox, object.getElementAt(i), -1, false, false);
                    this.currentValuePane.add(component);
                    component.setFont(this.comboBox.getFont());
                    Dimension dimension3 = component.getPreferredSize();
                    this.currentValuePane.remove(component);
                    dimension.width = Math.max(dimension.width, dimension3.width);
                    dimension.height = Math.max(dimension.height, dimension3.height);
                }
            } else {
                dimension = this.getDefaultSize();
                if (this.comboBox.isEditable()) {
                    dimension.width = 100;
                }
            }
        }
        if (this.comboBox.isEditable()) {
            object = this.editor.getPreferredSize();
            dimension.width = Math.max(dimension.width, ((Dimension)object).width);
            dimension.height = Math.max(dimension.height, ((Dimension)object).height);
        }
        this.displaySize.setSize(dimension.width, dimension.height);
        return dimension;
    }

    protected void installKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, (InputMap)UIManager.get("ComboBox.ancestorInputMap"));
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, null);
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicComboBoxUI this$0;

        public PropertyChangeHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.this$0.isMinimumSizeDirty = true;
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                this.this$0.arrowButton.setEnabled(this.this$0.comboBox.isEnabled());
                if (this.this$0.comboBox.isEditable()) {
                    this.this$0.comboBox.getEditor().getEditorComponent().setEnabled(this.this$0.comboBox.isEnabled());
                }
            } else if (propertyChangeEvent.getPropertyName().equals("editable")) {
                if (this.this$0.comboBox.isEditable()) {
                    this.this$0.configureEditor();
                    this.this$0.addEditor();
                } else {
                    this.this$0.unconfigureEditor();
                    this.this$0.removeEditor();
                }
                this.this$0.comboBox.revalidate();
                this.this$0.comboBox.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("dataModel")) {
                ComboBoxModel comboBoxModel = (ComboBoxModel)propertyChangeEvent.getOldValue();
                if (comboBoxModel != null) {
                    comboBoxModel.removeListDataListener(this.this$0.listDataListener);
                }
                if ((ComboBoxModel)propertyChangeEvent.getNewValue() != null) {
                    this.this$0.comboBox.getModel().addListDataListener(this.this$0.listDataListener);
                }
            } else if (propertyChangeEvent.getPropertyName().equals("font")) {
                Font font = (Font)propertyChangeEvent.getNewValue();
                this.this$0.editor.setFont(font);
                this.this$0.listBox.setFont(font);
                this.this$0.arrowButton.setFont(font);
                this.this$0.comboBox.revalidate();
                this.this$0.comboBox.repaint();
            }
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        private /* synthetic */ BasicComboBoxUI this$0;

        public ListDataHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            if (listDataEvent.getIndex0() != -1 || listDataEvent.getIndex1() != -1) {
                this.this$0.isMinimumSizeDirty = true;
                this.this$0.comboBox.revalidate();
            }
            if (this.this$0.editor != null) {
                this.this$0.comboBox.configureEditor(this.this$0.comboBox.getEditor(), this.this$0.comboBox.getSelectedItem());
            }
            this.this$0.comboBox.repaint();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            if (n == 0 && this.this$0.comboBox.getItemCount() - (n2 - n + 1) == 0) {
                this.contentsChanged(listDataEvent);
            } else if (n != -1 || n2 != -1) {
                ListCellRenderer listCellRenderer = this.this$0.comboBox.getRenderer();
                ComboBoxModel comboBoxModel = this.this$0.comboBox.getModel();
                int n3 = this.this$0.displaySize.width;
                int n4 = this.this$0.displaySize.height;
                for (int i = n; i <= n2; ++i) {
                    Component component = listCellRenderer.getListCellRendererComponent(this.this$0.listBox, comboBoxModel.getElementAt(i), -1, false, false);
                    this.this$0.currentValuePane.add(component);
                    component.setFont(this.this$0.comboBox.getFont());
                    Dimension dimension = component.getPreferredSize();
                    n3 = Math.max(n3, dimension.width);
                    n4 = Math.max(n4, dimension.height);
                    this.this$0.currentValuePane.remove(component);
                }
                if (this.this$0.displaySize.width < n3 || this.this$0.displaySize.height < n4) {
                    if (this.this$0.displaySize.width < n3) {
                        this.this$0.displaySize.width = n3;
                    }
                    if (this.this$0.displaySize.height < n4) {
                        this.this$0.displaySize.height = n4;
                    }
                    this.this$0.comboBox.revalidate();
                    if (this.this$0.editor != null) {
                        this.this$0.comboBox.configureEditor(this.this$0.comboBox.getEditor(), this.this$0.comboBox.getSelectedItem());
                    }
                }
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        private /* synthetic */ BasicComboBoxUI this$0;

        public KeyHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (this.this$0.comboBox.getModel().getSize() != 0 && this.this$0.comboBox.isEnabled()) {
                if (!this.this$0.isNavigationKey(keyEvent.getKeyCode())) {
                    if (!this.this$0.comboBox.isEditable() && this.this$0.comboBox.selectWithKeyChar(keyEvent.getKeyChar())) {
                        keyEvent.consume();
                    }
                } else if (keyEvent.getKeyCode() == 38 && this.this$0.comboBox.isPopupVisible()) {
                    this.this$0.selectPreviousPossibleValue();
                } else if (keyEvent.getKeyCode() == 40) {
                    if (this.this$0.comboBox.isPopupVisible()) {
                        this.this$0.selectNextPossibleValue();
                    } else {
                        this.this$0.comboBox.showPopup();
                    }
                } else if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 27) {
                    this.this$0.popup.hide();
                }
            }
        }
    }

    public class ItemHandler
    implements ItemListener {
        private /* synthetic */ BasicComboBoxUI this$0;

        public ItemHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ComboBoxModel comboBoxModel = this.this$0.comboBox.getModel();
            Object object = comboBoxModel.getSelectedItem();
            if (this.this$0.editor != null) {
                this.this$0.comboBox.configureEditor(this.this$0.comboBox.getEditor(), object);
            }
            this.this$0.comboBox.repaint();
        }
    }

    public class FocusHandler
    implements FocusListener {
        private /* synthetic */ BasicComboBoxUI this$0;

        public FocusHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.this$0.hasFocus = true;
            this.this$0.comboBox.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.this$0.hasFocus = false;
            if (!focusEvent.isTemporary() && this.this$0.comboBox.isLightWeightPopupEnabled()) {
                this.this$0.setPopupVisible(this.this$0.comboBox, false);
            }
            this.this$0.comboBox.repaint();
        }
    }

    public class ComboBoxLayoutManager
    implements LayoutManager {
        private /* synthetic */ BasicComboBoxUI this$0;

        public ComboBoxLayoutManager(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return container.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return container.getMinimumSize();
        }

        public void layoutContainer(Container container) {
            Insets insets = this.this$0.getInsets();
            int n = this.this$0.comboBox.getHeight() - (insets.top + insets.bottom);
            int n2 = this.this$0.comboBox.getBounds().width - n;
            if (this.this$0.arrowButton != null) {
                this.this$0.arrowButton.setBounds(this.this$0.comboBox.getWidth() - (insets.right + n), insets.top, n, n);
            }
            if (this.this$0.editor != null) {
                this.this$0.editor.setBounds(this.this$0.rectangleForCurrentValue());
            }
        }
    }
}

