/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class Vector
extends AbstractList
implements List,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2767605614048989439L;
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public Vector() {
        this(10, 0);
    }

    public Vector(Collection collection) {
        this.elementCount = collection.size();
        this.elementData = collection.toArray(new Object[this.elementCount]);
    }

    public Vector(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public Vector(int n) {
        this(n, 0);
    }

    public synchronized void copyInto(Object[] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
    }

    public synchronized void trimToSize() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        this.elementData = objectArray;
    }

    public synchronized void ensureCapacity(int n) {
        if (this.elementData.length >= n) {
            return;
        }
        int n2 = this.capacityIncrement <= 0 ? this.elementData.length * 2 : this.elementData.length + this.capacityIncrement;
        Object[] objectArray = new Object[Math.max(n2, n)];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        this.elementData = objectArray;
    }

    public synchronized void setSize(int n) {
        ++this.modCount;
        this.ensureCapacity(n);
        if (n < this.elementCount) {
            Arrays.fill(this.elementData, n, this.elementCount, null);
        }
        this.elementCount = n;
    }

    public synchronized int capacity() {
        return this.elementData.length;
    }

    public synchronized int size() {
        return this.elementCount;
    }

    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Enumeration elements() {
        return new Enumeration(this){
            private /* synthetic */ Vector this$0;
            private int i;
            {
                this.this$0 = vector;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.i = 0;
            }

            public boolean hasMoreElements() {
                return this.i < this.this$0.elementCount;
            }

            public Object nextElement() {
                if (this.i >= this.this$0.elementCount) {
                    throw new NoSuchElementException();
                }
                return this.this$0.elementData[this.i++];
            }
        };
    }

    public boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public synchronized int indexOf(Object object, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (!AbstractCollection.equals(object, this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public synchronized int lastIndexOf(Object object, int n) {
        this.checkBoundExclusive(n);
        for (int i = n; i >= 0; --i) {
            if (!AbstractCollection.equals(object, this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public synchronized Object elementAt(int n) {
        this.checkBoundExclusive(n);
        return this.elementData[n];
    }

    public synchronized Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public void setElementAt(Object object, int n) {
        this.set(n, object);
    }

    public void removeElementAt(int n) {
        this.remove(n);
    }

    public synchronized void insertElementAt(Object object, int n) {
        this.checkBoundInclusive(n);
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        ++this.modCount;
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        ++this.elementCount;
        this.elementData[n] = object;
    }

    public synchronized void addElement(Object object) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        ++this.modCount;
        this.elementData[this.elementCount++] = object;
    }

    public synchronized boolean removeElement(Object object) {
        int n = this.indexOf(object, 0);
        if (n >= 0) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public synchronized void removeAllElements() {
        if (this.elementCount == 0) {
            return;
        }
        ++this.modCount;
        Arrays.fill(this.elementData, 0, this.elementCount, null);
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            Vector vector = (Vector)super.clone();
            vector.elementData = (Object[])this.elementData.clone();
            return vector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public synchronized Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        this.copyInto(objectArray);
        return objectArray;
    }

    public synchronized Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.elementCount) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.elementCount);
        } else if (objectArray.length > this.elementCount) {
            objectArray[this.elementCount] = null;
        }
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public Object get(int n) {
        return this.elementAt(n);
    }

    public synchronized Object set(int n, Object object) {
        this.checkBoundExclusive(n);
        Object object2 = this.elementData[n];
        this.elementData[n] = object;
        return object2;
    }

    public boolean add(Object object) {
        this.addElement(object);
        return true;
    }

    public boolean remove(Object object) {
        return this.removeElement(object);
    }

    public void add(int n, Object object) {
        this.insertElementAt(object, n);
    }

    public synchronized Object remove(int n) {
        this.checkBoundExclusive(n);
        Object object = this.elementData[n];
        ++this.modCount;
        --this.elementCount;
        if (n < this.elementCount) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, this.elementCount - n);
        }
        this.elementData[this.elementCount] = null;
        return object;
    }

    public void clear() {
        this.removeAllElements();
    }

    public synchronized boolean containsAll(Collection collection) {
        return super.containsAll(collection);
    }

    public synchronized boolean addAll(Collection collection) {
        return this.addAll(this.elementCount, collection);
    }

    public synchronized boolean removeAll(Collection collection) {
        int n;
        if (collection == null) {
            throw new NullPointerException();
        }
        for (n = 0; n < this.elementCount && !collection.contains(this.elementData[n]); ++n) {
        }
        if (n == this.elementCount) {
            return false;
        }
        ++this.modCount;
        int n2 = n++;
        while (n < this.elementCount) {
            if (!collection.contains(this.elementData[n])) {
                this.elementData[n2++] = this.elementData[n];
            }
            ++n;
        }
        this.elementCount -= n - n2;
        return true;
    }

    public synchronized boolean retainAll(Collection collection) {
        int n;
        if (collection == null) {
            throw new NullPointerException();
        }
        for (n = 0; n < this.elementCount && collection.contains(this.elementData[n]); ++n) {
        }
        if (n == this.elementCount) {
            return false;
        }
        ++this.modCount;
        int n2 = n++;
        while (n < this.elementCount) {
            if (collection.contains(this.elementData[n])) {
                this.elementData[n2++] = this.elementData[n];
            }
            ++n;
        }
        this.elementCount -= n - n2;
        return true;
    }

    public synchronized boolean addAll(int n, Collection collection) {
        this.checkBoundInclusive(n);
        Iterator iterator = collection.iterator();
        int n2 = collection.size();
        ++this.modCount;
        this.ensureCapacity(this.elementCount + n2);
        int n3 = n + n2;
        if (this.elementCount > 0 && n != this.elementCount) {
            System.arraycopy(this.elementData, n, this.elementData, n3, this.elementCount - n);
        }
        this.elementCount += n2;
        while (n < n3) {
            this.elementData[n] = iterator.next();
            ++n;
        }
        return n2 > 0;
    }

    public synchronized boolean equals(Object object) {
        return super.equals(object);
    }

    public synchronized int hashCode() {
        return super.hashCode();
    }

    public synchronized String toString() {
        return super.toString();
    }

    public synchronized List subList(int n, int n2) {
        List list2 = super.subList(n, n2);
        return new Collections.SynchronizedList((Object)this, list2);
    }

    protected void removeRange(int n, int n2) {
        int n3 = n2 - n;
        if (n3 > 0) {
            ++this.modCount;
            System.arraycopy(this.elementData, n2, this.elementData, n, this.elementCount - n2);
            int n4 = this.elementCount;
            this.elementCount -= n3;
            Arrays.fill(this.elementData, this.elementCount, n4, null);
        } else if (n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkBoundInclusive(int n) {
        if (n > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
    }

    private void checkBoundExclusive(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

