/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.kwa;

import gnu.javax.crypto.cipher.Rijndael;
import gnu.javax.crypto.kwa.BaseKeyWrappingAlgorithm;
import gnu.javax.crypto.kwa.KeyUnwrappingException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class AESKeyWrap
extends BaseKeyWrappingAlgorithm {
    private static final byte[] DEFAULT_IV = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
    private Rijndael aes = new Rijndael();
    private byte[] iv;

    public AESKeyWrap() {
        super("kw-aes");
    }

    protected void engineInit(Map map) throws InvalidKeyException {
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.cipher.block.size", 16);
        hashMap.put("gnu.crypto.cipher.key.material", map.get("gnu.crypto.kwa.kek"));
        this.aes.reset();
        this.aes.init(hashMap);
        byte[] byArray = (byte[])map.get("gnu.crypto.kwa.iv");
        this.iv = byArray == null ? DEFAULT_IV : (byte[])byArray.clone();
    }

    protected byte[] engineWrap(byte[] byArray, int n, int n2) {
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("Input length MUST be a multiple of 8");
        }
        int n3 = n2 / 8;
        byte[] byArray2 = new byte[n2 + 8];
        System.arraycopy(this.iv, 0, byArray2, 0, 8);
        System.arraycopy(byArray, n, byArray2, 8, n2);
        byte[] byArray3 = new byte[16];
        for (int i = 0; i < 6; ++i) {
            for (int j = 1; j <= n3; ++j) {
                System.arraycopy(byArray2, 0, byArray3, 0, 8);
                System.arraycopy(byArray2, j * 8, byArray3, 8, 8);
                this.aes.encryptBlock(byArray3, 0, byArray3, 0);
                long l = n3 * i + j;
                byArray2[0] = byArray3[0] ^ (byte)(l >>> 56);
                byArray2[1] = byArray3[1] ^ (byte)(l >>> 48);
                byArray2[2] = byArray3[2] ^ (byte)(l >>> 40);
                byArray2[3] = byArray3[3] ^ (byte)(l >>> 32);
                byArray2[4] = byArray3[4] ^ (byte)(l >>> 24);
                byArray2[5] = byArray3[5] ^ (byte)(l >>> 16);
                byArray2[6] = byArray3[6] ^ (byte)(l >>> 8);
                byArray2[7] = byArray3[7] ^ (byte)l;
                System.arraycopy(byArray3, 8, byArray2, j * 8, 8);
            }
        }
        return byArray2;
    }

    protected byte[] engineUnwrap(byte[] byArray, int n, int n2) throws KeyUnwrappingException {
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("Input length MUST be a multiple of 8");
        }
        byte[] byArray2 = new byte[n2 - 8];
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray, n, byArray3, 0, 8);
        System.arraycopy(byArray, n + 8, byArray2, 0, byArray2.length);
        byte[] byArray4 = new byte[16];
        int n3 = n2 / 8 - 1;
        for (int i = 5; i >= 0; --i) {
            for (int j = n3; j >= 1; --j) {
                long l = n3 * i + j;
                byArray4[0] = byArray3[0] ^ (byte)(l >>> 56);
                byArray4[1] = byArray3[1] ^ (byte)(l >>> 48);
                byArray4[2] = byArray3[2] ^ (byte)(l >>> 40);
                byArray4[3] = byArray3[3] ^ (byte)(l >>> 32);
                byArray4[4] = byArray3[4] ^ (byte)(l >>> 24);
                byArray4[5] = byArray3[5] ^ (byte)(l >>> 16);
                byArray4[6] = byArray3[6] ^ (byte)(l >>> 8);
                byArray4[7] = byArray3[7] ^ (byte)l;
                System.arraycopy(byArray2, (j - 1) * 8, byArray4, 8, 8);
                this.aes.decryptBlock(byArray4, 0, byArray4, 0);
                System.arraycopy(byArray4, 0, byArray3, 0, 8);
                System.arraycopy(byArray4, 8, byArray2, (j - 1) * 8, 8);
            }
        }
        if (!Arrays.equals(byArray3, this.iv)) {
            throw new KeyUnwrappingException();
        }
        return byArray2;
    }
}

