/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.hash;

import gnu.java.security.hash.BaseHash;
import gnu.java.security.util.Util;

public class Sha512
extends BaseHash {
    private static final long[] k = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
    private static final int BLOCK_SIZE = 128;
    private static final String DIGEST0 = "DDAF35A193617ABACC417349AE20413112E6FA4E89A97EA20A9EEEE64B55D39A2192992A274FC1A836BA3C23A3FEEBBD454D4423643CE80E2A9AC94FA54CA49F";
    private static final long[] w;
    private static Boolean valid;
    private long h0;
    private long h1;
    private long h2;
    private long h3;
    private long h4;
    private long h5;
    private long h6;
    private long h7;

    public Sha512() {
        super("sha-512", 64, 128);
    }

    private Sha512(Sha512 sha512) {
        this();
        this.h0 = sha512.h0;
        this.h1 = sha512.h1;
        this.h2 = sha512.h2;
        this.h3 = sha512.h3;
        this.h4 = sha512.h4;
        this.h5 = sha512.h5;
        this.h6 = sha512.h6;
        this.h7 = sha512.h7;
        this.count = sha512.count;
        this.buffer = (byte[])sha512.buffer.clone();
    }

    public static final long[] G(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, byte[] byArray, int n) {
        return Sha512.sha(l, l2, l3, l4, l5, l6, l7, l8, byArray, n);
    }

    public Object clone() {
        return new Sha512(this);
    }

    protected void transform(byte[] byArray, int n) {
        long[] lArray = Sha512.sha(this.h0, this.h1, this.h2, this.h3, this.h4, this.h5, this.h6, this.h7, byArray, n);
        this.h0 = lArray[0];
        this.h1 = lArray[1];
        this.h2 = lArray[2];
        this.h3 = lArray[3];
        this.h4 = lArray[4];
        this.h5 = lArray[5];
        this.h6 = lArray[6];
        this.h7 = lArray[7];
    }

    protected byte[] padBuffer() {
        int n = (int)(this.count % (long)128);
        int n2 = n < 112 ? 112 - n : 240 - n;
        byte[] byArray = new byte[n2 + 16];
        byArray[0] = -128;
        long l = this.count << 3;
        n2 += 8;
        byArray[n2++] = (byte)(l >>> 56);
        byArray[n2++] = (byte)(l >>> 48);
        byArray[n2++] = (byte)(l >>> 40);
        byArray[n2++] = (byte)(l >>> 32);
        byArray[n2++] = (byte)(l >>> 24);
        byArray[n2++] = (byte)(l >>> 16);
        byArray[n2++] = (byte)(l >>> 8);
        byArray[n2] = (byte)l;
        return byArray;
    }

    protected byte[] getResult() {
        return new byte[]{(byte)(this.h0 >>> 56), (byte)(this.h0 >>> 48), (byte)(this.h0 >>> 40), (byte)(this.h0 >>> 32), (byte)(this.h0 >>> 24), (byte)(this.h0 >>> 16), (byte)(this.h0 >>> 8), (byte)this.h0, (byte)(this.h1 >>> 56), (byte)(this.h1 >>> 48), (byte)(this.h1 >>> 40), (byte)(this.h1 >>> 32), (byte)(this.h1 >>> 24), (byte)(this.h1 >>> 16), (byte)(this.h1 >>> 8), (byte)this.h1, (byte)(this.h2 >>> 56), (byte)(this.h2 >>> 48), (byte)(this.h2 >>> 40), (byte)(this.h2 >>> 32), (byte)(this.h2 >>> 24), (byte)(this.h2 >>> 16), (byte)(this.h2 >>> 8), (byte)this.h2, (byte)(this.h3 >>> 56), (byte)(this.h3 >>> 48), (byte)(this.h3 >>> 40), (byte)(this.h3 >>> 32), (byte)(this.h3 >>> 24), (byte)(this.h3 >>> 16), (byte)(this.h3 >>> 8), (byte)this.h3, (byte)(this.h4 >>> 56), (byte)(this.h4 >>> 48), (byte)(this.h4 >>> 40), (byte)(this.h4 >>> 32), (byte)(this.h4 >>> 24), (byte)(this.h4 >>> 16), (byte)(this.h4 >>> 8), (byte)this.h4, (byte)(this.h5 >>> 56), (byte)(this.h5 >>> 48), (byte)(this.h5 >>> 40), (byte)(this.h5 >>> 32), (byte)(this.h5 >>> 24), (byte)(this.h5 >>> 16), (byte)(this.h5 >>> 8), (byte)this.h5, (byte)(this.h6 >>> 56), (byte)(this.h6 >>> 48), (byte)(this.h6 >>> 40), (byte)(this.h6 >>> 32), (byte)(this.h6 >>> 24), (byte)(this.h6 >>> 16), (byte)(this.h6 >>> 8), (byte)this.h6, (byte)(this.h7 >>> 56), (byte)(this.h7 >>> 48), (byte)(this.h7 >>> 40), (byte)(this.h7 >>> 32), (byte)(this.h7 >>> 24), (byte)(this.h7 >>> 16), (byte)(this.h7 >>> 8), (byte)this.h7};
    }

    protected void resetContext() {
        this.h0 = 7640891576956012808L;
        this.h1 = -4942790177534073029L;
        this.h2 = 4354685564936845355L;
        this.h3 = -6534734903238641935L;
        this.h4 = 5840696475078001361L;
        this.h5 = -7276294671716946913L;
        this.h6 = 2270897969802886507L;
        this.h7 = 6620516959819538809L;
    }

    public boolean selfTest() {
        if (valid == null) {
            Sha512 sha512 = new Sha512();
            sha512.update((byte)97);
            sha512.update((byte)98);
            sha512.update((byte)99);
            String string = Util.toString(sha512.digest());
            valid = DIGEST0.equals(string);
        }
        return valid;
    }

    private static final synchronized long[] sha(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, byte[] byArray, int n) {
        long l9;
        long l10;
        int n2;
        long l11 = l;
        long l12 = l2;
        long l13 = l3;
        long l14 = l4;
        long l15 = l5;
        long l16 = l6;
        long l17 = l7;
        long l18 = l8;
        for (n2 = 0; n2 < 16; ++n2) {
            Sha512.w[n2] = (long)byArray[n++] << 56 | ((long)byArray[n++] & (long)255) << 48 | ((long)byArray[n++] & (long)255) << 40 | ((long)byArray[n++] & (long)255) << 32 | ((long)byArray[n++] & (long)255) << 24 | ((long)byArray[n++] & (long)255) << 16 | ((long)byArray[n++] & (long)255) << 8 | (long)byArray[n++] & (long)255;
        }
        for (n2 = 16; n2 < 80; ++n2) {
            l10 = w[n2 - 2];
            l9 = w[n2 - 15];
            Sha512.w[n2] = ((l10 >>> 19 | l10 << 45) ^ (l10 >>> 61 | l10 << 3) ^ l10 >>> 6) + w[n2 - 7] + ((l9 >>> 1 | l9 << 63) ^ (l9 >>> 8 | l9 << 56) ^ l9 >>> 7) + w[n2 - 16];
        }
        for (n2 = 0; n2 < 80; ++n2) {
            l10 = l18 + ((l15 >>> 14 | l15 << 50) ^ (l15 >>> 18 | l15 << 46) ^ (l15 >>> 41 | l15 << 23)) + (l15 & l16 ^ (l15 ^ (long)-1) & l17) + k[n2] + w[n2];
            l9 = ((l11 >>> 28 | l11 << 36) ^ (l11 >>> 34 | l11 << 30) ^ (l11 >>> 39 | l11 << 25)) + (l11 & l12 ^ l11 & l13 ^ l12 & l13);
            l18 = l17;
            l17 = l16;
            l16 = l15;
            l15 = l14 + l10;
            l14 = l13;
            l13 = l12;
            l12 = l11;
            l11 = l10 + l9;
        }
        return new long[]{l + l11, l2 + l12, l3 + l13, l4 + l14, l5 + l15, l6 + l16, l7 + l17, l8 + l18};
    }

    static {
        DIGEST0 = DIGEST0;
        w = new long[80];
    }
}

