<?php
/**
 * $Horde: chora/co.php,v 1.59.2.7 2009/01/06 15:22:34 jan Exp $
 *
 * Copyright 2000-2009 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Anil Madhavapeddy <avsm@horde.org>
 */

@define('CHORA_BASE', dirname(__FILE__));
require_once CHORA_BASE . '/lib/base.php';
require_once 'Horde/MIME/Part.php';
require_once 'Horde/MIME/Magic.php';
require_once 'Horde/MIME/Viewer.php';
if (is_callable(array('Horde', 'loadConfiguration'))) {
    $result = Horde::loadConfiguration('mime_drivers.php', array('mime_drivers', 'mime_drivers_map'), 'horde');
    extract($result);
    $result = Horde::loadConfiguration('mime_drivers.php', array('mime_drivers', 'mime_drivers_map'), 'chora');
    require_once 'Horde/Array.php';
    if (isset($result['mime_drivers'])) {
        $mime_drivers = Horde_Array::array_merge_recursive_overwrite($mime_drivers, $result['mime_drivers']);
    }
    if (isset($result['mime_drivers_map'])) {
        $mime_drivers_map = Horde_Array::array_merge_recursive_overwrite($mime_drivers_map, $result['mime_drivers_map']);
    }
} else {
    require_once HORDE_BASE . '/config/mime_drivers.php';
    require_once CHORA_BASE . '/config/mime_drivers.php';
}

/* If we know we're at a directory, just go to browse.php. */
if ($atdir) {
    require CHORA_BASE . '/browse.php';
    exit;
}

/* Should we pretty-print this output or not? */
$plain = Util::getFormData('p', 0);

/* Create the VC_File object and populate it. */
$file = &$VC->getFileObject($where, $cache);
Chora::checkError($file);

/* Get the revision number. */
$r = Util::getFormData('r', 0);

/* If no revision is specified, default to HEAD.  If a revision is
 * specified, it's safe to cache for a long time. */
if ($r == 0) {
    $r = $file->queryRevision();
    header('Cache-Control: max-age=60, must-revalidate');
} else {
    header('Cache-Control: max-age=2419200');
}

/* Is this a valid revision being requested? */
if (!VC_Revision::valid($r)) {
    Chora::fatal('404 Not Found', "Revision Not Found: $r is not a valid revision number");
}

/* Retrieve the actual checkout. */
$checkOut = $VC->getCheckout($file, $r);

/* Get the MIME type of the file, or at least our best guess at it. */
$mime_type = MIME_Magic::filenameToMIME($fullname);
if ($mime_type == 'application/octet-stream') {
    $mime_type = 'text/plain';
}

/* Check error status, and either show error page, or the checkout
 * contents */
Chora::checkError($checkOut);

if (!$plain) {
    /* Pretty-print the checked out copy */
    $pretty = Chora::pretty($mime_type, $checkOut);

    /* Get this revision's attributes in printable form. */
    $log = $file->logs[$r];

    $title = sprintf(_("%s Revision %s (%s ago)"),
                     basename($fullname),
                     $r,
                     Chora::readableTime($log->date, true));
    $extraLink = sprintf('<a href="%s">%s</a> | <a href="%s">%s</a>',
                         Chora::url('annotate', $where, array('rev' => $r)), _("Annotate"),
                         Chora::url('co', $where, array('r' => $r, 'p' => 1)), _("Download"));

    $tags = Chora::getTags($log, $where);
    list($branchName,) = Chora::getBranch($file, $r);

    $log_print = Chora::formatLogMessage($log->queryLog());
    $author = Chora::showAuthorName($log->queryAuthor(), true);

    Horde::addScriptFile('prototype.js', 'chora', true);
    Horde::addScriptFile('stripe.js', 'chora', true);
    require CHORA_TEMPLATES . '/common-header.inc';
    require CHORA_TEMPLATES . '/menu.inc';
    require CHORA_TEMPLATES . '/headerbar.inc';
    require CHORA_TEMPLATES . '/checkout/checkout.inc';
    require $registry->get('templates', 'horde') . '/common-footer.inc';
    exit;
}

/* Download the file. */

// Get data.
$content = '';
while ($line = fgets($checkOut)) {
    $content .= $line;
}
@fclose($checkOut);

// Get name.
$filename = $file->queryName();
if ($browser->getBrowser() == 'opera') {
    $filename = strtr($filename, ' ', '_');
}

// Send headers.
$browser->downloadHeaders($filename, $mime_type, false, strlen($content));

// Send data.
echo $content;
