static struct errcodes {
  int  error_no;
  const char *error_name;
  const char *exception;
} errors [] = {
#ifdef ERRCODE_CONNECTION_EXCEPTION
  {    ERRCODE_CONNECTION_EXCEPTION,
      "ERRCODE_CONNECTION_EXCEPTION", "ConnectionError"},
#endif
#ifdef ERRCODE_CONNECTION_DOES_NOT_EXIST
  {    ERRCODE_CONNECTION_DOES_NOT_EXIST,
      "ERRCODE_CONNECTION_DOES_NOT_EXIST", "ConnectionError"},
#endif
#ifdef ERRCODE_CONNECTION_FAILURE
  {    ERRCODE_CONNECTION_FAILURE,
      "ERRCODE_CONNECTION_FAILURE", "ConnectionError"},
#endif
#ifdef ERRCODE_SQLCLIENT_UNABLE_TO_ESTABLISH_SQLCONNECTION
  {    ERRCODE_SQLCLIENT_UNABLE_TO_ESTABLISH_SQLCONNECTION,
      "ERRCODE_SQLCLIENT_UNABLE_TO_ESTABLISH_SQLCONNECTION", "ConnectionError"},
#endif
#ifdef ERRCODE_SQLSERVER_REJECTED_ESTABLISHMENT_OF_SQLCONNECTION
  {    ERRCODE_SQLSERVER_REJECTED_ESTABLISHMENT_OF_SQLCONNECTION,
      "ERRCODE_SQLSERVER_REJECTED_ESTABLISHMENT_OF_SQLCONNECTION", "ConnectionError"},
#endif
#ifdef ERRCODE_TRANSACTION_RESOLUTION_UNKNOWN
  {    ERRCODE_TRANSACTION_RESOLUTION_UNKNOWN,
      "ERRCODE_TRANSACTION_RESOLUTION_UNKNOWN", "ConnectionError"},
#endif
#ifdef ERRCODE_PROTOCOL_VIOLATION
  {    ERRCODE_PROTOCOL_VIOLATION,
      "ERRCODE_PROTOCOL_VIOLATION", "ConnectionError"},
#endif

#ifdef ERRCODE_DATA_EXCEPTION
  {    ERRCODE_DATA_EXCEPTION,
      "ERRCODE_DATA_EXCEPTION", "DataError"},
#endif
#ifdef ERRCODE_ARRAY_ELEMENT_ERROR
  {    ERRCODE_ARRAY_ELEMENT_ERROR,
      "ERRCODE_ARRAY_ELEMENT_ERROR", "DataError"},
#endif
#ifdef ERRCODE_ARRAY_SUBSCRIPT_ERROR
  {    ERRCODE_ARRAY_SUBSCRIPT_ERROR,
      "ERRCODE_ARRAY_SUBSCRIPT_ERROR", "DataError"},
#endif
#ifdef ERRCODE_CHARACTER_NOT_IN_REPERTOIRE
  {    ERRCODE_CHARACTER_NOT_IN_REPERTOIRE,
      "ERRCODE_CHARACTER_NOT_IN_REPERTOIRE", "DataError"},
#endif
#ifdef ERRCODE_DATETIME_FIELD_OVERFLOW
  {    ERRCODE_DATETIME_FIELD_OVERFLOW,
      "ERRCODE_DATETIME_FIELD_OVERFLOW", "DataError"},
#endif
#ifdef ERRCODE_DATETIME_VALUE_OUT_OF_RANGE
  {    ERRCODE_DATETIME_VALUE_OUT_OF_RANGE,
      "ERRCODE_DATETIME_VALUE_OUT_OF_RANGE", "DataError"},
#endif
#ifdef ERRCODE_DIVISION_BY_ZERO
  {    ERRCODE_DIVISION_BY_ZERO,
      "ERRCODE_DIVISION_BY_ZERO", "DataError"},
#endif
#ifdef ERRCODE_ERROR_IN_ASSIGNMENT
  {    ERRCODE_ERROR_IN_ASSIGNMENT,
      "ERRCODE_ERROR_IN_ASSIGNMENT", "DataError"},
#endif
#ifdef ERRCODE_ESCAPE_CHARACTER_CONFLICT
  {    ERRCODE_ESCAPE_CHARACTER_CONFLICT,
      "ERRCODE_ESCAPE_CHARACTER_CONFLICT", "DataError"},
#endif
#ifdef ERRCODE_INDICATOR_OVERFLOW
  {    ERRCODE_INDICATOR_OVERFLOW,
      "ERRCODE_INDICATOR_OVERFLOW", "DataError"},
#endif
#ifdef ERRCODE_INTERVAL_FIELD_OVERFLOW
  {    ERRCODE_INTERVAL_FIELD_OVERFLOW,
      "ERRCODE_INTERVAL_FIELD_OVERFLOW", "DataError"},
#endif
#ifdef ERRCODE_INVALID_ARGUMENT_FOR_LOG
  {    ERRCODE_INVALID_ARGUMENT_FOR_LOG,
      "ERRCODE_INVALID_ARGUMENT_FOR_LOG", "DataError"},
#endif
#ifdef ERRCODE_INVALID_ARGUMENT_FOR_NTILE
  {    ERRCODE_INVALID_ARGUMENT_FOR_NTILE,
      "ERRCODE_INVALID_ARGUMENT_FOR_NTILE", "DataError"},
#endif
#ifdef ERRCODE_INVALID_ARGUMENT_FOR_NTH_VALUE
  {    ERRCODE_INVALID_ARGUMENT_FOR_NTH_VALUE,
      "ERRCODE_INVALID_ARGUMENT_FOR_NTH_VALUE", "DataError"},
#endif
#ifdef ERRCODE_INVALID_ARGUMENT_FOR_POWER_FUNCTION
  {    ERRCODE_INVALID_ARGUMENT_FOR_POWER_FUNCTION,
      "ERRCODE_INVALID_ARGUMENT_FOR_POWER_FUNCTION", "DataError"},
#endif
#ifdef ERRCODE_INVALID_ARGUMENT_FOR_WIDTH_BUCKET_FUNCTION
  {    ERRCODE_INVALID_ARGUMENT_FOR_WIDTH_BUCKET_FUNCTION,
      "ERRCODE_INVALID_ARGUMENT_FOR_WIDTH_BUCKET_FUNCTION", "DataError"},
#endif
#ifdef ERRCODE_INVALID_CHARACTER_VALUE_FOR_CAST
  {    ERRCODE_INVALID_CHARACTER_VALUE_FOR_CAST,
      "ERRCODE_INVALID_CHARACTER_VALUE_FOR_CAST", "DataError"},
#endif
#ifdef ERRCODE_INVALID_DATETIME_FORMAT
  {    ERRCODE_INVALID_DATETIME_FORMAT,
      "ERRCODE_INVALID_DATETIME_FORMAT", "DataError"},
#endif
#ifdef ERRCODE_INVALID_ESCAPE_CHARACTER
  {    ERRCODE_INVALID_ESCAPE_CHARACTER,
      "ERRCODE_INVALID_ESCAPE_CHARACTER", "DataError"},
#endif
#ifdef ERRCODE_INVALID_ESCAPE_OCTET
  {    ERRCODE_INVALID_ESCAPE_OCTET,
      "ERRCODE_INVALID_ESCAPE_OCTET", "DataError"},
#endif
#ifdef ERRCODE_INVALID_ESCAPE_SEQUENCE
  {    ERRCODE_INVALID_ESCAPE_SEQUENCE,
      "ERRCODE_INVALID_ESCAPE_SEQUENCE", "DataError"},
#endif
#ifdef ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER
  {    ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER,
      "ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER", "DataError"},
#endif
#ifdef ERRCODE_INVALID_INDICATOR_PARAMETER_VALUE
  {    ERRCODE_INVALID_INDICATOR_PARAMETER_VALUE,
      "ERRCODE_INVALID_INDICATOR_PARAMETER_VALUE", "DataError"},
#endif
#ifdef ERRCODE_INVALID_LIMIT_VALUE
  {    ERRCODE_INVALID_LIMIT_VALUE,
      "ERRCODE_INVALID_LIMIT_VALUE", "DataError"},
#endif
#ifdef ERRCODE_INVALID_PARAMETER_VALUE
  {    ERRCODE_INVALID_PARAMETER_VALUE,
      "ERRCODE_INVALID_PARAMETER_VALUE", "DataError"},
#endif
#ifdef ERRCODE_INVALID_REGULAR_EXPRESSION
  {    ERRCODE_INVALID_REGULAR_EXPRESSION,
      "ERRCODE_INVALID_REGULAR_EXPRESSION", "DataError"},
#endif
#ifdef ERRCODE_INVALID_TIME_ZONE_DISPLACEMENT_VALUE
  {    ERRCODE_INVALID_TIME_ZONE_DISPLACEMENT_VALUE,
      "ERRCODE_INVALID_TIME_ZONE_DISPLACEMENT_VALUE", "DataError"},
#endif
#ifdef ERRCODE_INVALID_USE_OF_ESCAPE_CHARACTER
  {    ERRCODE_INVALID_USE_OF_ESCAPE_CHARACTER,
      "ERRCODE_INVALID_USE_OF_ESCAPE_CHARACTER", "DataError"},
#endif
#ifdef ERRCODE_MOST_SPECIFIC_TYPE_MISMATCH
  {    ERRCODE_MOST_SPECIFIC_TYPE_MISMATCH,
      "ERRCODE_MOST_SPECIFIC_TYPE_MISMATCH", "DataError"},
#endif
#ifdef ERRCODE_NULL_VALUE_NOT_ALLOWED
  {    ERRCODE_NULL_VALUE_NOT_ALLOWED,
      "ERRCODE_NULL_VALUE_NOT_ALLOWED", "DataError"},
#endif
#ifdef ERRCODE_NULL_VALUE_NO_INDICATOR_PARAMETER
  {    ERRCODE_NULL_VALUE_NO_INDICATOR_PARAMETER,
      "ERRCODE_NULL_VALUE_NO_INDICATOR_PARAMETER", "DataError"},
#endif
#ifdef ERRCODE_NUMERIC_VALUE_OUT_OF_RANGE
  {    ERRCODE_NUMERIC_VALUE_OUT_OF_RANGE,
      "ERRCODE_NUMERIC_VALUE_OUT_OF_RANGE", "DataError"},
#endif
#ifdef ERRCODE_STRING_DATA_LENGTH_MISMATCH
  {    ERRCODE_STRING_DATA_LENGTH_MISMATCH,
      "ERRCODE_STRING_DATA_LENGTH_MISMATCH", "DataError"},
#endif
#ifdef ERRCODE_STRING_DATA_RIGHT_TRUNCATION
  {    ERRCODE_STRING_DATA_RIGHT_TRUNCATION,
      "ERRCODE_STRING_DATA_RIGHT_TRUNCATION", "DataError"},
#endif
#ifdef ERRCODE_SUBSTRING_ERROR
  {    ERRCODE_SUBSTRING_ERROR,
      "ERRCODE_SUBSTRING_ERROR", "DataError"},
#endif
#ifdef ERRCODE_TRIM_ERROR
  {    ERRCODE_TRIM_ERROR,
      "ERRCODE_TRIM_ERROR", "DataError"},
#endif
#ifdef ERRCODE_UNTERMINATED_C_STRING
  {    ERRCODE_UNTERMINATED_C_STRING,
      "ERRCODE_UNTERMINATED_C_STRING", "DataError"},
#endif
#ifdef ERRCODE_ZERO_LENGTH_CHARACTER_STRING
  {    ERRCODE_ZERO_LENGTH_CHARACTER_STRING,
      "ERRCODE_ZERO_LENGTH_CHARACTER_STRING", "DataError"},
#endif
#ifdef ERRCODE_FLOATING_POINT_EXCEPTION
  {    ERRCODE_FLOATING_POINT_EXCEPTION,
      "ERRCODE_FLOATING_POINT_EXCEPTION", "DataError"},
#endif
#ifdef ERRCODE_INVALID_TEXT_REPRESENTATION
  {    ERRCODE_INVALID_TEXT_REPRESENTATION,
      "ERRCODE_INVALID_TEXT_REPRESENTATION", "DataError"},
#endif
#ifdef ERRCODE_INVALID_BINARY_REPRESENTATION
  {    ERRCODE_INVALID_BINARY_REPRESENTATION,
      "ERRCODE_INVALID_BINARY_REPRESENTATION", "DataError"},
#endif
#ifdef ERRCODE_BAD_COPY_FILE_FORMAT
  {    ERRCODE_BAD_COPY_FILE_FORMAT,
      "ERRCODE_BAD_COPY_FILE_FORMAT", "DataError"},
#endif
#ifdef ERRCODE_UNTRANSLATABLE_CHARACTER
  {    ERRCODE_UNTRANSLATABLE_CHARACTER,
      "ERRCODE_UNTRANSLATABLE_CHARACTER", "DataError"},
#endif
#ifdef ERRCODE_NOT_AN_XML_DOCUMENT
  {    ERRCODE_NOT_AN_XML_DOCUMENT,
      "ERRCODE_NOT_AN_XML_DOCUMENT", "DataError"},
#endif
#ifdef ERRCODE_INVALID_XML_DOCUMENT
  {    ERRCODE_INVALID_XML_DOCUMENT,
      "ERRCODE_INVALID_XML_DOCUMENT", "DataError"},
#endif
#ifdef ERRCODE_INVALID_XML_CONTENT
  {    ERRCODE_INVALID_XML_CONTENT,
      "ERRCODE_INVALID_XML_CONTENT", "DataError"},
#endif
#ifdef ERRCODE_INVALID_XML_COMMENT
  {    ERRCODE_INVALID_XML_COMMENT,
      "ERRCODE_INVALID_XML_COMMENT", "DataError"},
#endif
#ifdef ERRCODE_INVALID_XML_PROCESSING_INSTRUCTION
  {    ERRCODE_INVALID_XML_PROCESSING_INSTRUCTION,
      "ERRCODE_INVALID_XML_PROCESSING_INSTRUCTION", "DataError"},
#endif

#ifdef ERRCODE_INTEGRITY_CONSTRAINT_VIOLATION
  {    ERRCODE_INTEGRITY_CONSTRAINT_VIOLATION,
      "ERRCODE_INTEGRITY_CONSTRAINT_VIOLATION", "IntegrityError"},
#endif
#ifdef ERRCODE_RESTRICT_VIOLATION
  {    ERRCODE_RESTRICT_VIOLATION,
      "ERRCODE_RESTRICT_VIOLATION", "IntegrityError"},
#endif
#ifdef ERRCODE_NOT_NULL_VIOLATION
  {    ERRCODE_NOT_NULL_VIOLATION,
      "ERRCODE_NOT_NULL_VIOLATION", "IntegrityError"},
#endif
#ifdef ERRCODE_FOREIGN_KEY_VIOLATION
  {    ERRCODE_FOREIGN_KEY_VIOLATION,
      "ERRCODE_FOREIGN_KEY_VIOLATION", "IntegrityError"},
#endif
#ifdef ERRCODE_UNIQUE_VIOLATION
  {    ERRCODE_UNIQUE_VIOLATION,
      "ERRCODE_UNIQUE_VIOLATION", "IntegrityError"},
#endif
#ifdef ERRCODE_CHECK_VIOLATION
  {    ERRCODE_CHECK_VIOLATION,
      "ERRCODE_CHECK_VIOLATION", "IntegrityError"},
#endif
#ifdef ERRCODE_WITH_CHECK_OPTION_VIOLATION
  {    ERRCODE_WITH_CHECK_OPTION_VIOLATION,
      "ERRCODE_WITH_CHECK_OPTION_VIOLATION", "IntegrityError"},
#endif

#ifdef ERRCODE_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION
  {    ERRCODE_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION,
      "ERRCODE_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION", "SyntaxError"},
#endif
#ifdef ERRCODE_SYNTAX_ERROR
  {    ERRCODE_SYNTAX_ERROR,
      "ERRCODE_SYNTAX_ERROR", "SyntaxError"},
#endif
#ifdef ERRCODE_INSUFFICIENT_PRIVILEGE
  {    ERRCODE_INSUFFICIENT_PRIVILEGE,
      "ERRCODE_INSUFFICIENT_PRIVILEGE", "SyntaxError"},
#endif
#ifdef ERRCODE_CANNOT_COERCE
  {    ERRCODE_CANNOT_COERCE,
      "ERRCODE_CANNOT_COERCE", "SyntaxError"},
#endif
#ifdef ERRCODE_GROUPING_ERROR
  {    ERRCODE_GROUPING_ERROR,
      "ERRCODE_GROUPING_ERROR", "SyntaxError"},
#endif
#ifdef ERRCODE_WINDOWING_ERROR
  {    ERRCODE_WINDOWING_ERROR,
      "ERRCODE_WINDOWING_ERROR", "SyntaxError"},
#endif
#ifdef ERRCODE_INVALID_RECURSION
  {    ERRCODE_INVALID_RECURSION,
      "ERRCODE_INVALID_RECURSION", "SyntaxError"},
#endif
#ifdef ERRCODE_INVALID_FOREIGN_KEY
  {    ERRCODE_INVALID_FOREIGN_KEY,
      "ERRCODE_INVALID_FOREIGN_KEY", "SyntaxError"},
#endif
#ifdef ERRCODE_INVALID_NAME
  {    ERRCODE_INVALID_NAME,
      "ERRCODE_INVALID_NAME", "SyntaxError"},
#endif
#ifdef ERRCODE_NAME_TOO_LONG
  {    ERRCODE_NAME_TOO_LONG,
      "ERRCODE_NAME_TOO_LONG", "SyntaxError"},
#endif
#ifdef ERRCODE_RESERVED_NAME
  {    ERRCODE_RESERVED_NAME,
      "ERRCODE_RESERVED_NAME", "SyntaxError"},
#endif
#ifdef ERRCODE_DATATYPE_MISMATCH
  {    ERRCODE_DATATYPE_MISMATCH,
      "ERRCODE_DATATYPE_MISMATCH", "SyntaxError"},
#endif
#ifdef ERRCODE_INDETERMINATE_DATATYPE
  {    ERRCODE_INDETERMINATE_DATATYPE,
      "ERRCODE_INDETERMINATE_DATATYPE", "SyntaxError"},
#endif
#ifdef ERRCODE_WRONG_OBJECT_TYPE
  {    ERRCODE_WRONG_OBJECT_TYPE,
      "ERRCODE_WRONG_OBJECT_TYPE", "SyntaxError"},
#endif
#ifdef ERRCODE_UNDEFINED_COLUMN
  {    ERRCODE_UNDEFINED_COLUMN,
      "ERRCODE_UNDEFINED_COLUMN", "SyntaxError"},
#endif
#ifdef ERRCODE_UNDEFINED_CURSOR
  {    ERRCODE_UNDEFINED_CURSOR,
      "ERRCODE_UNDEFINED_CURSOR", "SyntaxError"},
#endif
#ifdef ERRCODE_UNDEFINED_DATABASE
  {    ERRCODE_UNDEFINED_DATABASE,
      "ERRCODE_UNDEFINED_DATABASE", "SyntaxError"},
#endif
#ifdef ERRCODE_UNDEFINED_FUNCTION
  {    ERRCODE_UNDEFINED_FUNCTION,
      "ERRCODE_UNDEFINED_FUNCTION", "SyntaxError"},
#endif
#ifdef ERRCODE_UNDEFINED_PSTATEMENT
  {    ERRCODE_UNDEFINED_PSTATEMENT,
      "ERRCODE_UNDEFINED_PSTATEMENT", "SyntaxError"},
#endif
#ifdef ERRCODE_UNDEFINED_SCHEMA
  {    ERRCODE_UNDEFINED_SCHEMA,
      "ERRCODE_UNDEFINED_SCHEMA", "SyntaxError"},
#endif
#ifdef ERRCODE_UNDEFINED_TABLE
  {    ERRCODE_UNDEFINED_TABLE,
      "ERRCODE_UNDEFINED_TABLE", "SyntaxError"},
#endif
#ifdef ERRCODE_UNDEFINED_PARAMETER
  {    ERRCODE_UNDEFINED_PARAMETER,
      "ERRCODE_UNDEFINED_PARAMETER", "SyntaxError"},
#endif
#ifdef ERRCODE_UNDEFINED_OBJECT
  {    ERRCODE_UNDEFINED_OBJECT,
      "ERRCODE_UNDEFINED_OBJECT", "SyntaxError"},
#endif
#ifdef ERRCODE_DUPLICATE_COLUMN
  {    ERRCODE_DUPLICATE_COLUMN,
      "ERRCODE_DUPLICATE_COLUMN", "SyntaxError"},
#endif
#ifdef ERRCODE_DUPLICATE_CURSOR
  {    ERRCODE_DUPLICATE_CURSOR,
      "ERRCODE_DUPLICATE_CURSOR", "SyntaxError"},
#endif
#ifdef ERRCODE_DUPLICATE_DATABASE
  {    ERRCODE_DUPLICATE_DATABASE,
      "ERRCODE_DUPLICATE_DATABASE", "SyntaxError"},
#endif
#ifdef ERRCODE_DUPLICATE_FUNCTION
  {    ERRCODE_DUPLICATE_FUNCTION,
      "ERRCODE_DUPLICATE_FUNCTION", "SyntaxError"},
#endif
#ifdef ERRCODE_DUPLICATE_PSTATEMENT
  {    ERRCODE_DUPLICATE_PSTATEMENT,
      "ERRCODE_DUPLICATE_PSTATEMENT", "SyntaxError"},
#endif
#ifdef ERRCODE_DUPLICATE_SCHEMA
  {    ERRCODE_DUPLICATE_SCHEMA,
      "ERRCODE_DUPLICATE_SCHEMA", "SyntaxError"},
#endif
#ifdef ERRCODE_DUPLICATE_TABLE
  {    ERRCODE_DUPLICATE_TABLE,
      "ERRCODE_DUPLICATE_TABLE", "SyntaxError"},
#endif
#ifdef ERRCODE_DUPLICATE_ALIAS
  {    ERRCODE_DUPLICATE_ALIAS,
      "ERRCODE_DUPLICATE_ALIAS", "SyntaxError"},
#endif
#ifdef ERRCODE_DUPLICATE_OBJECT
  {    ERRCODE_DUPLICATE_OBJECT,
      "ERRCODE_DUPLICATE_OBJECT", "SyntaxError"},
#endif
#ifdef ERRCODE_AMBIGUOUS_COLUMN
  {    ERRCODE_AMBIGUOUS_COLUMN,
      "ERRCODE_AMBIGUOUS_COLUMN", "SyntaxError"},
#endif
#ifdef ERRCODE_AMBIGUOUS_FUNCTION
  {    ERRCODE_AMBIGUOUS_FUNCTION,
      "ERRCODE_AMBIGUOUS_FUNCTION", "SyntaxError"},
#endif
#ifdef ERRCODE_AMBIGUOUS_PARAMETER
  {    ERRCODE_AMBIGUOUS_PARAMETER,
      "ERRCODE_AMBIGUOUS_PARAMETER", "SyntaxError"},
#endif
#ifdef ERRCODE_AMBIGUOUS_ALIAS
  {    ERRCODE_AMBIGUOUS_ALIAS,
      "ERRCODE_AMBIGUOUS_ALIAS", "SyntaxError"},
#endif
#ifdef ERRCODE_INVALID_COLUMN_REFERENCE
  {    ERRCODE_INVALID_COLUMN_REFERENCE,
      "ERRCODE_INVALID_COLUMN_REFERENCE", "SyntaxError"},
#endif
#ifdef ERRCODE_INVALID_COLUMN_DEFINITION
  {    ERRCODE_INVALID_COLUMN_DEFINITION,
      "ERRCODE_INVALID_COLUMN_DEFINITION", "SyntaxError"},
#endif
#ifdef ERRCODE_INVALID_CURSOR_DEFINITION
  {    ERRCODE_INVALID_CURSOR_DEFINITION,
      "ERRCODE_INVALID_CURSOR_DEFINITION", "SyntaxError"},
#endif
#ifdef ERRCODE_INVALID_DATABASE_DEFINITION
  {    ERRCODE_INVALID_DATABASE_DEFINITION,
      "ERRCODE_INVALID_DATABASE_DEFINITION", "SyntaxError"},
#endif
#ifdef ERRCODE_INVALID_FUNCTION_DEFINITION
  {    ERRCODE_INVALID_FUNCTION_DEFINITION,
      "ERRCODE_INVALID_FUNCTION_DEFINITION", "SyntaxError"},
#endif
#ifdef ERRCODE_INVALID_PSTATEMENT_DEFINITION
  {    ERRCODE_INVALID_PSTATEMENT_DEFINITION,
      "ERRCODE_INVALID_PSTATEMENT_DEFINITION", "SyntaxError"},
#endif
#ifdef ERRCODE_INVALID_SCHEMA_DEFINITION
  {    ERRCODE_INVALID_SCHEMA_DEFINITION,
      "ERRCODE_INVALID_SCHEMA_DEFINITION", "SyntaxError"},
#endif
#ifdef ERRCODE_INVALID_TABLE_DEFINITION
  {    ERRCODE_INVALID_TABLE_DEFINITION,
      "ERRCODE_INVALID_TABLE_DEFINITION", "SyntaxError"},
#endif
#ifdef ERRCODE_INVALID_OBJECT_DEFINITION
  {    ERRCODE_INVALID_OBJECT_DEFINITION,
      "ERRCODE_INVALID_OBJECT_DEFINITION", "SyntaxError"},
#endif

#ifdef ERRCODE_INVALID_TRANSACTION_STATE
  {    ERRCODE_INVALID_TRANSACTION_STATE,
      "ERRCODE_INVALID_TRANSACTION_STATE", "TransactionError"},
#endif
#ifdef ERRCODE_ACTIVE_SQL_TRANSACTION
  {    ERRCODE_ACTIVE_SQL_TRANSACTION,
      "ERRCODE_ACTIVE_SQL_TRANSACTION", "TransactionError"},
#endif
#ifdef ERRCODE_BRANCH_TRANSACTION_ALREADY_ACTIVE
  {    ERRCODE_BRANCH_TRANSACTION_ALREADY_ACTIVE,
      "ERRCODE_BRANCH_TRANSACTION_ALREADY_ACTIVE", "TransactionError"},
#endif
#ifdef ERRCODE_HELD_CURSOR_REQUIRES_SAME_ISOLATION_LEVEL
  {    ERRCODE_HELD_CURSOR_REQUIRES_SAME_ISOLATION_LEVEL,
      "ERRCODE_HELD_CURSOR_REQUIRES_SAME_ISOLATION_LEVEL", "TransactionError"},
#endif
#ifdef ERRCODE_INAPPROPRIATE_ACCESS_MODE_FOR_BRANCH_TRANSACTION
  {    ERRCODE_INAPPROPRIATE_ACCESS_MODE_FOR_BRANCH_TRANSACTION,
      "ERRCODE_INAPPROPRIATE_ACCESS_MODE_FOR_BRANCH_TRANSACTION", "TransactionError"},
#endif
#ifdef ERRCODE_INAPPROPRIATE_ISOLATION_LEVEL_FOR_BRANCH_TRANSACTION
  {    ERRCODE_INAPPROPRIATE_ISOLATION_LEVEL_FOR_BRANCH_TRANSACTION,
      "ERRCODE_INAPPROPRIATE_ISOLATION_LEVEL_FOR_BRANCH_TRANSACTION", "TransactionError"},
#endif
#ifdef ERRCODE_NO_ACTIVE_SQL_TRANSACTION_FOR_BRANCH_TRANSACTION
  {    ERRCODE_NO_ACTIVE_SQL_TRANSACTION_FOR_BRANCH_TRANSACTION,
      "ERRCODE_NO_ACTIVE_SQL_TRANSACTION_FOR_BRANCH_TRANSACTION", "TransactionError"},
#endif
#ifdef ERRCODE_READ_ONLY_SQL_TRANSACTION
  {    ERRCODE_READ_ONLY_SQL_TRANSACTION,
      "ERRCODE_READ_ONLY_SQL_TRANSACTION", "TransactionError"},
#endif
#ifdef ERRCODE_SCHEMA_AND_DATA_STATEMENT_MIXING_NOT_SUPPORTED
  {    ERRCODE_SCHEMA_AND_DATA_STATEMENT_MIXING_NOT_SUPPORTED,
      "ERRCODE_SCHEMA_AND_DATA_STATEMENT_MIXING_NOT_SUPPORTED", "TransactionError"},
#endif
#ifdef ERRCODE_NO_ACTIVE_SQL_TRANSACTION
  {    ERRCODE_NO_ACTIVE_SQL_TRANSACTION,
      "ERRCODE_NO_ACTIVE_SQL_TRANSACTION", "TransactionError"},
#endif
#ifdef ERRCODE_IN_FAILED_SQL_TRANSACTION
  {    ERRCODE_IN_FAILED_SQL_TRANSACTION,
      "ERRCODE_IN_FAILED_SQL_TRANSACTION", "TransactionError"},
#endif
  {0, NULL, NULL}
};
