# -*- coding: utf-8 -*-
#
# File: MassLoader/Extensions/Install.py
#
# Copyright (c) 2007 atReal
#
# GNU General Public License (GPL)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#

"""
$Id$
"""

__author__ = """Matthias Broquet <contact@atreal.net>"""
__docformat__ = 'plaintext'
__licence__ = 'GPL'


from StringIO import StringIO
from Products.MassLoader.config    import *

def install_actions(self,out):
  print >> out, "Install action."

  atool=self.portal_actions

  existing_actions=[a.id for a in atool._cloneActions()]
  if 'massloader_import' not in existing_actions:
    atool.addAction(id='massloader_import',
                    name='Import',
                    action='string:$object_url/@@massloader_import',
                    condition='python:object.getPortalTypeName() in ["Folder","Plone Site","Large Plone Folder"]',
                    permission='Manage Portal',
                    category='object',
                    visible=1)

  # XXX The action condition should build on interface IMassLoaderable. To be implemented, maybe in a utility.
  #condition='python:"IMassLoaderable" in [item.getName() for item in object.__provides__.interfaces()]',

  print >>out, "Action was sucessfully installed"


def install(self):
    """
    Install MassLoader
    """
    out = StringIO()
   
    #install action
    install_actions(self,out)
  
    print "installed MassLoader"
    return out.getvalue()

def uninstall_actions(self,out):
    atool=self.portal_actions

    existing_actions=[a.id for a in atool._cloneActions()]
    if 'massloader_import' in existing_actions:
        atool.deleteActions([existing_actions.index('massloader_import')])

    print >>out, "Action was sucessfully uninstalled"


def uninstall(self):
    out = StringIO()

    uninstall_actions(self,out)   
 
    return out.getvalue()
