grid.ls                 package:grid                 R Documentation

_L_i_s_t _t_h_e _n_a_m_e_s _o_f _g_r_o_b_s _o_r _v_i_e_w_p_o_r_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     Returns a listing of the names of grobs or viewports.

     This is a generic function with methods for grobs (including
     gTrees) and viewports (including vpTrees).

_U_s_a_g_e:

     grid.ls(x=NULL, grobs=TRUE, viewports=FALSE, fullNames=FALSE,
             recursive=TRUE, print=TRUE, flatten=TRUE, ...)

     nestedListing(x, gindent="  ", vpindent=gindent) 
     pathListing(x, gvpSep=" | ", gAlign=TRUE) 
     grobPathListing(x, ...) 

_A_r_g_u_m_e_n_t_s:

       x: A grob or viewport or 'NULL'.  If 'NULL', the current grid
          display list is listed.

          For print functions, this should be the result of a call to
          'grid.ls'.

   grobs: A logical value indicating whether to list grobs.

viewports: A logical value indicating whether to list viewports.

fullNames: A logical value indicating whether to embellish object names
          with information about the object type.

recursive: A logical value indicating whether recursive structures
          should also list their children.

   print: A logical indicating whether to print the listing or a
          function that will print the listing.

 flatten: A logical value indicating whether to flatten the listing. 
          Otherwise a more complex hierarchical object is produced.

 gindent: The indent used to show nesting in the output for grobs.

vpindent: The indent used to show nesting in the output for viewports.

  gvpSep: The string used to separate viewport paths from grob paths.

  gAlign: Logical indicating whether to align the left hand edge of all
          grob paths.

     ...: Arguments passed to the 'print' function.

_D_e_t_a_i_l_s:

     If the argument 'x' is 'NULL', the current contents of the grid
     display list are listed (both viewports and grobs). In other
     words, all objects representing the current scene are listed.

     Otherwise, 'x' should be a grob or a viewport.

     The default behaviour of this function is to print information
     about the grobs in the current scene.  It is also possible to add
     information about the viewports in the scene.  By default, the
     listing is recursive, so all children of gTrees and all nested
     viewports are reported.

     The format of the information can be controlled via the 'print'
     argument, which can be given a function to perform the formatting.
     The 'nestedListing' function produces a line per grob or viewport,
     with indenting used to show nesting.  The 'pathListing' function
     produces a line per grob or viewport, with viewport paths and grob
     paths used to show nesting.  The 'grobPathListing' is a simple
     derivation that only shows lines for grobs.  The user can define
     new functions.

_V_a_l_u_e:

     The result of this function is either a '"gridFlatListing"' object
     (if 'flatten' is 'TRUE') or a '"gridListing"' object.

     The former is a simple (flat) list of vectors.  This is
     convenient, for example, for working programmatically with the
     list of grob and viewport names, or for writing a new display
     function for the listing.

     The latter is a more complex heiararchical object (list of lists),
     but it does contain more detailed information so may be of use for
     more advanced customisations.

_A_u_t_h_o_r(_s):

     Paul Murrell

_S_e_e _A_l_s_o:

     'grob' 'viewport'

_E_x_a_m_p_l_e_s:

     # A gTree, called "parent", with childrenvp vpTree (vp2 within vp1)
     # and child grob, called "child", with vp vpPath (down to vp2)
     sampleGTree <- gTree(name="parent",
                          children=gList(grob(name="child", vp="vp1::vp2")),
                          childrenvp=vpTree(parent=viewport(name="vp1"),
                                            children=vpList(viewport(name="vp2"))))
     grid.ls(sampleGTree)
     # Show viewports too
     grid.ls(sampleGTree, view=TRUE)
     # Only show viewports
     grid.ls(sampleGTree, view=TRUE, grob=FALSE)
     # Alternate displays
     # nested listing, custom indent
     grid.ls(sampleGTree, view=TRUE, print=nestedListing, gindent="--")
     # path listing
     grid.ls(sampleGTree, view=TRUE, print=pathListing)
     # path listing, without grobs aligned
     grid.ls(sampleGTree, view=TRUE, print=pathListing, gAlign=FALSE)
     # grob path listing 
     grid.ls(sampleGTree, view=TRUE, print=grobPathListing)
     # path listing, grobs only
     grid.ls(sampleGTree, print=pathListing)
     # path listing, viewports only
     grid.ls(sampleGTree, view=TRUE, grob=FALSE, print=pathListing)
     # raw flat listing
     str(grid.ls(sampleGTree, view=TRUE, print=FALSE))

