/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.host;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.Lists;
import org.apache.webapp.admin.host.HostForm;

public class EditHostAction
extends Action {
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        ObjectName hname = null;
        StringBuffer sb = null;
        try {
            hname = new ObjectName(request.getParameter("select"));
        }
        catch (Exception e) {
            String message = resources.getMessage(locale, "error.hostName.bad", (Object)request.getParameter("select"));
            this.getServlet().log(message);
            response.sendError(400, message);
            return null;
        }
        String adminHost = null;
        String domain = hname.getDomain();
        try {
            adminHost = Lists.getAdminAppHost(this.mBServer, domain, request);
        }
        catch (Exception e) {
            String message = resources.getMessage(locale, "error.hostName.bad", (Object)adminHost);
            this.getServlet().log(message);
            response.sendError(400, message);
            return null;
        }
        request.setAttribute("adminAppHost", (Object)adminHost);
        HostForm hostFm = new HostForm();
        session.setAttribute("hostForm", (Object)hostFm);
        hostFm.setAdminAction("Edit");
        hostFm.setObjectName(hname.toString());
        sb = new StringBuffer();
        sb.append(resources.getMessage(locale, "server.service.treeBuilder.host"));
        sb.append(" (");
        sb.append(hname.getKeyProperty("host"));
        sb.append(")");
        hostFm.setNodeLabel(sb.toString());
        hostFm.setBooleanVals(Lists.getBooleanValues());
        String attribute = null;
        try {
            attribute = "name";
            hostFm.setHostName((String)this.mBServer.getAttribute(hname, attribute));
            attribute = "appBase";
            hostFm.setAppBase((String)this.mBServer.getAttribute(hname, attribute));
            attribute = "autoDeploy";
            hostFm.setAutoDeploy(((Boolean)this.mBServer.getAttribute(hname, attribute)).toString());
            attribute = "deployXML";
            hostFm.setDeployXML(((Boolean)this.mBServer.getAttribute(hname, attribute)).toString());
            attribute = "deployOnStartup";
            hostFm.setDeployOnStartup(((Boolean)this.mBServer.getAttribute(hname, attribute)).toString());
            attribute = "unpackWARs";
            hostFm.setUnpackWARs(((Boolean)this.mBServer.getAttribute(hname, attribute)).toString());
            attribute = "xmlNamespaceAware";
            hostFm.setXmlNamespaceAware(((Boolean)this.mBServer.getAttribute(hname, attribute)).toString());
            attribute = "xmlValidation";
            hostFm.setXmlValidation(((Boolean)this.mBServer.getAttribute(hname, attribute)).toString());
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), t);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
            return null;
        }
        String operation = null;
        try {
            operation = "findAliases";
            String[] aliases = (String[])this.mBServer.invoke(hname, operation, null, null);
            hostFm.setAliasVals(new ArrayList<String>(Arrays.asList(aliases)));
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.invoke", (Object)operation), t);
            response.sendError(500, resources.getMessage(locale, "users.error.invoke", (Object)operation));
            return null;
        }
        return mapping.findForward("Host");
    }
}

