/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.connector;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.Lists;
import org.apache.webapp.admin.connector.ConnectorForm;

public class EditConnectorAction
extends Action {
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        ObjectName cname = null;
        StringBuffer sb = null;
        try {
            cname = new ObjectName(request.getParameter("select"));
        }
        catch (Exception e) {
            String message = resources.getMessage(locale, "error.connectorName.bad", (Object)request.getParameter("select"));
            this.getServlet().log(message);
            response.sendError(400, message);
            return null;
        }
        ConnectorForm connectorFm = new ConnectorForm();
        session.setAttribute("connectorForm", (Object)connectorFm);
        connectorFm.setAdminAction("Edit");
        connectorFm.setObjectName(cname.toString());
        sb = new StringBuffer();
        sb.append(resources.getMessage(locale, "server.service.treeBuilder.connector"));
        sb.append(" (");
        sb.append(cname.getKeyProperty("port"));
        sb.append(")");
        connectorFm.setNodeLabel(sb.toString());
        connectorFm.setBooleanVals(Lists.getBooleanValues());
        connectorFm.setClientAuthVals(Lists.getClientAuthValues());
        String attribute = null;
        try {
            attribute = "scheme";
            String scheme = (String)this.mBServer.getAttribute(cname, attribute);
            connectorFm.setScheme(scheme);
            attribute = "protocolHandlerClassName";
            String handlerClassName = (String)this.mBServer.getAttribute(cname, attribute);
            int period = handlerClassName.lastIndexOf(46);
            String connType = handlerClassName.substring(period + 1);
            String connectorType = "HTTP";
            if ("JkCoyoteHandler".equalsIgnoreCase(connType) || "AjpAprProtocol".equalsIgnoreCase(connType)) {
                connectorType = "AJP";
            } else if ("Http11Protocol".equalsIgnoreCase(connType) && "https".equalsIgnoreCase(scheme)) {
                connectorType = "HTTPS-JSSE";
            } else if ("Http11AprProtocol".equalsIgnoreCase(connType) && "https".equalsIgnoreCase(scheme)) {
                connectorType = "HTTPS-APR";
            }
            connectorFm.setConnectorType(connectorType);
            attribute = "acceptCount";
            connectorFm.setAcceptCountText(String.valueOf(this.mBServer.getAttribute(cname, attribute)));
            attribute = "compression";
            connectorFm.setCompression((String)this.mBServer.getAttribute(cname, attribute));
            attribute = "connectionLinger";
            connectorFm.setConnLingerText(String.valueOf(this.mBServer.getAttribute(cname, attribute)));
            attribute = "connectionTimeout";
            connectorFm.setConnTimeOutText(String.valueOf(this.mBServer.getAttribute(cname, attribute)));
            attribute = "connectionUploadTimeout";
            connectorFm.setConnUploadTimeOutText(String.valueOf(this.mBServer.getAttribute(cname, attribute)));
            attribute = "disableUploadTimeout";
            connectorFm.setDisableUploadTimeout(String.valueOf(this.mBServer.getAttribute(cname, attribute)));
            attribute = "bufferSize";
            connectorFm.setBufferSizeText(String.valueOf(this.mBServer.getAttribute(cname, attribute)));
            attribute = "enableLookups";
            connectorFm.setEnableLookups(String.valueOf(this.mBServer.getAttribute(cname, attribute)));
            attribute = "address";
            Object addressObject = this.mBServer.getAttribute(cname, attribute);
            String addressStr = "";
            if (addressObject instanceof InetAddress) {
                addressStr = ((InetAddress)addressObject).getHostAddress();
            } else if (addressObject instanceof String) {
                addressStr = (String)addressObject;
            }
            connectorFm.setAddress(addressStr);
            attribute = "maxKeepAliveRequests";
            connectorFm.setMaxKeepAliveText(String.valueOf(this.mBServer.getAttribute(cname, attribute)));
            attribute = "maxSpareThreads";
            connectorFm.setMaxSpare(String.valueOf(this.mBServer.getAttribute(cname, attribute)));
            attribute = "maxThreads";
            connectorFm.setMaxThreads(String.valueOf(this.mBServer.getAttribute(cname, attribute)));
            attribute = "minSpareThreads";
            connectorFm.setMinSpare(String.valueOf(this.mBServer.getAttribute(cname, attribute)));
            attribute = "threadPriority";
            connectorFm.setThreadPriority(String.valueOf(this.mBServer.getAttribute(cname, attribute)));
            attribute = "secure";
            connectorFm.setSecure(((Boolean)this.mBServer.getAttribute(cname, attribute)).toString());
            attribute = "tcpNoDelay";
            connectorFm.setTcpNoDelay(String.valueOf(this.mBServer.getAttribute(cname, attribute)));
            attribute = "xpoweredBy";
            connectorFm.setXpoweredBy(((Boolean)this.mBServer.getAttribute(cname, attribute)).toString());
            attribute = "URIEncoding";
            connectorFm.setURIEncodingText((String)this.mBServer.getAttribute(cname, attribute));
            attribute = "useBodyEncodingForURI";
            connectorFm.setUseBodyEncodingForURIText(((Boolean)this.mBServer.getAttribute(cname, attribute)).toString());
            attribute = "allowTrace";
            connectorFm.setAllowTraceText(((Boolean)this.mBServer.getAttribute(cname, attribute)).toString());
            attribute = "port";
            connectorFm.setPortText(((Integer)this.mBServer.getAttribute(cname, attribute)).toString());
            attribute = "redirectPort";
            connectorFm.setRedirectPortText(((Integer)this.mBServer.getAttribute(cname, attribute)).toString());
            if (!"AJP".equalsIgnoreCase(connectorType)) {
                attribute = "proxyName";
                connectorFm.setProxyName((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "proxyPort";
                connectorFm.setProxyPortText(((Integer)this.mBServer.getAttribute(cname, attribute)).toString());
            }
            if ("HTTPS-JSSE".equalsIgnoreCase(connectorType)) {
                attribute = "algorithm";
                connectorFm.setAlgorithm((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "clientAuth";
                connectorFm.setClientAuthentication((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "ciphers";
                connectorFm.setCiphers((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "keystoreFile";
                connectorFm.setKeyStoreFileName((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "keystorePass";
                connectorFm.setKeyStorePassword((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "keystoreType";
                connectorFm.setKeyStoreType((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "truststoreFile";
                connectorFm.setTrustStoreFileName((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "truststorePass";
                connectorFm.setTrustStorePassword((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "truststoreType";
                connectorFm.setTrustStoreType((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "sslProtocol";
                connectorFm.setSslProtocol((String)this.mBServer.getAttribute(cname, attribute));
            }
            if ("HTTPS-APR".equalsIgnoreCase(connectorType)) {
                attribute = "SSLEngine";
                connectorFm.setSSLEngine((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "SSLProtocol";
                connectorFm.setSSLProtocol((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "SSLCipherSuite";
                connectorFm.setSSLCipherSuite((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "SSLCertificateFile";
                connectorFm.setSSLCertificateFile((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "SSLCertificateKeyFile";
                connectorFm.setSSLCertificateKeyFile((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "SSLPassword";
                connectorFm.setSSLPassword((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "SSLVerifyClient";
                connectorFm.setSSLVerifyClient((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "SSLVerifyDepth";
                connectorFm.setSSLVerifyDepthText(((Integer)this.mBServer.getAttribute(cname, attribute)).toString());
                attribute = "SSLCACertificateFile";
                connectorFm.setSSLCACertificateFile((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "SSLCACertificatePath";
                connectorFm.setSSLCACertificatePath((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "SSLCertificateChainFile";
                connectorFm.setSSLCertificateChainFile((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "SSLCARevocationFile";
                connectorFm.setSSLCARevocationFile((String)this.mBServer.getAttribute(cname, attribute));
                attribute = "SSLCARevocationPath";
                connectorFm.setSSLCARevocationPath((String)this.mBServer.getAttribute(cname, attribute));
            }
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), t);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
            return null;
        }
        return mapping.findForward("Connector");
    }
}

