/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.hyperlink;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyGoToDefinition;
import org.python.pydev.editor.actions.refactoring.PyRefactorAction;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.refactoring.IPyRefactoring;
import org.python.pydev.editor.refactoring.PyRefactoring;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.plugin.PydevPlugin;

public class PythonHyperlink
implements IHyperlink {
    private final IRegion fRegion;
    private PyEdit fEditor;

    public PythonHyperlink(IRegion region, PyEdit editor) {
        Assert.isNotNull((Object)region);
        this.fRegion = region;
        this.fEditor = editor;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getHyperlinkText() {
        return null;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        IWorkbenchWindow workbenchWindow;
        IPyRefactoring pyRefactoring = PyRefactoring.getPyRefactoring();
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null) {
            workbenchWindow.getActivePage().saveAllEditors(false);
        }
        try {
            RefactoringRequest refactoringRequest = PyRefactorAction.createRefactoringRequest(null, this.fEditor, new PySelection((ITextEditor)this.fEditor));
            ItemPointer[] pointers = pyRefactoring.findDefinition(refactoringRequest);
            if (pointers.length > 0) {
                PyGoToDefinition.openDefinition(pointers, this.fEditor, this.fEditor.getSite().getShell());
            } else {
                workbench.getActiveWorkbenchWindow().getShell().getDisplay().beep();
            }
        }
        catch (Throwable t) {
            PydevPlugin.log(t);
        }
    }
}

