/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.jython.ui;

import java.io.File;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.jython.JythonPlugin;

public class JyScriptingPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String SHOW_SCRIPTING_OUTPUT = "SHOW_SCRIPTING_OUTPUT";
    public static final boolean DEFAULT_SHOW_SCRIPTING_OUTPUT = false;
    public static final String LOG_SCRIPTING_ERRORS = "LOG_SCRIPTING_ERRORS";
    public static final boolean DEFAULT_LOG_SCRIPTING_ERRORS = true;
    public static final String ADDITIONAL_SCRIPTING_LOCATION = "ADDITIONAL_SCRIPTING_LOCATION";

    public JyScriptingPreferencesPage() {
        super(1);
        this.setPreferenceStore(JythonPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    public void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new BooleanFieldEditor(SHOW_SCRIPTING_OUTPUT, "Show the output given from the scripting to some console?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(LOG_SCRIPTING_ERRORS, "Show errors from scripting in the Error Log?", p));
        DirectoryFieldEditor fileField = new DirectoryFieldEditor(ADDITIONAL_SCRIPTING_LOCATION, "Location of additional jython scripts:", p);
        this.addField((FieldEditor)fileField);
    }

    public static boolean getShowScriptingOutput() {
        JythonPlugin plugin = JythonPlugin.getDefault();
        if (plugin == null) {
            return true;
        }
        return plugin.getPreferenceStore().getBoolean(SHOW_SCRIPTING_OUTPUT);
    }

    public static boolean getLogScriptingErrors() {
        return JythonPlugin.getDefault().getPreferenceStore().getBoolean(LOG_SCRIPTING_ERRORS);
    }

    public static File getAdditionalScriptingLocation() {
        File file;
        String loc = JythonPlugin.getDefault().getPreferenceStore().getString(ADDITIONAL_SCRIPTING_LOCATION);
        if (loc != null && loc.trim().length() > 0 && (file = new File(loc)).exists() && file.isDirectory()) {
            return file;
        }
        return null;
    }
}

