/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ui.actions.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.refactoring.core.AbstractPythonRefactoring;
import org.python.pydev.refactoring.core.RefactoringInfo;
import org.python.pydev.refactoring.ui.PythonRefactoringWizard;

public abstract class AbstractRefactoringAction
extends Action
implements IEditorActionDelegate {
    private AbstractPythonRefactoring refactoring;
    private ITextEditor targetEditor;

    protected abstract AbstractPythonRefactoring createRefactoring(RefactoringInfo var1);

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof ITextEditor) {
            this.targetEditor = targetEditor.getEditorInput() instanceof FileEditorInput ? (ITextEditor)targetEditor : null;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private static boolean saveAll() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return IDE.saveAllEditors((IResource[])new IResource[]{workspaceRoot}, (boolean)true);
    }

    private void setupRefactoring() throws MisconfigurationException {
        IPythonNature nature = null;
        if (this.targetEditor instanceof IPyEdit) {
            nature = ((IPyEdit)this.targetEditor).getPythonNature();
        }
        RefactoringInfo info = new RefactoringInfo(this.targetEditor, nature);
        this.refactoring = this.createRefactoring(info);
    }

    private void openWizard(IAction action) {
        try {
            this.setupRefactoring();
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
        }
        PythonRefactoringWizard wizard = new PythonRefactoringWizard(this.refactoring, this.targetEditor);
        wizard.run();
        this.targetEditor.getDocumentProvider().changed((Object)this.targetEditor.getEditorInput());
    }

    public void run(IAction action) {
        if (AbstractRefactoringAction.saveAll()) {
            this.openWizard(action);
        }
    }
}

