/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.NbBundle;

public class BrowseFolders
extends JPanel
implements ExplorerManager.Provider {
    private static final long serialVersionUID = -180677991433020051L;
    static final Comparator<FileObject> FILE_OBJECT_COMAPARTOR = new FileObjectComparator();
    private static final JScrollPane SAMPLE_SCROLL_PANE = new JScrollPane();
    private static final String NB_PROJECT_DIR = "nbproject";
    private final PhpVisibilityQuery phpVisibilityQuery;
    private final ExplorerManager manager;
    private final SourceGroup[] folders;
    private final Class<?> target;
    private final BeanTreeView btv;
    private JPanel folderPanel;
    private JLabel jLabel1;

    BrowseFolders(PhpVisibilityQuery phpVisibilityQuery, SourceGroup[] folders, Class<?> target, String preselectedFileName) {
        assert (phpVisibilityQuery != null);
        this.initComponents();
        String description = target == DataFolder.class ? "ACSD_BrowseFolders" : "ACSD_BrowseFiles";
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)description));
        this.phpVisibilityQuery = phpVisibilityQuery;
        this.folders = folders;
        this.target = target;
        this.manager = new ExplorerManager();
        AbstractNode rootNode = new AbstractNode((Children)new SourceGroupsChildren(folders));
        this.manager.setRootContext((Node)rootNode);
        this.btv = new BeanTreeView();
        this.btv.setRootVisible(false);
        this.btv.setSelectionMode(1);
        this.btv.setBorder(SAMPLE_SCROLL_PANE.getBorder());
        this.expandSelection(preselectedFileName);
        this.folderPanel.add((Component)this.btv, "Center");
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void expandSelection(String preselectedFileName) {
        Node root = this.manager.getRootContext();
        Children ch = root.getChildren();
        if (ch == Children.LEAF) {
            return;
        }
        Node[] nodes = ch.getNodes(true);
        Node sel = null;
        if (preselectedFileName != null && preselectedFileName.length() > 0) {
            for (Node node : nodes) {
                try {
                    sel = NodeOp.findPath((Node)node, (String[])preselectedFileName.split("/"));
                    break;
                }
                catch (NodeNotFoundException e) {
                }
            }
        }
        if (sel == null) {
            this.btv.expandNode(root);
            for (Node node : nodes) {
                this.btv.expandNode(node);
                if (sel != null) continue;
                sel = node;
            }
        }
        if (sel != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{sel});
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.folderPanel = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.folderPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BrowseFolders.class, (String)"LBL_Folders"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"BrowseFolders.jLabel1.AccessibleContext.accessibleName"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"BrowseFolders.jLabel1.AccessibleContext.accessibleDescription"));
        this.folderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.folderPanel, gridBagConstraints);
        this.folderPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"BrowseFolders.folderPanel.AccessibleContext.accessibleName"));
        this.folderPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"BrowseFolders.folderPanel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"BrowseFolders.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"BrowseFolders.AccessibleContext.accessibleDescription"));
    }

    public static FileObject showDialog(PhpVisibilityQuery phpVisibilityQuery, SourceGroup[] folders, Class<?> target, String preselectedFileName) {
        BrowseFolders bf = new BrowseFolders(phpVisibilityQuery, folders, target, preselectedFileName);
        String title = target == DataFolder.class ? "LBL_SelectFolder" : "LBL_SelectFile";
        JButton selectButton = new JButton(NbBundle.getMessage(BrowseFolders.class, (String)title));
        String description = target == DataFolder.class ? "ACSD_SelectFolder" : "ACSD_SelectFile";
        selectButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)description));
        JButton cancelButton = new JButton(NbBundle.getMessage(BrowseFolders.class, (String)"LBL_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSD_Cancel"));
        Object[] options = new JButton[]{selectButton, cancelButton};
        OptionsListener optionsListener = new OptionsListener(bf, target);
        options[0].setActionCommand("SELECT");
        options[0].addActionListener(optionsListener);
        options[1].setActionCommand("CANCEL");
        options[1].addActionListener(optionsListener);
        title = target == DataFolder.class ? "LBL_BrowseFolders" : "LBL_BrowseFiles";
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)bf, NbBundle.getMessage(BrowseFolders.class, (String)title), true, options, (Object)options[0], 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{options[0], options[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        return optionsListener.getResult();
    }

    public static FileObject showDialog(PhpVisibilityQuery phpVisibilityQuery, FileObject[] folders, Class<?> target, String preselectedFileName) {
        SourceGroup[] groups = new SourceGroup[folders.length];
        int i = 0;
        for (FileObject fo : folders) {
            groups[i++] = new FOSourceGroup(fo);
        }
        return BrowseFolders.showDialog(phpVisibilityQuery, groups, target, preselectedFileName);
    }

    private static final class FOSourceGroup
    implements SourceGroup {
        private final FileObject fo;

        public FOSourceGroup(FileObject fo) {
            assert (fo.isFolder()) : "Directory must be provided";
            this.fo = fo;
        }

        public FileObject getRootFolder() {
            return this.fo;
        }

        public String getName() {
            return this.fo.getNameExt();
        }

        public String getDisplayName() {
            return this.fo.getNameExt();
        }

        public Icon getIcon(boolean opened) {
            return null;
        }

        public boolean contains(FileObject file) {
            return FileUtil.isParentOf((FileObject)this.fo, (FileObject)file);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }

    private static final class OptionsListener
    implements ActionListener {
        public static final String COMMAND_SELECT = "SELECT";
        public static final String COMMAND_CANCEL = "CANCEL";
        private final BrowseFolders browsePanel;
        private final Class<?> target;
        private FileObject result;

        public OptionsListener(BrowseFolders browsePanel, Class<?> target) {
            this.browsePanel = browsePanel;
            this.target = target;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataObject dobj;
            Node[] selection;
            String command = e.getActionCommand();
            if (COMMAND_SELECT.equals(command) && (selection = this.browsePanel.getExplorerManager().getSelectedNodes()) != null && selection.length > 0 && (dobj = (DataObject)selection[0].getLookup().lookup(DataObject.class)) != null && this.target.isInstance(dobj)) {
                this.result = dobj.getPrimaryFile();
                if (DataObject.class == this.target && this.result.isFolder()) {
                    this.result = null;
                }
            }
        }

        public FileObject getResult() {
            return this.result;
        }
    }

    private static class FileObjectComparator
    implements Comparator<FileObject> {
        private FileObjectComparator() {
        }

        @Override
        public int compare(FileObject fo1, FileObject fo2) {
            return fo1.getName().compareTo(fo2.getName());
        }
    }

    private final class SourceGroupsChildren
    extends Children.Keys<Key> {
        private final SourceGroup[] groups;
        private final SourceGroup group;
        private final FileObject fo;

        public SourceGroupsChildren(SourceGroup[] groups) {
            this.groups = groups;
            this.fo = null;
            this.group = null;
        }

        public SourceGroupsChildren(FileObject fo, SourceGroup group) {
            this.fo = fo;
            this.group = group;
            this.groups = null;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        protected Node[] createNodes(Key key) {
            FileObject fObj = key.folder;
            SourceGroup grp = key.group;
            boolean isFile = !fObj.isFolder();
            try {
                DataObject dobj = DataObject.find((FileObject)fObj);
                FilterNode fn = new FilterNode(dobj.getNodeDelegate(), (Children)(isFile ? Children.LEAF : new SourceGroupsChildren(fObj, grp))){

                    public Action getPreferredAction() {
                        return null;
                    }
                };
                return new Node[]{fn};
            }
            catch (DataObjectNotFoundException e) {
                return null;
            }
        }

        private Collection<Key> getKeys() {
            ArrayList<Key> keys = null;
            if (this.groups != null) {
                keys = new ArrayList<Key>(this.groups.length);
                for (SourceGroup sg : this.groups) {
                    keys.add(new Key(sg.getRootFolder(), sg));
                }
            } else {
                FileObject[] children = this.fo.getChildren();
                Arrays.sort(children, FILE_OBJECT_COMAPARTOR);
                keys = new ArrayList(children.length);
                if (BrowseFolders.this.target == DataFolder.class) {
                    for (FileObject file : children) {
                        if (!file.isFolder() || !this.isVisible(file) || !this.group.contains(file)) continue;
                        keys.add(new Key(file, this.group));
                    }
                } else {
                    ArrayList<Key> dirs = new ArrayList<Key>(children.length);
                    ArrayList<Key> files = new ArrayList<Key>(children.length);
                    for (FileObject file : children) {
                        if (!this.isVisible(file) || !this.group.contains(file)) continue;
                        if (file.isFolder()) {
                            dirs.add(new Key(file, this.group));
                            continue;
                        }
                        files.add(new Key(file, this.group));
                    }
                    keys.addAll(dirs);
                    keys.addAll(files);
                }
            }
            return keys;
        }

        private boolean isVisible(FileObject fo) {
            assert (fo != null);
            if (fo.getNameExt().equals(BrowseFolders.NB_PROJECT_DIR)) {
                return false;
            }
            return BrowseFolders.this.phpVisibilityQuery.isVisible(fo);
        }

        private final class Key {
            final FileObject folder;
            final SourceGroup group;

            Key(FileObject folder, SourceGroup group) {
                this.folder = folder;
                this.group = group;
            }
        }
    }
}

