/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.util;

public final class SimpleTokenizer {
    protected String data;
    protected int length;
    protected char[] del;
    protected int cur = 0;

    public SimpleTokenizer(String data, String delimiters) {
        if (data == null || delimiters == null) {
            throw new IllegalArgumentException();
        }
        this.data = data;
        this.length = data.length();
        this.del = delimiters.toCharArray();
        this.skipDelimiters();
    }

    void skipToken() {
        while (this.cur < this.length && !this.curIsDelimiter()) {
            ++this.cur;
        }
    }

    void skipDelimiters() {
        while (this.cur < this.length && this.curIsDelimiter()) {
            ++this.cur;
        }
    }

    boolean curIsDelimiter() {
        char c = this.data.charAt(this.cur);
        for (int i = 0; i < this.del.length; ++i) {
            if (c != this.del[i]) continue;
            return true;
        }
        return false;
    }

    public String nextToken() {
        if (!this.hasMoreTokens()) {
            return null;
        }
        int s = this.cur++;
        this.skipToken();
        int e = this.cur;
        this.skipDelimiters();
        return this.data.substring(s, e);
    }

    public boolean hasMoreTokens() {
        return this.cur < this.length;
    }

    public int countTokens() {
        int n = 0;
        int tmpCur = this.cur;
        this.cur = 0;
        while (this.cur < this.length) {
            this.skipDelimiters();
            if (this.cur < this.length) {
                ++n;
            }
            this.skipToken();
        }
        this.cur = tmpCur;
        return n;
    }
}

