/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.PaintDef;
import com.sun.perseus.j2d.RadialGradientPaintDef;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.GradientElement;
import com.sun.perseus.model.TraitAnim;
import org.w3c.dom.DOMException;

public class RadialGradient
extends GradientElement {
    float cx = 0.5f;
    float cy = 0.5f;
    float r = 0.5f;

    public RadialGradient(DocumentNode ownerDocument) {
        super(ownerDocument);
    }

    public String getLocalName() {
        return "radialGradient";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new RadialGradient(doc);
    }

    public void setCx(float newCX) {
        if (newCX == this.cx) {
            return;
        }
        this.cx = newCX;
        this.onPaintChange();
    }

    public float getCx() {
        return this.cx;
    }

    public void setCy(float newCY) {
        if (newCY == this.cy) {
            return;
        }
        this.cy = newCY;
        this.onPaintChange();
    }

    public float getCy() {
        return this.cy;
    }

    public void setR(float newR) {
        if (newR == this.r) {
            return;
        }
        if (this.r < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.r = newR;
        this.onPaintChange();
    }

    public float getR() {
        return this.r;
    }

    boolean supportsTrait(String traitName) {
        if ("cx" == traitName || "r" == traitName || "cy" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("cx" == traitName || "r" == traitName || "cy" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        return super.createTraitAnimImpl(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("cx" == name) {
            return Float.toString(this.cx);
        }
        if ("cy" == name) {
            return Float.toString(this.cy);
        }
        if ("r" == name) {
            return Float.toString(this.r);
        }
        return super.getTraitImpl(name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("cx" == name) {
            return this.cx;
        }
        if ("cy" == name) {
            return this.cy;
        }
        if ("r" == name) {
            return this.r;
        }
        return super.getFloatTraitImpl(name);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("cx" == name) {
            this.setCx(value[0][0]);
        } else if ("cy" == name) {
            this.setCy(value[0][0]);
        } else if ("r" == name) {
            this.setR(value[0][0]);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("cx" == traitName || "cy" == traitName) {
            return new float[][]{{this.parseFloatTrait(traitName, value)}};
        }
        if ("r" == traitName) {
            return new float[][]{{this.parsePositiveFloatTrait(traitName, value)}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("cx" == name) {
            this.setCx(this.parseFloatTrait(name, value));
        } else if ("cy" == name) {
            this.setCy(this.parseFloatTrait(name, value));
        } else if ("r" == name) {
            this.setR(this.parsePositiveFloatTrait(name, value));
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        if ("cx" == name) {
            this.setCx(value);
        } else if ("cy" == name) {
            this.setCy(value);
        } else if ("r" == name) {
            this.checkPositive(name, value);
            this.setR(value);
        } else {
            super.setFloatTraitImpl(name, value);
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("cx" == name || "cy" == name || "r" == name) {
            return Float.toString(value[0][0]);
        }
        return super.toStringTrait(name, value);
    }

    protected PaintDef computePaint() {
        if (this.computedPaint == null) {
            this.buildGradientColorMap();
            this.computedPaint = new RadialGradientPaintDef(this.cx, this.cy, this.cx, this.cy, this.r, this.lastColorMapFractions, this.lastColorMapRGBA, 0, this.isObjectBBox, this.transform);
        }
        return this.computedPaint;
    }
}

